/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Strings;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Field;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.relauncher.Side;

public class ProxyInjector {
    public static void inject(ModContainer mod, ASMDataTable data, Side side, ILanguageAdapter languageAdapter) {
        FMLLog.log.debug("Attempting to inject @SidedProxy classes into {}", (Object)mod.getModId());
        SetMultimap<String, ASMDataTable.ASMData> modData = data.getAnnotationsFor(mod);
        Set mods = modData.get((Object)Mod.class.getName());
        Set targets = modData.get((Object)SidedProxy.class.getName());
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        for (ASMDataTable.ASMData targ : targets) {
            try {
                String targetType;
                String amodid = (String)targ.getAnnotationInfo().get("modId");
                if (Strings.isNullOrEmpty((String)amodid) && Strings.isNullOrEmpty((String)(amodid = ASMDataTable.getOwnerModID(mods, targ)))) {
                    FMLLog.bigWarning("Could not determine owning mod for @SidedProxy on {} for mod {}", targ.getClassName(), mod.getModId());
                    continue;
                }
                if (!mod.getModId().equals(amodid)) {
                    FMLLog.log.debug("Skipping proxy injection for {}.{} since it is not for mod {}", (Object)targ.getClassName(), (Object)targ.getObjectName(), (Object)mod.getModId());
                    continue;
                }
                Class<?> proxyTarget = Class.forName(targ.getClassName(), true, mcl);
                Field target = proxyTarget.getDeclaredField(targ.getObjectName());
                if (target == null) {
                    FMLLog.log.fatal("Attempted to load a proxy type into {}.{} but the field was not found", (Object)targ.getClassName(), (Object)targ.getObjectName());
                    throw new LoaderException(String.format("Attempted to load a proxy type into %s.%s but the field was not found", targ.getClassName(), targ.getObjectName()));
                }
                target.setAccessible(true);
                SidedProxy annotation = target.getAnnotation(SidedProxy.class);
                String string = targetType = side.isClient() ? annotation.clientSide() : annotation.serverSide();
                if (targetType.equals("")) {
                    targetType = targ.getClassName() + (side.isClient() ? "$ClientProxy" : "$ServerProxy");
                }
                Object proxy = Class.forName(targetType, true, mcl).newInstance();
                if (languageAdapter.supportsStatics() && (target.getModifiers() & 8) == 0) {
                    FMLLog.log.fatal("Attempted to load a proxy type {} into {}.{}, but the field is not static", (Object)targetType, (Object)targ.getClassName(), (Object)targ.getObjectName());
                    throw new LoaderException(String.format("Attempted to load a proxy type %s into %s.%s, but the field is not static", targetType, targ.getClassName(), targ.getObjectName()));
                }
                if (!target.getType().isAssignableFrom(proxy.getClass())) {
                    FMLLog.log.fatal("Attempted to load a proxy type {} into {}.{}, but the types don't match", (Object)targetType, (Object)targ.getClassName(), (Object)targ.getObjectName());
                    throw new LoaderException(String.format("Attempted to load a proxy type %s into %s.%s, but the types don't match", targetType, targ.getClassName(), targ.getObjectName()));
                }
                languageAdapter.setProxy(target, proxyTarget, proxy);
            }
            catch (Exception e2) {
                FMLLog.log.error("An error occurred trying to load a proxy into {}.{}", (Object)targ.getClassName(), (Object)targ.getObjectName(), (Object)e2);
                throw new LoaderException(e2);
            }
        }
        languageAdapter.setInternalProxies(mod, side, mcl);
    }
}

