/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ForgeBlockStateV1.class, (Object)ForgeBlockStateV1.Deserializer.INSTANCE).registerTypeAdapter(ForgeBlockStateV1.Variant.class, (Object)ForgeBlockStateV1.Variant.Deserializer.INSTANCE).registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();

    public static bvv load(Reader reader, nf location, Gson vanillaGSON) {
        try {
            byte[] data = IOUtils.toByteArray((Reader)reader, (Charset)StandardCharsets.UTF_8);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8);
            Marker marker = (Marker)GSON.fromJson(new String(data, StandardCharsets.UTF_8), Marker.class);
            switch (marker.forge_marker) {
                case 1: {
                    ForgeBlockStateV1 v1 = (ForgeBlockStateV1)GSON.fromJson(reader, ForgeBlockStateV1.class);
                    LinkedHashMap variants = Maps.newLinkedHashMap();
                    for (Map.Entry entry : v1.variants.asMap().entrySet()) {
                        ArrayList mcVars = Lists.newArrayList();
                        for (ForgeBlockStateV1.Variant var : (Collection)entry.getValue()) {
                            boolean uvLock = var.getUvLock().orElse(false);
                            int weight = var.getWeight().orElse(1);
                            if (var.isVanillaCompatible()) {
                                mcVars.add(new bwe(var.getModel(), (cfz)var.getState().orElse((IModelState)cfz.a), uvLock, weight));
                                continue;
                            }
                            mcVars.add(new ForgeVariant(location, var.getModel(), var.getState().orElse(TRSRTransformation.identity()), uvLock, var.getSmooth(), var.getGui3d(), weight, var.getTextures(), var.getOnlyPartsVariant(), var.getCustomData()));
                        }
                        variants.put(entry.getKey(), new bwd((List)mcVars));
                    }
                    return new bvv((Map)variants, null);
                }
            }
            return (bvv)vanillaGSON.fromJson(reader, bvv.class);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static class ForgeVariant
    extends bwe
    implements ISmartVariant {
        private final nf blockstateLocation;
        private final ImmutableMap<String, String> textures;
        private final ImmutableMap<String, SubModel> parts;
        private final ImmutableMap<String, String> customData;
        private final Optional<Boolean> smooth;
        private final Optional<Boolean> gui3d;
        private final IModelState state;

        ForgeVariant(nf blockstateLocation, @Nullable nf model, IModelState state, boolean uvLock, Optional<Boolean> smooth, Optional<Boolean> gui3d, int weight, ImmutableMap<String, String> textures, ImmutableMap<String, SubModel> parts, ImmutableMap<String, String> customData) {
            super(model == null ? new nf("builtin/missing") : model, state instanceof cfz ? (cfz)state : cfz.a, uvLock, weight);
            this.blockstateLocation = blockstateLocation;
            this.textures = textures;
            this.parts = parts;
            this.customData = customData;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
        }

        private IModel runModelHooks(IModel base, Optional<Boolean> smooth, Optional<Boolean> gui3d, boolean uvlock, ImmutableMap<String, String> textureMap, ImmutableMap<String, String> customData) {
            base = base.process(customData);
            base = base.retexture(textureMap);
            base = smooth.map(base::smoothLighting).orElse(base);
            base = gui3d.map(base::gui3d).orElse(base);
            base = base.uvlock(uvlock);
            return base;
        }

        @Override
        public IModel process(IModel base) {
            boolean hasBase;
            int size = this.parts.size();
            boolean bl = hasBase = base != ModelLoaderRegistry.getMissingModel();
            if (hasBase) {
                base = this.runModelHooks(base, this.smooth, this.gui3d, this.c(), this.textures, this.customData);
                if (size <= 0) {
                    return base;
                }
            }
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry entry : this.parts.entrySet()) {
                IModel model;
                SubModel part = (SubModel)entry.getValue();
                nf modelLocation = part.getModelLocation();
                if (modelLocation == null) {
                    FMLLog.log.error("model not found for variant {} for blockstate {}", entry.getKey(), (Object)this.blockstateLocation);
                    model = ModelLoaderRegistry.getMissingModel(this.blockstateLocation, new Throwable());
                } else {
                    model = ModelLoaderRegistry.getModelOrLogError(modelLocation, "Unable to load block sub-model: '" + modelLocation);
                }
                models.put(entry.getKey(), (Object)Pair.of((Object)this.runModelHooks(model, Optional.of(part.smooth), Optional.of(part.gui3d), part.uvLock, part.getTextures(), part.getCustomData()), (Object)part.getState()));
            }
            return new MultiModel(this.a(), hasBase ? base : null, (ImmutableMap<String, Pair<IModel, IModelState>>)models.build());
        }

        public IModelState getState() {
            return this.state;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("TexturedVariant:");
            for (Map.Entry e2 : this.textures.entrySet()) {
                buf.append(" ").append((String)e2.getKey()).append(" = ").append((String)e2.getValue());
            }
            return buf.toString();
        }
    }

    public static class SubModel {
        private final IModelState state;
        private final boolean uvLock;
        private final boolean smooth;
        private final boolean gui3d;
        private final ImmutableMap<String, String> textures;
        @Nullable
        private final nf model;
        private final ImmutableMap<String, String> customData;

        public SubModel(IModelState state, boolean uvLock, boolean smooth, boolean gui3d, ImmutableMap<String, String> textures, @Nullable nf model, ImmutableMap<String, String> customData) {
            this.state = state;
            this.uvLock = uvLock;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.textures = textures;
            this.model = model;
            this.customData = customData;
        }

        public IModelState getState() {
            return this.state;
        }

        public boolean isUVLock() {
            return this.uvLock;
        }

        public ImmutableMap<String, String> getTextures() {
            return this.textures;
        }

        @Nullable
        public nf getModelLocation() {
            return this.model;
        }

        public ImmutableMap<String, String> getCustomData() {
            return this.customData;
        }
    }

    public static class Marker {
        public int forge_marker = -1;
    }
}

