/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import red.mohist.util.TileEntity;
import red.mohist.util.i18n.Message;

public class TileEntityCommand
extends Command {
    private List<String> params = Arrays.asList("reload", "dump-all", "dump-existing");

    public TileEntityCommand(String name) {
        super(name);
        this.description = "TileEntity tick limiting commands";
        this.usageMessage = "/tileentity [reload|dump-all|dump-existing]";
        this.setPermission("mohist.command.tileentity");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.isOp() || !this.testPermission(sender)) {
            sender.sendMessage(Message.getString("command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "reload": {
                MinecraftServer.tileEntityConfig.load();
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "tileentity.yml reload complete.");
                break;
            }
            case "dump-existing": {
                MinecraftServer.tileEntityConfig.save();
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "tileentity.yml updated with found TileEntities");
                break;
            }
            case "dump-all": {
                Iterator i2 = avj.getRegisteredTileEntities().iterator();
                for (Object rl2 : avj.getRegisteredTileEntities().c()) {
                    nf a2 = (nf)rl2;
                    MinecraftServer.k.info("Found TileEntity with name: " + TileEntity.sanitizeClassName((Class)avj.getRegisteredTileEntities().c(rl2)));
                }
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Found TileEntity names dumped to console.");
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }
}

