/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.util.i18n;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Properties;

public class UTF8Properties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private LinkedHashMap<String, String> commentMap = new LinkedHashMap();

    public UTF8Properties() {
    }

    public UTF8Properties(Properties properties) {
        super(properties);
        for (Object key : properties.keySet()) {
            this.commentMap.put((String)key, null);
        }
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        bw.write("#");
        bw.write(comments);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public boolean addComment(String key, String comment) {
        if (this.contains(key)) {
            this.commentMap.put(key, comment);
            return true;
        }
        return false;
    }

    public void put(String key, String value, String comment) {
        this.commentMap.put(key, comment);
        this.setProperty(key, value);
    }

    @Override
    public void put(String key, String value) {
        this.setProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderStore(Writer writer, String comments) throws IOException {
        BufferedWriter bufferedWriter;
        BufferedWriter bufferedWriter2 = bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        if (comments != null) {
            UTF8Properties.writeComments(bufferedWriter, comments);
        }
        UTF8Properties uTF8Properties = this;
        synchronized (uTF8Properties) {
            for (String key : this.commentMap.keySet()) {
                String value = this.getProperty(key);
                String comment = this.commentMap.get(key);
                key = this.saveConvert(key, true);
                value = this.saveConvert(value, false);
                key = this.saveConvert(key, true);
                if (comment != null && !comment.equals("")) {
                    UTF8Properties.writeComments(bufferedWriter, comment);
                }
                bufferedWriter.write(key + "=" + value);
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.flush();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }
}

