/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.EnumHelper;

public class BiomeManager {
    private static TrackedList<BiomeEntry>[] biomes = BiomeManager.setupBiomes();
    public static List<anh> oceanBiomes = new ArrayList<anh>();
    public static ArrayList<anh> strongHoldBiomes = new ArrayList();
    public static ArrayList<anh> strongHoldBiomesBlackList = new ArrayList();

    private static TrackedList<BiomeEntry>[] setupBiomes() {
        TrackedList[] currentBiomes = new TrackedList[BiomeType.values().length];
        ArrayList<BiomeEntry> list = new ArrayList<BiomeEntry>();
        list.add(new BiomeEntry(anm.f, 10));
        list.add(new BiomeEntry(anm.E, 10));
        list.add(new BiomeEntry(anm.e, 10));
        list.add(new BiomeEntry(anm.c, 10));
        list.add(new BiomeEntry(anm.C, 10));
        list.add(new BiomeEntry(anm.h, 10));
        currentBiomes[BiomeType.WARM.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(anm.f, 10));
        list.add(new BiomeEntry(anm.e, 10));
        list.add(new BiomeEntry(anm.g, 10));
        list.add(new BiomeEntry(anm.c, 10));
        currentBiomes[BiomeType.COOL.ordinal()] = new TrackedList(list);
        list.clear();
        list.add(new BiomeEntry(anm.n, 30));
        list.add(new BiomeEntry(anm.F, 10));
        currentBiomes[BiomeType.ICY.ordinal()] = new TrackedList(list);
        list.clear();
        currentBiomes[BiomeType.DESERT.ordinal()] = new TrackedList(list);
        return currentBiomes;
    }

    public static void addVillageBiome(anh biome, boolean canSpawn) {
        if (!bca.a.contains(biome)) {
            ArrayList<anh> biomes = new ArrayList<anh>(bca.a);
            biomes.add(biome);
            bca.a = biomes;
        }
    }

    public static void removeVillageBiome(anh biome) {
        if (bca.a.contains(biome)) {
            ArrayList biomes = new ArrayList(bca.a);
            biomes.remove(biome);
            bca.a = biomes;
        }
    }

    public static void addStrongholdBiome(anh biome) {
        if (!strongHoldBiomes.contains(biome)) {
            strongHoldBiomes.add(biome);
        }
    }

    public static void removeStrongholdBiome(anh biome) {
        if (!strongHoldBiomesBlackList.contains(biome)) {
            strongHoldBiomesBlackList.add(biome);
        }
    }

    public static void addSpawnBiome(anh biome) {
        if (!anl.allowedBiomes.contains(biome)) {
            anl.allowedBiomes.add(biome);
        }
    }

    public static void removeSpawnBiome(anh biome) {
        if (anl.allowedBiomes.contains(biome)) {
            anl.allowedBiomes.remove(biome);
        }
    }

    public static void addBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            list.add(entry);
        }
    }

    public static void removeBiome(BiomeType type, BiomeEntry entry) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null && list.contains((Object)entry)) {
            list.remove((Object)entry);
        }
    }

    @Nullable
    public static ImmutableList<BiomeEntry> getBiomes(BiomeType type) {
        int idx = type.ordinal();
        TrackedList<BiomeEntry> list = idx >= biomes.length ? null : biomes[idx];
        return list != null ? ImmutableList.copyOf(list) : null;
    }

    public static boolean isTypeListModded(BiomeType type) {
        TrackedList<BiomeEntry> list;
        int idx = type.ordinal();
        TrackedList<BiomeEntry> trackedList = list = idx > biomes.length ? null : biomes[idx];
        if (list != null) {
            return list.isModded();
        }
        return false;
    }

    static /* synthetic */ TrackedList[] access$002(TrackedList[] x0) {
        biomes = x0;
        return x0;
    }

    static {
        oceanBiomes.add(anm.a);
        oceanBiomes.add(anm.z);
        oceanBiomes.add(anm.l);
    }

    private static class TrackedList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean isModded = false;

        public TrackedList(Collection<? extends E> c2) {
            super(c2);
        }

        @Override
        public E set(int index, E element) {
            this.isModded = true;
            return super.set(index, element);
        }

        @Override
        public boolean add(E e2) {
            this.isModded = true;
            return super.add(e2);
        }

        @Override
        public void add(int index, E element) {
            this.isModded = true;
            super.add(index, element);
        }

        @Override
        public E remove(int index) {
            this.isModded = true;
            return super.remove(index);
        }

        @Override
        public boolean remove(Object o) {
            this.isModded = true;
            return super.remove(o);
        }

        @Override
        public void clear() {
            this.isModded = true;
            super.clear();
        }

        @Override
        public boolean addAll(Collection<? extends E> c2) {
            this.isModded = true;
            return super.addAll(c2);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c2) {
            this.isModded = true;
            return super.addAll(index, c2);
        }

        @Override
        public boolean removeAll(Collection<?> c2) {
            this.isModded = true;
            return super.removeAll(c2);
        }

        @Override
        public boolean retainAll(Collection<?> c2) {
            this.isModded = true;
            return super.retainAll(c2);
        }

        public boolean isModded() {
            return this.isModded;
        }
    }

    public static class BiomeEntry
    extends rs.a {
        public final anh biome;

        public BiomeEntry(anh biome, int weight) {
            super(weight);
            this.biome = biome;
        }
    }

    public static enum BiomeType {
        DESERT,
        WARM,
        COOL,
        ICY;


        public static BiomeType getType(String name) {
            name = name.toUpperCase();
            for (BiomeType t : BiomeType.values()) {
                if (!t.name().equals(name)) continue;
                return t;
            }
            BiomeType ret = EnumHelper.addEnum(BiomeType.class, name, new Class[0], new Object[0]);
            if (ret.ordinal() >= biomes.length) {
                BiomeManager.access$002(Arrays.copyOf(biomes, ret.ordinal() + 1));
            }
            return ret;
        }
    }
}

