/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModContainerFactory;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ITypeDiscoverer;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.asm.ASMModParser;
import net.minecraftforge.fml.common.discovery.json.JsonAnnotationLoader;
import org.objectweb.asm.Type;

public class JarDiscoverer
implements ITypeDiscoverer {
    private static final boolean ENABLE_JSON_TEST = "true".equals(System.getProperty("fml.enableJsonAnnotations", "false"));

    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList foundMods = Lists.newArrayList();
        FMLLog.log.debug("Examining file {} for potential mods", (Object)candidate.getModContainer().getName());
        try (JarFile jar = new JarFile(candidate.getModContainer());){
            ZipEntry modInfo = jar.getEntry("mcmod.info");
            MetadataCollection mc = null;
            if (modInfo != null) {
                FMLLog.log.trace("Located mcmod.info file in file {}", (Object)candidate.getModContainer().getName());
                try (InputStream inputStream = jar.getInputStream(modInfo);){
                    mc = MetadataCollection.from(inputStream, candidate.getModContainer().getName());
                }
            } else {
                FMLLog.log.debug("The mod container {} appears to be missing an mcmod.info file", (Object)candidate.getModContainer().getName());
                mc = MetadataCollection.from(null, "");
            }
            if (ENABLE_JSON_TEST && jar.getEntry("META-INF/fml_cache_annotation.json") != null) {
                this.findClassesJSON(candidate, table, jar, foundMods, mc);
            } else {
                this.findClassesASM(candidate, table, jar, foundMods, mc);
            }
        }
        catch (Exception e2) {
            FMLLog.log.warn("Zip file {} failed to read properly, it will be ignored", (Object)candidate.getModContainer().getName(), (Object)e2);
        }
        return foundMods;
    }

    private void findClassesASM(ModCandidate candidate, ASMDataTable table, JarFile jar, List<ModContainer> foundMods, MetadataCollection mc) throws IOException {
        for (ZipEntry zipEntry : Collections.list(jar.entries())) {
            ASMModParser modParser;
            Matcher match;
            if (zipEntry.getName() != null && zipEntry.getName().startsWith("__MACOSX") || !(match = classFile.matcher(zipEntry.getName())).matches()) continue;
            try {
                try (InputStream inputStream = jar.getInputStream(zipEntry);){
                    modParser = new ASMModParser(inputStream);
                }
                candidate.addClassEntry(zipEntry.getName());
            }
            catch (LoaderException e2) {
                FMLLog.log.error("There was a problem reading the entry {} in the jar {} - probably a corrupt zip", (Object)zipEntry.getName(), (Object)candidate.getModContainer().getPath(), (Object)e2);
                jar.close();
                throw e2;
            }
            modParser.validate();
            modParser.sendToTable(table, candidate);
            ModContainer container = ModContainerFactory.instance().build(modParser, candidate.getModContainer(), candidate);
            if (container == null) continue;
            table.addContainer(container);
            foundMods.add(container);
            container.bindMetadata(mc);
            container.setClassVersion(modParser.getClassVersion());
        }
    }

    private void findClassesJSON(ModCandidate candidate, ASMDataTable table, JarFile jar, List<ModContainer> foundMods, MetadataCollection mc) throws IOException {
        FMLLog.log.info("Loading jar {} annotation data from json", (Object)candidate.getModContainer().getPath());
        ZipEntry json = jar.getEntry("META-INF/fml_cache_annotation.json");
        Multimap<String, ASMDataTable.ASMData> annos = JsonAnnotationLoader.loadJson(jar.getInputStream(json), candidate, table);
        for (ZipEntry zipEntry : Collections.list(jar.entries())) {
            if (zipEntry.getName().startsWith("__MACOSX") || zipEntry.getName().startsWith("META-INF/") || !zipEntry.getName().endsWith(".class")) continue;
            candidate.addClassEntry(zipEntry.getName());
        }
        for (Map.Entry entry : ModContainerFactory.modTypes.entrySet()) {
            Type type = (Type)entry.getKey();
            Constructor ctr = (Constructor)entry.getValue();
            for (ASMDataTable.ASMData data : annos.get((Object)type.getClassName())) {
                FMLLog.log.debug("Identified a mod of type {} ({}) - loading", (Object)type.getClassName(), (Object)data.getClassName());
                try {
                    ModContainer ret = (ModContainer)ctr.newInstance(data.getClassName(), candidate, data.getAnnotationInfo());
                    if (!ret.shouldLoadInEnvironment()) {
                        FMLLog.log.debug("Skipping mod {}, container opted to not load.", (Object)data.getClassName());
                        continue;
                    }
                    table.addContainer(ret);
                    foundMods.add(ret);
                    ret.bindMetadata(mc);
                }
                catch (Exception e3) {
                    FMLLog.log.error("Unable to construct {} container", (Object)data.getClassName(), (Object)e3);
                }
            }
        }
    }
}

