/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.TextTable;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderExceptionModCrash;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLLoadEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.FMLThrowingEventBus;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.FormattedMessage;

public class LoadController {
    private Loader loader;
    private EventBus masterChannel;
    private ImmutableMap<String, EventBus> eventChannels;
    private LoaderState state;
    private Multimap<String, LoaderState.ModState> modStates = MultimapBuilder.hashKeys().enumSetValues(LoaderState.ModState.class).build();
    private List<ModContainer> activeModList = Lists.newArrayList();
    private ModContainer activeContainer;
    private BiMap<ModContainer, Object> modObjectList;
    private ListMultimap<String, ModContainer> packageOwners;
    private FMLSecurityManager accessibleManager = new FMLSecurityManager();

    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new FMLThrowingEventBus((exception, context) -> {
            Throwables.throwIfUnchecked((Throwable)exception);
            Method method = context.getSubscriberMethod();
            String parameterNames = Stream.of(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", "));
            String message = "Exception thrown during LoadController." + method.getName() + '(' + parameterNames + ')';
            throw new LoaderExceptionModCrash(message, exception);
        });
        this.masterChannel.register((Object)this);
        this.state = LoaderState.NOINIT;
        this.packageOwners = ArrayListMultimap.create();
    }

    void disableMod(ModContainer mod) {
        HashMap temporary = Maps.newHashMap(this.eventChannels);
        String modId = mod.getModId();
        EventBus bus2 = (EventBus)temporary.remove(modId);
        bus2.post((Object)new FMLModDisabledEvent());
        this.eventChannels = ImmutableMap.copyOf((Map)temporary);
        this.modStates.put((Object)modId, (Object)LoaderState.ModState.DISABLED);
        this.modObjectList.remove((Object)mod);
        this.activeModList.remove(mod);
    }

    @Subscribe
    public void buildModList(FMLLoadEvent event) {
        ImmutableMap.Builder eventBus = ImmutableMap.builder();
        for (ModContainer mod : this.loader.getModList()) {
            FMLThrowingEventBus bus2;
            boolean isActive = mod.registerBus(bus2 = new FMLThrowingEventBus((exception, context) -> this.errorOccurred(mod, exception)), this);
            if (isActive) {
                this.activeModList.add(mod);
                this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.LOADED);
                eventBus.put((Object)mod.getModId(), (Object)bus2);
                FMLCommonHandler.instance().addModToResourcePack(mod);
                continue;
            }
            FMLLog.log.warn("Mod {} has been disabled through configuration", (Object)mod.getModId());
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.UNLOADED);
            this.modStates.put((Object)mod.getModId(), (Object)LoaderState.ModState.DISABLED);
        }
        this.eventChannels = eventBus.build();
    }

    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post((Object)state.getEvent(eventData));
        }
    }

    public void transition(LoaderState desiredState, boolean forceState) {
        if (FMLCommonHandler.instance().isDisplayCloseRequested()) {
            FMLLog.log.info("The game window is being closed by the player, exiting.");
            FMLCommonHandler.instance().exitJava(0, false);
        }
        LoaderState oldState = this.state;
        this.state = this.state.transition(false);
        if (this.state != desiredState) {
            if (!forceState) {
                FormattedMessage message = new FormattedMessage("A fatal error occurred during the state transition from {} to {}. State became {} instead. Loading cannot continue.", new Object[]{oldState, desiredState, this.state});
                throw new LoaderException(message.getFormattedMessage());
            }
            FMLLog.log.info("The state engine was in incorrect state {} and forced into state {}. Errors may have been discarded.", (Object)this.state, (Object)desiredState);
            this.forceState(desiredState);
        }
    }

    @Deprecated
    public void checkErrorsAfterAvailable() {
    }

    @Deprecated
    public void checkErrors() {
    }

    @Nullable
    public ModContainer activeContainer() {
        return this.activeContainer != null ? this.activeContainer : this.findActiveContainerFromStack();
    }

    void forceActiveContainer(@Nullable ModContainer container) {
        this.activeContainer = container;
    }

    @Subscribe
    public void propogateStateMessage(FMLEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        ProgressManager.ProgressBar bar = ProgressManager.push(stateEvent.description(), this.activeModList.size(), true);
        for (ModContainer mc : this.activeModList) {
            bar.step(mc.getName());
            this.sendEventToModContainer(stateEvent, mc);
        }
        ProgressManager.pop(bar);
    }

    private void sendEventToModContainer(FMLEvent stateEvent, ModContainer mc) {
        String modId = mc.getModId();
        Collection requirements = mc.getRequirements().stream().map(ArtifactVersion::getLabel).collect(Collectors.toCollection(HashSet::new));
        for (ArtifactVersion av : mc.getDependencies()) {
            if (av.getLabel() == null || !requirements.contains(av.getLabel()) || !this.modStates.containsEntry((Object)av.getLabel(), (Object)LoaderState.ModState.ERRORED)) continue;
            FMLLog.log.error("Skipping event {} and marking errored mod {} since required dependency {} has errored", (Object)stateEvent.getEventType(), (Object)modId, (Object)av.getLabel());
            this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
            return;
        }
        this.activeContainer = mc;
        stateEvent.applyModContainer(mc);
        ThreadContext.put((String)"mod", (String)modId);
        FMLLog.log.trace("Sending event {} to mod {}", (Object)stateEvent.getEventType(), (Object)modId);
        ((EventBus)this.eventChannels.get((Object)modId)).post((Object)stateEvent);
        FMLLog.log.trace("Sent event {} to mod {}", (Object)stateEvent.getEventType(), (Object)modId);
        ThreadContext.remove((String)"mod");
        this.activeContainer = null;
        if (stateEvent instanceof FMLStateEvent) {
            this.modStates.put((Object)modId, (Object)((FMLStateEvent)stateEvent).getModState());
        }
    }

    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer mc : this.activeModList) {
            if (!mc.isImmutable() && mc.getMod() != null) {
                builder.put((Object)mc, mc.getMod());
                List<String> packages = mc.getOwnedPackages();
                for (String pkg : packages) {
                    this.packageOwners.put((Object)pkg, (Object)mc);
                }
            }
            if (mc.getMod() != null || mc.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FormattedMessage message = new FormattedMessage("There is a severe problem with {} ({}) - it appears not to have constructed correctly", (Object)mc.getName(), (Object)mc.getModId());
            this.errorOccurred(mc, new RuntimeException(message.getFormattedMessage()));
        }
        return builder.build();
    }

    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        String modId = modContainer.getModId();
        String modName = modContainer.getName();
        this.modStates.put((Object)modId, (Object)LoaderState.ModState.ERRORED);
        if (exception instanceof InvocationTargetException) {
            exception = exception.getCause();
        }
        if (exception instanceof LoaderException) {
            throw (LoaderException)exception;
        }
        FormattedMessage message = new FormattedMessage("Caught exception from {} ({})", (Object)modName, (Object)modId);
        throw new LoaderExceptionModCrash(message.getFormattedMessage(), exception);
    }

    public void printModStates(StringBuilder ret) {
        ret.append("\n\tStates:");
        for (LoaderState.ModState state : LoaderState.ModState.values()) {
            ret.append(" '").append(state.getMarker()).append("' = ").append(state.toString());
        }
        TextTable table = new TextTable(Lists.newArrayList((Object[])new TextTable.Column[]{TextTable.column("State"), TextTable.column("ID"), TextTable.column("Version"), TextTable.column("Source"), TextTable.column("Signature")}));
        for (ModContainer mc : this.loader.getModList()) {
            table.add(this.modStates.get((Object)mc.getModId()).stream().map(LoaderState.ModState::getMarker).reduce("", (a2, b2) -> a2 + b2), mc.getModId(), mc.getVersion(), mc.getSource().getName(), mc.getSigningCertificate() != null ? CertificateHelper.getFingerprint(mc.getSigningCertificate()) : "None");
        }
        ret.append("\n");
        ret.append("\n\t");
        table.append(ret, "\n\t");
        ret.append("\n");
    }

    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return (LoaderState.ModState)((Object)Iterables.getLast((Iterable)this.modStates.get((Object)selectedMod.getModId()), (Object)((Object)LoaderState.ModState.AVAILABLE)));
    }

    public void distributeStateMessage(Class<?> customEvent) {
        Object eventInstance;
        try {
            eventInstance = customEvent.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e2) {
            throw new LoaderException("Failed to create new event instance for " + customEvent.getName(), e2);
        }
        this.masterChannel.post(eventInstance);
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.log.fatal("Detected an attempt by a mod {} to perform game activity during mod construction. This is a serious programming error.", (Object)this.activeContainer);
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    public boolean isInState(LoaderState state) {
        return this.state == state;
    }

    boolean hasReachedState(LoaderState state) {
        return this.state.ordinal() >= state.ordinal() && this.state != LoaderState.ERRORED;
    }

    void forceState(LoaderState newState) {
        this.state = newState;
    }

    @Nullable
    private ModContainer findActiveContainerFromStack() {
        for (Class<?> c2 : this.getCallingStack()) {
            String pkg;
            int idx = c2.getName().lastIndexOf(46);
            if (idx == -1 || !this.packageOwners.containsKey((Object)(pkg = c2.getName().substring(0, idx)))) continue;
            return (ModContainer)this.packageOwners.get((Object)pkg).get(0);
        }
        return null;
    }

    Class<?>[] getCallingStack() {
        return this.accessibleManager.getStackClasses();
    }

    LoaderState getState() {
        return this.state;
    }

    class FMLSecurityManager
    extends SecurityManager {
        FMLSecurityManager() {
        }

        Class<?>[] getStackClasses() {
            return this.getClassContext();
        }
    }
}

