/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class AsyncTabCompleteEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final CommandSender sender;
    private final String buffer;
    private final boolean isCommand;
    private final Location loc;
    private List<String> completions;
    private boolean cancelled;
    private boolean handled = false;
    private boolean fireSyncHandler = true;

    public AsyncTabCompleteEvent(CommandSender sender, List<String> completions, String buffer, boolean isCommand, Location loc) {
        super(true);
        this.sender = sender;
        this.completions = completions;
        this.buffer = buffer;
        this.isCommand = isCommand;
        this.loc = loc;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public List<String> getCompletions() {
        return this.completions;
    }

    public void setCompletions(List<String> completions) {
        Validate.notNull(completions);
        this.completions = new ArrayList<String>(completions);
    }

    public String getBuffer() {
        return this.buffer;
    }

    public boolean isCommand() {
        return this.isCommand;
    }

    public Location getLocation() {
        return this.loc;
    }

    public boolean isHandled() {
        return !this.completions.isEmpty() || this.handled;
    }

    public void setHandled(boolean handled) {
        this.handled = handled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }
}

