/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.world;

import co.aikar.timings.Timing;
import com.destroystokyo.paper.MCUtil;
import com.destroystokyo.paper.PaperMCConfig;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.ArrayDeque;
import net.minecraft.server.MinecraftServer;

public class PaperLightingQueue {
    private static final long MAX_TIME = 57499999L;

    public static void processQueue(long curTime) {
        long startTime = System.nanoTime();
        long maxTickTime = 57499999L - (startTime - curTime);
        if (maxTickTime <= 0L) {
            return;
        }
        block0: for (oo world : MinecraftServer.getServerInst().d) {
            if (!PaperMCConfig.queueLightUpdates) continue;
            ObjectCollection loadedChunks = world.r().e.values();
            for (axw chunk : (axw[])loadedChunks.toArray((Object[])new axw[0])) {
                if (chunk.lightingQueue.processQueue(startTime, maxTickTime)) break block0;
            }
        }
    }

    public static class LightingQueue
    extends ArrayDeque<Runnable> {
        private final axw chunk;

        public LightingQueue(axw chunk) {
            this.chunk = chunk;
        }

        public boolean processQueue(long startTime, long maxTickTime) {
            if (this.isEmpty()) {
                return false;
            }
            if (LightingQueue.isOutOfTime(maxTickTime, startTime)) {
                // empty if block
            }
            try (Timing ignored = this.chunk.k.timings.lightingQueueTimer.startTiming();){
                Runnable lightUpdate;
                while ((lightUpdate = (Runnable)this.poll()) != null) {
                    lightUpdate.run();
                    if (!LightingQueue.isOutOfTime(maxTickTime, startTime)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        public void processUnload() {
            if (!PaperMCConfig.queueLightUpdates) {
                return;
            }
            this.processQueue(0L, 0L);
            boolean radius = true;
            for (int x = this.chunk.b - 1; x <= this.chunk.b + 1; ++x) {
                for (int z = this.chunk.c - 1; z <= this.chunk.c + 1; ++z) {
                    axw neighbor;
                    if (x == this.chunk.b && z == this.chunk.c || (neighbor = MCUtil.getLoadedChunkWithoutMarkingActive(this.chunk.k, x, z)) == null) continue;
                    neighbor.lightingQueue.processQueue(0L, 0L);
                }
            }
        }

        private static boolean isOutOfTime(long maxTickTime, long startTime) {
            return startTime > 0L && System.nanoTime() - startTime > maxTickTime;
        }
    }
}

