/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.GameProfile;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.util.Waitable;
import org.bukkit.entity.Entity;
import org.spigotmc.AsyncCatcher;

public final class MCUtil {
    private MCUtil() {
    }

    public static String stack() {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable());
    }

    public static String stack(String str) {
        return ExceptionUtils.getFullStackTrace((Throwable)new Throwable(str));
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (AsyncCatcher.enabled && Thread.currentThread() != MinecraftServer.getServerInst().primaryThread) {
            new IllegalStateException("Asynchronous " + reason + "! Blocking thread until it returns ").printStackTrace();
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MinecraftServer.getServerInst().processQueue.add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        return run.get();
    }

    public static PlayerProfile toBukkit(GameProfile profile) {
        return CraftPlayerProfile.asBukkitMirror(profile);
    }

    public static double distance(vg e1, vg e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(et e1, et e2) {
        return Math.sqrt(MCUtil.distanceSq(e1, e2));
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(vg e1, vg e2) {
        return MCUtil.distanceSq(e1.p, e1.q, e1.r, e2.p, e2.q, e2.r);
    }

    public static double distanceSq(et pos1, et pos2) {
        return MCUtil.distanceSq(pos1.p(), pos1.q(), pos1.r(), pos2.p(), pos2.q(), pos2.r());
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    public static Location toLocation(amu world, double x, double y, double z) {
        return new Location(world.getWorld(), x, y, z);
    }

    public static Location toLocation(amu world, et pos) {
        return new Location(world.getWorld(), pos.p(), pos.q(), pos.r());
    }

    public static Location toLocation(vg entity) {
        return new Location(entity.e().getWorld(), entity.p, entity.q, entity.r);
    }

    public static et toBlockPosition(Location loc) {
        return new et(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public static boolean isEdgeOfChunk(et pos) {
        int modX = pos.p() & 0xF;
        int modZ = pos.r() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    @Nullable
    public static avw getHopper(amu world, et pos) {
        avj tileEntity;
        axw chunk = world.getChunkIfLoaded(pos.p() >> 4, pos.r() >> 4);
        if (chunk != null && chunk.a(pos).u() == aox.cp && (tileEntity = chunk.a(pos, axw.a.a)) instanceof avw) {
            return (avw)tileEntity;
        }
        return null;
    }

    @Nonnull
    public static amu getNMSWorld(@Nonnull World world) {
        return ((CraftWorld)world).getHandle();
    }

    public static amu getNMSWorld(@Nonnull Entity entity) {
        return MCUtil.getNMSWorld(entity.getWorld());
    }

    @Nullable
    public static axw getLoadedChunkWithoutMarkingActive(amu world, int x, int z) {
        return (axw)((on)world.v).e.get(amn.a((int)x, (int)z));
    }

    @Nullable
    public static axw getLoadedChunkWithoutMarkingActive(axr provider, int x, int z) {
        return (axw)((on)provider).e.get(amn.a((int)x, (int)z));
    }
}

