/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mohistmc.MohistMC;
import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.NetworkUtil;
import com.mohistmc.util.i18n.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;

public class UpdateUtils {
    private static int percentage = 0;

    public static void versionCheck() {
        System.out.println(Message.getString("update.check"));
        System.out.println(Message.getString("update.stopcheck"));
        try {
            JsonElement root = new JsonParser().parse((Reader)new InputStreamReader(NetworkUtil.getInput("https://ci.codemc.io/job/Mohist-Community/job/Mohist-1.12.2/lastSuccessfulBuild/api/json")));
            String jar_sha = MohistMC.getVersion();
            String build_number = "1.12.2-" + root.getAsJsonObject().get("number").toString();
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(root.getAsJsonObject().get("timestamp").toString())));
            if (jar_sha.equals(build_number)) {
                System.out.println(Message.getFormatString("update.latest", new Object[]{"1.9", jar_sha, build_number}));
            } else {
                System.out.println(Message.getFormatString("update.detect", new Object[]{build_number, jar_sha, time}));
                if (MohistConfigUtil.bMohist("check_update_auto_download")) {
                    UpdateUtils.downloadFile("https://ci.codemc.io/job/Mohist-Community/job/Mohist-1.12.2/lastSuccessfulBuild/artifact/projects/mohist/build/libs/mohist-" + build_number + "-server.jar", new File(UpdateUtils.getMohistJar().getName()));
                    UpdateUtils.restartServer(new ArrayList<String>(Arrays.asList("java", "-jar", UpdateUtils.getMohistJar().getName())));
                }
            }
        }
        catch (Throwable e2) {
            System.out.println(Message.getString("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, final File f2) throws Exception {
        URLConnection conn = NetworkUtil.getConn(URL2);
        System.out.println(Message.getFormatString("file.download.start", new Object[]{f2.getName(), UpdateUtils.getSize(conn.getContentLength())}));
        final ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f2.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        final int fS = conn.getContentLength();
        final Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (rbc.isOpen()) {
                    if (percentage != Math.round((float)f2.length() / (float)fS * 100.0f) && percentage < 100) {
                        System.out.println(Message.getFormatString("file.download.percentage", new Object[]{f2.getName(), percentage}));
                    }
                    percentage = Math.round((float)f2.length() / (float)fS * 100.0f);
                } else {
                    t.cancel();
                }
            }
        }, 3000L, 1000L);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        System.out.println(Message.getFormatString("file.download.ok", new Object[]{f2.getName()}));
    }

    public static File getMohistJar() {
        try {
            String path = UpdateUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            if (path.contains("!/")) {
                path = path.split("!/")[0].split("jar:file:/")[1];
            }
            return new File(path);
        }
        catch (Exception e2) {
            System.out.println("Can't found the Mohist jar !");
            return null;
        }
    }

    public static void restartServer(ArrayList<String> cmd) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.waitFor();
        Thread.sleep(2000L);
        System.exit(0);
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }

    public static long getSizeOfDirectory(File path) throws IOException {
        return ((Stream)Files.walk(path.toPath(), new FileVisitOption[0]).parallel()).filter(p2 -> !p2.toFile().isDirectory()).count();
    }
}

