/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelFluid
implements IModel {
    public static final ModelFluid WATER = new ModelFluid(FluidRegistry.WATER);
    public static final ModelFluid LAVA = new ModelFluid(FluidRegistry.LAVA);
    private final Fluid fluid;

    public ModelFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public Collection<nf> getTextures() {
        return this.fluid.getOverlay() != null ? ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing(), (Object)this.fluid.getOverlay()) : ImmutableSet.of((Object)this.fluid.getStill(), (Object)this.fluid.getFlowing());
    }

    @Override
    public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        return new CachingBakedFluid(state.apply(Optional.empty()), PerspectiveMapWrapper.getTransforms(state), format, this.fluid.getColor(), bakedTextureGetter.apply(this.fluid.getStill()), bakedTextureGetter.apply(this.fluid.getFlowing()), Optional.ofNullable(this.fluid.getOverlay()).map(bakedTextureGetter), this.fluid.isLighterThanAir(), Optional.empty());
    }

    @Override
    public ModelFluid process(ImmutableMap<String, String> customData) {
        if (!customData.containsKey((Object)"fluid")) {
            return this;
        }
        String fluidStr = (String)customData.get((Object)"fluid");
        JsonElement e2 = new JsonParser().parse(fluidStr);
        String fluid = e2.getAsString();
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FMLLog.log.fatal("fluid '{}' not found", (Object)fluid);
            return WATER;
        }
        return new ModelFluid(FluidRegistry.getFluid(fluid));
    }

    private static class BakedFluid
    implements cfy {
        private static final int[] x = new int[]{0, 0, 1, 1};
        private static final int[] z = new int[]{0, 1, 1, 0};
        private static final float eps = 0.001f;
        protected final Optional<TRSRTransformation> transformation;
        protected final ImmutableMap<bwc.b, TRSRTransformation> transforms;
        protected final cea format;
        protected final int color;
        protected final cdq still;
        protected final cdq flowing;
        protected final Optional<cdq> overlay;
        protected final boolean gas;
        protected final ImmutableMap<fa, ImmutableList<bvp>> faceQuads;

        public BakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<bwc.b, TRSRTransformation> transforms, cea format, int color, cdq still, cdq flowing, Optional<cdq> overlay, boolean gas, boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            this.transformation = transformation;
            this.transforms = transforms;
            this.format = format;
            this.color = color;
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.gas = gas;
            this.faceQuads = this.buildQuads(statePresent, cornerRound, flowRound, sideOverlays);
        }

        private ImmutableMap<fa, ImmutableList<bvp>> buildQuads(boolean statePresent, int[] cornerRound, int flowRound, boolean[] sideOverlays) {
            EnumMap<fa, ImmutableList> faceQuads = new EnumMap<fa, ImmutableList>(fa.class);
            for (fa side : fa.values()) {
                faceQuads.put(side, ImmutableList.of());
            }
            if (statePresent) {
                float[] y = new float[4];
                boolean fullVolume = true;
                for (int i3 = 0; i3 < 4; ++i3) {
                    float value = (float)cornerRound[i3] / 864.0f;
                    if (value < 1.0f) {
                        fullVolume = false;
                    }
                    y[i3] = this.gas ? 1.0f - value : value;
                }
                boolean isFlowing = flowRound > -1000;
                float flow = isFlowing ? (float)Math.toRadians(flowRound) : 0.0f;
                cdq topSprite = isFlowing ? this.flowing : this.still;
                float scale = isFlowing ? 4.0f : 8.0f;
                float c2 = rk.b((float)flow) * scale;
                float s = rk.a((float)flow) * scale;
                fa top = this.gas ? fa.a : fa.b;
                VertexParameter uv = i2 -> c2 * (float)(x[i2] * 2 - 1) + s * (float)(z[i2] * 2 - 1);
                VertexParameter topX = i2 -> x[i2];
                VertexParameter topY = i2 -> y[i2];
                VertexParameter topZ = i2 -> z[i2];
                VertexParameter topU = i2 -> 8.0f + uv.get(i2);
                VertexParameter topV = i2 -> 8.0f + uv.get((i2 + 1) % 4);
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)this.buildQuad(top, topSprite, this.gas, false, topX, topY, topZ, topU, topV));
                if (!fullVolume) {
                    builder.add((Object)this.buildQuad(top, topSprite, !this.gas, true, topX, topY, topZ, topU, topV));
                }
                faceQuads.put(top, builder.build());
                fa bottom = top.d();
                faceQuads.put(bottom, ImmutableList.of((Object)this.buildQuad(bottom, this.still, this.gas, false, i2 -> z[i2], i2 -> this.gas ? 1.0f : 0.0f, i2 -> x[i2], i2 -> z[i2] * 16, i2 -> x[i2] * 16)));
                for (int i4 = 0; i4 < 4; ++i4) {
                    fa side = fa.b((int)((5 - i4) % 4));
                    boolean useOverlay = this.overlay.isPresent() && sideOverlays[side.b()];
                    int si = i4;
                    VertexParameter sideX = j -> x[(si + x[j]) % 4];
                    VertexParameter sideY = j -> z[j] == 0 ? (float)(this.gas ? 1 : 0) : y[(si + x[j]) % 4];
                    VertexParameter sideZ = j -> z[(si + x[j]) % 4];
                    VertexParameter sideU = j -> x[j] * 8;
                    VertexParameter sideV = j -> (this.gas ? sideY.get(j) : 1.0f - sideY.get(j)) * 8.0f;
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    if (!useOverlay) {
                        builder2.add((Object)this.buildQuad(side, this.flowing, this.gas, true, sideX, sideY, sideZ, sideU, sideV));
                    }
                    builder2.add((Object)this.buildQuad(side, useOverlay ? this.overlay.get() : this.flowing, !this.gas, false, sideX, sideY, sideZ, sideU, sideV));
                    faceQuads.put(side, builder2.build());
                }
            } else {
                faceQuads.put(fa.d, ImmutableList.of((Object)this.buildQuad(fa.b, this.still, false, false, i2 -> z[i2], i2 -> x[i2], i2 -> 0.0f, i2 -> z[i2] * 16, i2 -> x[i2] * 16)));
            }
            return ImmutableMap.copyOf(faceQuads);
        }

        private bvp buildQuad(fa side, cdq texture, boolean flip, boolean offset, VertexParameter x, VertexParameter y, VertexParameter z, VertexParameter u, VertexParameter v) {
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
            builder.setQuadOrientation(side);
            builder.setTexture(texture);
            builder.setQuadTint(0);
            boolean hasTransform = this.transformation.isPresent() && !this.transformation.get().isIdentity();
            IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, this.transformation.get()) : builder;
            for (int i2 = 0; i2 < 4; ++i2) {
                int vertex = flip ? 3 - i2 : i2;
                this.putVertex(consumer, side, offset, x.get(vertex), y.get(vertex), z.get(vertex), texture.a((double)u.get(vertex)), texture.b((double)v.get(vertex)));
            }
            return builder.build();
        }

        private void putVertex(IVertexConsumer consumer, fa side, boolean offset, float x, float y, float z, float u, float v) {
            block6: for (int e2 = 0; e2 < this.format.i(); ++e2) {
                switch (this.format.c(e2).b()) {
                    case a: {
                        float dx = offset ? (float)side.n().p() * 0.001f : 0.0f;
                        float dy = offset ? (float)side.n().q() * 0.001f : 0.0f;
                        float dz = offset ? (float)side.n().r() * 0.001f : 0.0f;
                        consumer.put(e2, x - dx, y - dy, z - dz, 1.0f);
                        continue block6;
                    }
                    case c: {
                        float r2 = (float)(this.color >> 16 & 0xFF) / 255.0f;
                        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                        float b2 = (float)(this.color & 0xFF) / 255.0f;
                        float a2 = (float)(this.color >> 24 & 0xFF) / 255.0f;
                        consumer.put(e2, r2, g, b2, a2);
                        continue block6;
                    }
                    case b: {
                        float offX = side.g();
                        float offY = side.h();
                        float offZ = side.i();
                        consumer.put(e2, offX, offY, offZ, 0.0f);
                        continue block6;
                    }
                    case d: {
                        if (this.format.c(e2).d() == 0) {
                            consumer.put(e2, u, v, 0.0f, 1.0f);
                            continue block6;
                        }
                    }
                    default: {
                        consumer.put(e2, new float[0]);
                    }
                }
            }
        }

        public boolean a() {
            return true;
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public cdq d() {
            return this.still;
        }

        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            return side == null ? ImmutableList.of() : (List)this.faceQuads.get((Object)side);
        }

        public bwa f() {
            return bwa.a;
        }

        public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b type) {
            return PerspectiveMapWrapper.handlePerspective((cfy)this, this.transforms, type);
        }

        private static interface VertexParameter {
            public float get(int var1);
        }
    }

    private static final class CachingBakedFluid
    extends BakedFluid {
        private final LoadingCache<Long, BakedFluid> modelCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<Long, BakedFluid>(){

            public BakedFluid load(Long key) {
                boolean statePresent = (key & 1L) != 0L;
                key = key >>> 1;
                int[] cornerRound = new int[4];
                for (int i2 = 0; i2 < 4; ++i2) {
                    cornerRound[i2] = (int)(key & 0x3FFL);
                    key = key >>> 10;
                }
                int flowRound = (int)(key & 0x7FFL) - 1024;
                key = key >>> 11;
                boolean[] overlaySides = new boolean[4];
                for (int i3 = 0; i3 < 4; ++i3) {
                    overlaySides[i3] = (key & 1L) != 0L;
                    key = key >>> 1;
                }
                return new BakedFluid(transformation, (ImmutableMap<bwc.b, TRSRTransformation>)transforms, format, color, still, flowing, overlay, gas, statePresent, cornerRound, flowRound, overlaySides);
            }
        });

        public CachingBakedFluid(Optional<TRSRTransformation> transformation, ImmutableMap<bwc.b, TRSRTransformation> transforms, cea format, int color, cdq still, cdq flowing, Optional<cdq> overlay, boolean gas, Optional<IExtendedBlockState> stateOption) {
            super(transformation, transforms, format, color, still, flowing, overlay, gas, stateOption.isPresent(), CachingBakedFluid.getCorners(stateOption), CachingBakedFluid.getFlow(stateOption), CachingBakedFluid.getOverlay(stateOption));
        }

        private static int[] getCorners(Optional<IExtendedBlockState> stateOption) {
            int[] cornerRound = new int[]{0, 0, 0, 0};
            if (stateOption.isPresent()) {
                IExtendedBlockState state = stateOption.get();
                for (int i2 = 0; i2 < 4; ++i2) {
                    Float level = state.getValue(BlockFluidBase.LEVEL_CORNERS[i2]);
                    cornerRound[i2] = Math.round((level == null ? 0.8888889f : level.floatValue()) * 864.0f);
                }
            }
            return cornerRound;
        }

        private static int getFlow(Optional<IExtendedBlockState> stateOption) {
            Float flow = Float.valueOf(-1000.0f);
            if (stateOption.isPresent() && (flow = stateOption.get().getValue(BlockFluidBase.FLOW_DIRECTION)) == null) {
                flow = Float.valueOf(-1000.0f);
            }
            int flowRound = (int)Math.round(Math.toDegrees(flow.floatValue()));
            flowRound = rk.a((int)flowRound, (int)-1000, (int)1000);
            return flowRound;
        }

        private static boolean[] getOverlay(Optional<IExtendedBlockState> stateOption) {
            boolean[] overlaySides = new boolean[4];
            if (stateOption.isPresent()) {
                IExtendedBlockState state = stateOption.get();
                for (int i2 = 0; i2 < 4; ++i2) {
                    Boolean overlay = state.getValue(BlockFluidBase.SIDE_OVERLAYS[i2]);
                    if (overlay == null) continue;
                    overlaySides[i2] = overlay;
                }
            }
            return overlaySides;
        }

        @Override
        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            if (side != null && state instanceof IExtendedBlockState) {
                int i2;
                Optional<IExtendedBlockState> exState = Optional.of((IExtendedBlockState)state);
                int[] cornerRound = CachingBakedFluid.getCorners(exState);
                int flowRound = CachingBakedFluid.getFlow(exState);
                boolean[] overlaySides = CachingBakedFluid.getOverlay(exState);
                long key = 0L;
                for (i2 = 3; i2 >= 0; --i2) {
                    key <<= 1;
                    key |= overlaySides[i2] ? 1L : 0L;
                }
                key <<= 11;
                key |= (long)(flowRound + 1024);
                for (i2 = 3; i2 >= 0; --i2) {
                    key <<= 10;
                    key |= (long)cornerRound[i2];
                }
                key <<= 1;
                return ((BakedFluid)this.modelCache.getUnchecked((Object)(key |= 1L))).a(state, side, rand);
            }
            return super.a(state, side, rand);
        }
    }

    public static enum FluidLoader implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public void a(cep resourceManager) {
        }

        @Override
        public boolean accepts(nf modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("fluid") || modelLocation.a().equals("models/block/fluid") || modelLocation.a().equals("models/item/fluid"));
        }

        @Override
        public IModel loadModel(nf modelLocation) {
            return WATER;
        }
    }
}

