/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsExport;
import co.aikar.timings.TimingsManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.util.StringUtil;
import red.mohist.util.i18n.Message;

public class TimingsCommand
extends BukkitCommand {
    private static final List<String> TIMINGS_SUBCOMMANDS = ImmutableList.of((Object)"report", (Object)"reset", (Object)"on", (Object)"off", (Object)"paste", (Object)"verbon", (Object)"verboff");
    private long lastResetAttempt = 0L;

    public TimingsCommand(String name) {
        super(name);
        this.description = Message.getString("timings.command.1");
        this.usageMessage = "/timings <reset|report|on|off|verbon|verboff>";
        this.setPermission("bukkit.command.timings");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return true;
        }
        String arg = args[0];
        if ("on".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(true);
            sender.sendMessage(Message.getString("timings.command.2"));
            return true;
        }
        if ("off".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(false);
            sender.sendMessage(Message.getString("timings.command.3"));
            return true;
        }
        if (!Timings.isTimingsEnabled()) {
            sender.sendMessage(Message.getString("timings.command.4"));
            return true;
        }
        long now = System.currentTimeMillis();
        if ("verbon".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(true);
            sender.sendMessage(Message.getString("timings.command.5"));
            return true;
        }
        if ("verboff".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(false);
            sender.sendMessage(Message.getString("timings.command.6"));
            return true;
        }
        if ("reset".equalsIgnoreCase(arg)) {
            if (now - this.lastResetAttempt < 30000L) {
                TimingsManager.reset();
                sender.sendMessage((Object)((Object)ChatColor.RED) + Message.getString("timings.command.7"));
            } else {
                this.lastResetAttempt = now;
                sender.sendMessage((Object)((Object)ChatColor.RED) + Message.getString("timings.command.8"));
            }
        } else if ("cost".equals(arg)) {
            sender.sendMessage(Message.getString("timings.command.9") + ": " + TimingsExport.getCost());
        } else if ("paste".equalsIgnoreCase(arg) || "report".equalsIgnoreCase(arg) || "get".equalsIgnoreCase(arg) || "merged".equalsIgnoreCase(arg) || "separate".equalsIgnoreCase(arg)) {
            Timings.generateReport(sender);
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], TIMINGS_SUBCOMMANDS, new ArrayList(TIMINGS_SUBCOMMANDS.size()));
        }
        return ImmutableList.of();
    }
}

