/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.bukkit.nms.remappers;

import com.google.common.collect.BiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import red.mohist.bukkit.nms.model.ClassMapping;
import red.mohist.bukkit.nms.remappers.ClassRemapperSupplier;

public class MohistJarMapping
implements ClassRemapperSupplier {
    public final Map<String, ClassMapping> byNMSInternalName = new HashMap<String, ClassMapping>();
    public final Map<String, ClassMapping> byNMSSrcName = new HashMap<String, ClassMapping>();
    public final Map<String, ClassMapping> byNMSName = new HashMap<String, ClassMapping>();
    public final Map<String, ClassMapping> byMCPName = new HashMap<String, ClassMapping>();
    public final Map<String, String> classes = new HashMap<String, String>();
    public final Map<String, String> fields = new HashMap<String, String>();
    public final Map<String, String> methods = new HashMap<String, String>();
    public final Map<String, String> fastMapping = new HashMap<String, String>();
    public final LinkedHashMap<String, String> packages = new LinkedHashMap();
    protected InheritanceMap inheritanceMap = new InheritanceMap();
    protected InheritanceProvider fallbackInheritanceProvider = null;
    protected String currentClass = null;

    public void initFastMethodMapping(Remapper remapper) {
        for (ClassMapping classMapping : this.byNMSSrcName.values()) {
            classMapping.getSrcMethodMapping().forEach((nmsSrcMethodDescriptor, map) -> {
                String methodDesc = nmsSrcMethodDescriptor;
                methodDesc = remapper.mapMethodDesc(methodDesc);
                Type[] ts = Type.getArgumentTypes((String)methodDesc);
                StringJoiner sj = new StringJoiner(",");
                for (Type t : ts) {
                    String part = t.getClassName();
                    if (part.contains("[]")) {
                        sj.add(t.getInternalName());
                        continue;
                    }
                    sj.add(part);
                }
                String methodArgumentsDesc = sj.toString().intern();
                map.forEach((k2, v) -> {
                    classMapping.getMethodMapping().computeIfAbsent(methodArgumentsDesc, kk -> new HashMap()).put(k2, v);
                    classMapping.getInverseMethodMapping().computeIfAbsent(methodArgumentsDesc, kk -> new HashMap()).put(v, k2);
                });
            });
        }
    }

    public String fastMapFieldName(Class<?> clazz, String name) {
        String mapped = this.fastMapFieldName(false, clazz, clazz.getName() + " " + name, name);
        if (mapped == null) {
            return name;
        }
        return mapped;
    }

    public String fastReverseMapFieldName(Class<?> clazz, String name) {
        String mapped = this.fastMapFieldName(true, clazz, clazz.getName() + " " + name, name);
        if (mapped == null) {
            return name;
        }
        return mapped;
    }

    public String fastMapMethodName(Class<?> clazz, String name, Class<?> ... args) {
        String mapped = this.fastMapMethodName(false, clazz, clazz.getName() + " " + name + " " + this.join(args), name, args);
        if (mapped == null) {
            return name;
        }
        return mapped;
    }

    public String fastReverseMapMethodName(Class<?> clazz, String name, Class<?> ... args) {
        String mapped = this.fastMapMethodName(true, clazz, clazz.getName() + " " + name + " " + this.join(args), name, args);
        if (mapped == null) {
            return name;
        }
        return mapped;
    }

    private String fastMapFieldName(boolean inverse, Class<?> clazz, String key, String name) {
        if (clazz == null) {
            return null;
        }
        String mapName = this.fastMapping.get(key);
        if (mapName != null) {
            return mapName;
        }
        mapName = this.directFastMapFieldName(inverse, clazz, name);
        if (mapName != null) {
            this.fastMapping.put(key.intern(), mapName.intern());
            return mapName;
        }
        mapName = this.fastMapMethodName(inverse, clazz.getSuperclass(), key, name, new Class[0]);
        return mapName;
    }

    private String directFastMapFieldName(boolean inverse, Class<?> clazz, String name) {
        String className = clazz.getName();
        if (!className.startsWith("net.minecraft.")) {
            return null;
        }
        ClassMapping mapping = this.byMCPName.get(clazz.getName());
        if (mapping == null) {
            return null;
        }
        BiMap map = mapping.getFieldMapping();
        if (inverse) {
            map = map.inverse();
        }
        return (String)map.get((Object)name);
    }

    private String fastMapMethodName(boolean inverse, Class<?> clazz, String key, String name, Class<?> ... args) {
        if (clazz == null) {
            return null;
        }
        String mapName = this.fastMapping.get(key);
        if (mapName != null) {
            return mapName;
        }
        mapName = this.directFastMapMethodName(inverse, clazz, name, args);
        if (mapName != null) {
            this.fastMapping.put(key.intern(), mapName.intern());
            return mapName;
        }
        mapName = this.fastMapMethodName(inverse, clazz.getSuperclass(), key, name, args);
        if (mapName != null) {
            return mapName;
        }
        for (Class<?> aClass : clazz.getInterfaces()) {
            mapName = this.fastMapMethodName(inverse, aClass, key, name, args);
            if (mapName == null) continue;
            return mapName;
        }
        return null;
    }

    private String directFastMapMethodName(boolean inverse, Class<?> clazz, String name, Class<?> ... args) {
        Map<String, String> map;
        String className = clazz.getName();
        if (!className.startsWith("net.minecraft.")) {
            return null;
        }
        ClassMapping mapping = this.byMCPName.get(clazz.getName());
        if (mapping != null && (map = inverse ? mapping.getInverseMethodMapping().get(this.join(args)) : mapping.getMethodMapping().get(this.join(args))) != null) {
            return map.get(name);
        }
        return null;
    }

    private String join(Class<?> ... args) {
        if (args == null) {
            return "";
        }
        StringJoiner sj = new StringJoiner(",");
        for (Class<?> arg : args) {
            sj.add(arg.getName());
        }
        return sj.toString();
    }

    public void setInheritanceMap(InheritanceMap inheritanceMap) {
        this.inheritanceMap = inheritanceMap;
    }

    public void setFallbackInheritanceProvider(InheritanceProvider fallbackInheritanceProvider) {
        this.fallbackInheritanceProvider = fallbackInheritanceProvider;
    }

    public String tryClimb(Map<String, String> map, NodeType type, String owner, String name, int access) {
        String key = owner + "/" + name;
        String mapped = map.get(key);
        if (mapped == null && (access == -1 || !Modifier.isPrivate(access) && !Modifier.isStatic(access))) {
            Collection parents = null;
            if (this.inheritanceMap.hasParents(owner)) {
                parents = this.inheritanceMap.getParents(owner);
            } else if (this.fallbackInheritanceProvider != null) {
                parents = this.fallbackInheritanceProvider.getParents(owner);
                this.inheritanceMap.setParents(owner, parents);
            }
            if (parents != null) {
                for (String parent : parents) {
                    mapped = this.tryClimb(map, type, parent, name, access);
                    if (mapped == null) continue;
                    return mapped;
                }
            }
        }
        return mapped;
    }

    public void loadMappings(BufferedReader reader, MappingTransformer inputTransformer, MappingTransformer outputTransformer, boolean reverse) throws IOException {
        String line;
        if (inputTransformer == null) {
            inputTransformer = MavenShade.IDENTITY;
        }
        if (outputTransformer == null) {
            outputTransformer = MavenShade.IDENTITY;
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            int commentIndex = line.indexOf(35);
            if (commentIndex != -1) {
                line = line.substring(0, commentIndex);
            }
            if (line.isEmpty()) continue;
            lines.add(line);
        }
        final HashMap<String, String> clsMap = new HashMap<String, String>();
        for (String l2 : lines) {
            String[] tokens;
            if (l2.contains(":")) {
                if (!l2.startsWith("CL:")) continue;
                tokens = l2.split(" ");
                clsMap.put(tokens[1], tokens[1]);
                continue;
            }
            if (l2.startsWith("\t")) continue;
            tokens = l2.split(" ");
            clsMap.put(tokens[0], tokens[1]);
        }
        Remapper reverseMapper = new Remapper(){

            public String map(String cls) {
                return clsMap.getOrDefault(cls, cls);
            }
        };
        for (String l3 : lines) {
            if (l3.contains(":")) {
                this.parseSrgLine(l3, inputTransformer, outputTransformer);
                continue;
            }
            this.parseCsrgLine(l3, inputTransformer, outputTransformer, reverseMapper);
        }
        this.currentClass = null;
    }

    public ClassMapping registerClassMapping(String nmsSrcName, String mcpSrcName) {
        nmsSrcName = nmsSrcName.intern();
        mcpSrcName = mcpSrcName.intern();
        this.classes.put(nmsSrcName, mcpSrcName);
        ClassMapping mapping = this.byNMSSrcName.get(nmsSrcName);
        if (mapping == null) {
            mapping = new ClassMapping();
            mapping.setNmsSrcName(nmsSrcName);
            mapping.setMcpSrcName(mcpSrcName);
            this.byNMSSrcName.put(mapping.getNmsSrcName(), mapping);
            this.byNMSInternalName.put(mapping.getNmsSrcName(), mapping);
            this.byMCPName.put(mapping.getMcpName(), mapping);
            this.byNMSName.put(mapping.getNmsName(), mapping);
        }
        return mapping;
    }

    public void registerFieldMapping(String nmsSrcName, String nmsName, String mcpSrcName, String mcpName) {
        nmsName = nmsName.intern();
        mcpName = mcpName.intern();
        this.fields.put((nmsSrcName + "/" + nmsName).intern(), mcpName);
        ClassMapping mapping = this.registerClassMapping(nmsSrcName, mcpSrcName);
        mapping.getFieldMapping().put((Object)nmsName, (Object)mcpName);
    }

    public void registerMethodMapping(String nmsSrcName, String nmsName, String nmsSrcMethodDescriptor, String mcpSrcName, String mcpName, String mcpSrcMethodDescriptor) {
        nmsName = nmsName.intern();
        mcpName = mcpName.intern();
        nmsSrcMethodDescriptor = nmsSrcMethodDescriptor.intern();
        this.methods.put((nmsSrcName + "/" + nmsName + " " + nmsSrcMethodDescriptor).intern(), mcpName);
        ClassMapping mapping = this.registerClassMapping(nmsSrcName, mcpSrcName);
        mapping.getSrcMethodMapping().computeIfAbsent(nmsSrcMethodDescriptor, kk -> new HashMap()).put(nmsName, mcpName);
        mapping.getInverseSrcMethodMapping().computeIfAbsent(nmsSrcMethodDescriptor, kk -> new HashMap()).put(mcpName, nmsName);
    }

    private void parseCsrgLine(String line, MappingTransformer inputTransformer, MappingTransformer outputTransformer, Remapper reverseMap) throws IOException {
        String[] tokens;
        if (line.startsWith("\t")) {
            if (this.currentClass == null) {
                throw new IOException("Invalid tsrg file, tsrg field/method line before class line: " + line);
            }
            line = this.currentClass + " " + line.substring(1);
        }
        if ((tokens = line.split(" ")).length == 2) {
            String oldClassName = inputTransformer.transformClassName(tokens[0]);
            String newClassName = outputTransformer.transformClassName(tokens[1]);
            if (oldClassName.endsWith("/")) {
                this.packages.put(oldClassName.substring(0, oldClassName.length() - 1), newClassName);
            } else {
                this.registerClassMapping(oldClassName, newClassName);
                this.currentClass = tokens[0];
            }
        } else if (tokens.length == 3) {
            String oldClassName = inputTransformer.transformClassName(tokens[0]);
            ClassMapping mapping = this.byNMSSrcName.get(oldClassName);
            String newClassName = mapping == null ? oldClassName : mapping.getMcpSrcName();
            String oldFieldName = inputTransformer.transformFieldName(tokens[0], tokens[1]);
            String newFieldName = outputTransformer.transformFieldName(tokens[0], tokens[2]);
            this.registerFieldMapping(oldClassName, oldFieldName, newClassName, newFieldName);
        } else if (tokens.length == 4) {
            String oldClassName = inputTransformer.transformClassName(tokens[0]);
            String oldMethodName = inputTransformer.transformMethodName(tokens[0], tokens[1], tokens[2]);
            String oldMethodDescriptor = inputTransformer.transformMethodDescriptor(tokens[2]);
            ClassMapping mapping = this.byNMSSrcName.get(oldClassName);
            String newClassName = mapping == null ? oldClassName : mapping.getMcpSrcName();
            String newMethodName = outputTransformer.transformMethodName(tokens[0], tokens[3], tokens[2]);
            this.registerMethodMapping(oldClassName, oldMethodName, oldMethodDescriptor, newClassName, newMethodName, null);
        } else {
            throw new IOException("Invalid csrg file line, token count " + tokens.length + " unexpected in " + line);
        }
    }

    private void parseSrgLine(String line, MappingTransformer inputTransformer, MappingTransformer outputTransformer) throws IOException {
        String kind;
        String[] tokens = line.split(" ");
        switch (kind = tokens[0]) {
            case "CL:": {
                String oldClassName = inputTransformer.transformClassName(tokens[1]);
                String newClassName = outputTransformer.transformClassName(tokens[2]);
                if (this.byNMSSrcName.containsKey(oldClassName) && !newClassName.equals(this.byNMSSrcName.get(oldClassName).getNmsSrcName())) {
                    throw new IllegalArgumentException("Duplicate class mapping: " + oldClassName + " -> " + newClassName + " but already mapped to " + this.byNMSSrcName.get(oldClassName) + " in line=" + line);
                }
                if (oldClassName.endsWith("/*") && newClassName.endsWith("/*")) {
                    oldClassName = oldClassName.substring(0, oldClassName.length() - 1);
                    newClassName = newClassName.substring(0, newClassName.length() - 1);
                    this.packages.put(oldClassName, newClassName);
                    break;
                }
                this.registerClassMapping(oldClassName, newClassName);
                this.currentClass = tokens[1];
                break;
            }
            case "PK:": {
                String oldPackageName = inputTransformer.transformClassName(tokens[1]);
                String newPackageName = outputTransformer.transformClassName(tokens[2]);
                if (!newPackageName.equals(".") && !newPackageName.endsWith("/")) {
                    newPackageName = newPackageName + "/";
                }
                if (!oldPackageName.equals(".") && !oldPackageName.endsWith("/")) {
                    oldPackageName = oldPackageName + "/";
                }
                if (this.packages.containsKey(oldPackageName) && !newPackageName.equals(this.packages.get(oldPackageName))) {
                    throw new IllegalArgumentException("Duplicate package mapping: " + oldPackageName + " ->" + newPackageName + " but already mapped to " + this.packages.get(oldPackageName) + " in line=" + line);
                }
                this.packages.put(oldPackageName, newPackageName);
                break;
            }
            case "FD:": {
                String oldFull = tokens[1];
                String newFull = tokens[2];
                int splitOld = oldFull.lastIndexOf(47);
                int splitNew = newFull.lastIndexOf(47);
                if (splitOld == -1 || splitNew == -1) {
                    throw new IllegalArgumentException("Field name is invalid, not fully-qualified: " + oldFull + " -> " + newFull + " in line=" + line);
                }
                String oldClassName = inputTransformer.transformClassName(oldFull.substring(0, splitOld));
                String oldFieldName = inputTransformer.transformFieldName(oldFull.substring(0, splitOld), oldFull.substring(splitOld + 1));
                String newClassName = outputTransformer.transformClassName(newFull.substring(0, splitNew));
                String newFieldName = outputTransformer.transformFieldName(oldFull.substring(0, splitOld), newFull.substring(splitNew + 1));
                this.registerFieldMapping(oldClassName, oldFieldName, newClassName, newFieldName);
                break;
            }
            case "MD:": {
                String oldFull = tokens[1];
                String newFull = tokens[3];
                int splitOld = oldFull.lastIndexOf(47);
                int splitNew = newFull.lastIndexOf(47);
                if (splitOld == -1 || splitNew == -1) {
                    throw new IllegalArgumentException("Field name is invalid, not fully-qualified: " + oldFull + " -> " + newFull + " in line=" + line);
                }
                String oldClassName = inputTransformer.transformClassName(oldFull.substring(0, splitOld));
                String oldMethodName = inputTransformer.transformMethodName(oldFull.substring(0, splitOld), oldFull.substring(splitOld + 1), tokens[2]);
                String oldMethodDescriptor = inputTransformer.transformMethodDescriptor(tokens[2]);
                String newClassName = outputTransformer.transformClassName(newFull.substring(0, splitNew));
                String newMethodName = outputTransformer.transformMethodName(oldFull.substring(0, splitOld), newFull.substring(splitNew + 1), tokens[2]);
                String newMethodDescriptor = outputTransformer.transformMethodDescriptor(tokens[4]);
                this.registerMethodMapping(oldClassName, oldMethodName, oldMethodDescriptor, newClassName, newMethodName, newMethodDescriptor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to parse srg file, unrecognized mapping type in line=" + line);
            }
        }
    }
}

