/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.village.MerchantTradeOffersEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ForgeEventFactory {
    public static BlockEvent.EntityMultiPlaceEvent onMultiBlockPlace(@Nullable vg entity, List<BlockSnapshot> blockSnapshots, fa direction) {
        BlockSnapshot snap = blockSnapshots.get(0);
        awt placedAgainst = snap.getWorld().o(snap.getPos().a(direction.d()));
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(blockSnapshots, placedAgainst, entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.MultiPlaceEvent onPlayerMultiBlockPlace(aed player, List<BlockSnapshot> blockSnapshots, fa direction, ub hand) {
        BlockSnapshot snap = blockSnapshots.get(0);
        awt placedAgainst = snap.getWorld().o(snap.getPos().a(direction.d()));
        BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(blockSnapshots, placedAgainst, player, hand);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.EntityPlaceEvent onBlockPlace(@Nullable vg entity, @Nonnull BlockSnapshot blockSnapshot, @Nonnull fa direction) {
        awt placedAgainst = blockSnapshot.getWorld().o(blockSnapshot.getPos().a(direction.d()));
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(blockSnapshot, placedAgainst, entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.PlaceEvent onPlayerBlockPlace(@Nonnull aed player, @Nonnull BlockSnapshot blockSnapshot, @Nonnull fa direction, @Nonnull ub hand) {
        awt placedAgainst = blockSnapshot.getWorld().o(blockSnapshot.getPos().a(direction.d()));
        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, placedAgainst, player, hand);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static BlockEvent.NeighborNotifyEvent onNeighborNotify(amu world, et pos, awt state, EnumSet<fa> notifiedSides, boolean forceRedstoneUpdate) {
        BlockEvent.NeighborNotifyEvent event = new BlockEvent.NeighborNotifyEvent(world, pos, state, notifiedSides, forceRedstoneUpdate);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static boolean doPlayerHarvestCheck(aed player, awt state, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, state, success);
        MinecraftForge.EVENT_BUS.post(event);
        return event.canHarvest();
    }

    public static float getBreakSpeed(aed player, awt state, float original, et pos) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, state, original, pos);
        return MinecraftForge.EVENT_BUS.post(event) ? -1.0f : event.getNewSpeed();
    }

    public static void onPlayerDestroyItem(aed player, @Nonnull aip stack, @Nullable ub hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(player, stack, hand));
    }

    @Deprecated
    public static Event.Result canEntitySpawn(vq entity, amu world, float x, float y, float z) {
        return ForgeEventFactory.canEntitySpawn(entity, world, x, y, z, true);
    }

    @Deprecated
    public static Event.Result canEntitySpawn(vq entity, amu world, float x, float y, float z, boolean isSpawner) {
        if (entity == null) {
            return Event.Result.DEFAULT;
        }
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y, z, isSpawner);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static Event.Result canEntitySpawn(vq entity, amu world, float x, float y, float z, amk spawner) {
        if (entity == null) {
            return Event.Result.DEFAULT;
        }
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y, z, spawner);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static boolean canEntitySpawnSpawner(vq entity, amu world, float x, float y, float z, amk spawner) {
        Event.Result result = ForgeEventFactory.canEntitySpawn(entity, world, x, y, z, spawner);
        if (result == Event.Result.DEFAULT) {
            return entity.P() && entity.Q();
        }
        return result == Event.Result.ALLOW;
    }

    @Deprecated
    public static boolean canEntitySpawnSpawner(vq entity, amu world, float x, float y, float z) {
        Event.Result result = ForgeEventFactory.canEntitySpawn(entity, world, x, y, z, true);
        if (result == Event.Result.DEFAULT) {
            return entity.P() && entity.Q();
        }
        return result == Event.Result.ALLOW;
    }

    @Deprecated
    public static boolean doSpecialSpawn(vq entity, amu world, float x, float y, float z) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y, z, null));
    }

    public static boolean doSpecialSpawn(vq entity, amu world, float x, float y, float z, amk spawner) {
        return MinecraftForge.EVENT_BUS.post(new LivingSpawnEvent.SpecialSpawn(entity, world, x, y, z, spawner));
    }

    public static Event.Result canEntityDespawn(vq entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult();
    }

    public static int getItemBurnTime(@Nonnull aip itemStack) {
        int fuelValue;
        ain item = itemStack.c();
        int burnTime = item.getItemBurnTime(itemStack);
        FurnaceFuelBurnTimeEvent event = new FurnaceFuelBurnTimeEvent(itemStack, burnTime);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.getBurnTime() < 0 && (fuelValue = GameRegistry.getFuelValueLegacy(itemStack)) > 0) {
            return fuelValue;
        }
        return event.getBurnTime();
    }

    public static int getExperienceDrop(vp entity, aed attackingPlayer, int originalExperience) {
        LivingExperienceDropEvent event = new LivingExperienceDropEvent(entity, attackingPlayer, originalExperience);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return 0;
        }
        return event.getDroppedExperience();
    }

    @Nullable
    public static List<anh.c> getPotentialSpawns(oo world, vr type, et pos, List<anh.c> oldList) {
        WorldEvent.PotentialSpawns event = new WorldEvent.PotentialSpawns((amu)world, type, pos, oldList);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getList();
    }

    public static int getMaxSpawnPackSize(vq entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post(maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.getMaxPackSize() : entity.cU();
    }

    public static String getPlayerDisplayName(aed player, String username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getDisplayname();
    }

    public static float fireBlockHarvesting(List<aip> drops, amu world, et pos, awt state, int fortune, float dropChance, boolean silkTouch, aed player) {
        BlockEvent.HarvestDropsEvent event = new BlockEvent.HarvestDropsEvent(world, pos, state, fortune, dropChance, drops, player, silkTouch);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getDropChance();
    }

    public static awt fireFluidPlaceBlockEvent(amu world, et pos, et liquidPos, awt state) {
        BlockEvent.FluidPlaceBlockEvent event = new BlockEvent.FluidPlaceBlockEvent(world, pos, liquidPos, state);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getNewState();
    }

    public static ItemTooltipEvent onItemTooltip(aip itemStack, @Nullable aed entityPlayer, List<String> toolTip, akb flags) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, toolTip, flags);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(adt zombie, amu world, int x, int y, int z, vp attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y, z, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post(summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(vg entity, aci bolt) {
        return MinecraftForge.EVENT_BUS.post(new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(vp entity, aip item, int duration) {
        LivingEntityUseItemEvent.Start event = new LivingEntityUseItemEvent.Start(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.getDuration();
    }

    public static int onItemUseTick(vp entity, aip item, int duration) {
        LivingEntityUseItemEvent.Tick event = new LivingEntityUseItemEvent.Tick(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post(event) ? -1 : event.getDuration();
    }

    public static boolean onUseItemStop(vp entity, aip item, int duration) {
        return MinecraftForge.EVENT_BUS.post(new LivingEntityUseItemEvent.Stop(entity, item, duration));
    }

    public static aip onItemUseFinish(vp entity, aip item, int duration, aip result) {
        LivingEntityUseItemEvent.Finish event = new LivingEntityUseItemEvent.Finish(entity, item, duration, result);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResultStack();
    }

    public static void onStartEntityTracking(vg entity, aed player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(vg entity, aed player) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(aed player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(aed player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(aed player, bfk playerFileData, String uuidString) {
        bfb sh = (bfb)playerFileData;
        File dir = (File)ObfuscationReflectionHelper.getPrivateValue(bfb.class, sh, "field_75771_c");
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.LoadFromFile(player, dir, uuidString));
    }

    @Nullable
    public static hh onClientChat(hf type, hh message) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(type, message);
        return MinecraftForge.EVENT_BUS.post(event) ? null : event.getMessage();
    }

    @Nonnull
    public static String onClientSendMessage(String message) {
        ClientChatEvent event = new ClientChatEvent(message);
        return MinecraftForge.EVENT_BUS.post(event) ? "" : event.getMessage();
    }

    public static int onHoeUse(aip stack, aed player, amu worldIn, et pos) {
        UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            stack.a(1, (vp)player);
            return 1;
        }
        return 0;
    }

    public static int onApplyBonemeal(@Nonnull aed player, @Nonnull amu world, @Nonnull et pos, @Nonnull awt state, @Nonnull aip stack, @Nullable ub hand) {
        BonemealEvent event = new BonemealEvent(player, world, pos, state, hand, stack);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.G) {
                stack.g(1);
            }
            return 1;
        }
        return 0;
    }

    @Nullable
    public static ue<aip> onBucketUse(@Nonnull aed player, @Nonnull amu world, @Nonnull aip stack, @Nullable bhc target) {
        FillBucketEvent event = new FillBucketEvent(player, stack, world, target);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return new ue(ud.c, (Object)stack);
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.bO.d) {
                return new ue(ud.a, (Object)stack);
            }
            stack.g(1);
            if (stack.b()) {
                return new ue(ud.a, (Object)event.getFilledBucket());
            }
            if (!player.bv.e(event.getFilledBucket())) {
                player.a(event.getFilledBucket(), false);
            }
            return new ue(ud.a, (Object)stack);
        }
        return null;
    }

    public static boolean canEntityUpdate(vg entity) {
        EntityEvent.CanUpdate event = new EntityEvent.CanUpdate(entity);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCanUpdate();
    }

    public static PlaySoundAtEntityEvent onPlaySoundAtEntity(vg entity, qe name, qg category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(entity, name, category, volume, pitch);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static int onItemExpire(acl entity, @Nonnull aip item) {
        if (item.b()) {
            return -1;
        }
        ItemExpireEvent event = new ItemExpireEvent(entity, item.b() ? 6000 : item.c().getEntityLifespan(item, entity.l));
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getExtraLife();
    }

    public static int onItemPickup(acl entityItem, aed player) {
        EntityItemPickupEvent event = new EntityItemPickupEvent(player, entityItem);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getResult() == Event.Result.ALLOW ? 1 : 0;
    }

    public static void onPlayerDrops(aed player, ur cause, List<acl> capturedDrops, boolean recentlyHit) {
        PlayerDropsEvent event = new PlayerDropsEvent(player, cause, capturedDrops, recentlyHit);
        if (!MinecraftForge.EVENT_BUS.post(event)) {
            for (acl item : capturedDrops) {
                player.a(item);
            }
        }
    }

    public static boolean canMountEntity(vg entityMounting, vg entityBeingMounted, boolean isMounting) {
        boolean isCanceled = MinecraftForge.EVENT_BUS.post(new EntityMountEvent(entityMounting, entityBeingMounted, entityMounting.l, isMounting));
        if (isCanceled) {
            entityMounting.a(entityMounting.p, entityMounting.q, entityMounting.r, entityMounting.x, entityMounting.y);
            return false;
        }
        return true;
    }

    public static boolean onAnimalTame(zv animal, aed tamer) {
        return MinecraftForge.EVENT_BUS.post(new AnimalTameEvent(animal, tamer));
    }

    public static aed.a onPlayerSleepInBed(aed player, et pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResultStatus();
    }

    public static void onPlayerWakeup(aed player, boolean wakeImmediately, boolean updateWorldFlag, boolean setSpawn) {
        MinecraftForge.EVENT_BUS.post(new PlayerWakeUpEvent(player, wakeImmediately, updateWorldFlag, setSpawn));
    }

    public static void onPlayerFall(aed player, float distance, float multiplier) {
        MinecraftForge.EVENT_BUS.post(new PlayerFlyableFallEvent(player, distance, multiplier));
    }

    public static boolean onPlayerSpawnSet(aed player, et pos, boolean forced) {
        return MinecraftForge.EVENT_BUS.post(new PlayerSetSpawnEvent(player, pos, forced));
    }

    public static void onPlayerClone(aed player, aed oldPlayer, boolean wasDeath) {
        MinecraftForge.EVENT_BUS.post(new PlayerEvent.Clone(player, oldPlayer, wasDeath));
    }

    public static boolean onExplosionStart(amu world, amp explosion) {
        return MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(amu world, amp explosion, List<vg> list, double diameter) {
        MinecraftForge.EVENT_BUS.post(new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(amu world, amx settings) {
        return MinecraftForge.EVENT_BUS.post(new WorldEvent.CreateSpawnPosition(world, settings));
    }

    public static float onLivingHeal(vp entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onPotionAttemptBrew(fi<aip> stacks) {
        fi tmp = fi.a((int)stacks.size(), (Object)aip.a);
        for (int x = 0; x < tmp.size(); ++x) {
            tmp.set(x, (Object)((aip)stacks.get(x)).l());
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre((fi<aip>)tmp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.size(); ++x) {
                changed |= aip.b((aip)((aip)tmp.get(x)), (aip)((aip)stacks.get(x)));
                stacks.set(x, (Object)event.getItem(x));
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(fi<aip> brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post(new PotionBrewEvent.Post(brewingItemStacks));
    }

    public static void onPlayerBrewedPotion(aed player, aip stack) {
        MinecraftForge.EVENT_BUS.post(new PlayerBrewedPotionEvent(player, stack));
    }

    public static boolean renderFireOverlay(aed player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.FIRE, aox.ab.t(), new et((vg)player));
    }

    public static boolean renderWaterOverlay(aed player, float renderPartialTicks) {
        return ForgeEventFactory.renderBlockOverlay(player, renderPartialTicks, RenderBlockOverlayEvent.OverlayType.WATER, aox.j.t(), new et((vg)player));
    }

    public static boolean renderBlockOverlay(aed player, float renderPartialTicks, RenderBlockOverlayEvent.OverlayType type, awt block, et pos) {
        return MinecraftForge.EVENT_BUS.post(new RenderBlockOverlayEvent(player, renderPartialTicks, type, block, pos));
    }

    @Nullable
    public static CapabilityDispatcher gatherCapabilities(avj tileEntity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<avj>(avj.class, tileEntity), null);
    }

    @Nullable
    public static CapabilityDispatcher gatherCapabilities(vg entity) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<vg>(vg.class, entity), null);
    }

    @Nullable
    public static CapabilityDispatcher gatherCapabilities(zo village) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<zo>(zo.class, village), null);
    }

    @Nullable
    public static CapabilityDispatcher gatherCapabilities(aip stack, ICapabilityProvider parent) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<aip>(aip.class, stack), parent);
    }

    @Nullable
    public static CapabilityDispatcher gatherCapabilities(amu world, ICapabilityProvider parent) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<amu>(amu.class, world), parent);
    }

    @Nullable
    public static CapabilityDispatcher gatherCapabilities(axw chunk) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<axw>(axw.class, chunk), null);
    }

    @Nullable
    private static CapabilityDispatcher gatherCapabilities(AttachCapabilitiesEvent<?> event, @Nullable ICapabilityProvider parent) {
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCapabilities().size() > 0 || parent != null ? new CapabilityDispatcher(event.getCapabilities(), parent) : null;
    }

    public static boolean fireSleepingLocationCheck(aed player, et sleepingLocation) {
        SleepingLocationCheckEvent evt = new SleepingLocationCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            awt state = player.l.o(player.bL);
            return state.u().isBed(state, (amy)player.l, player.bL, (vg)player);
        }
        return canContinueSleep == Event.Result.ALLOW;
    }

    public static boolean fireSleepingTimeCheck(aed player, et sleepingLocation) {
        SleepingTimeCheckEvent evt = new SleepingTimeCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            return !player.l.D();
        }
        return canContinueSleep == Event.Result.ALLOW;
    }

    public static ue<aip> onArrowNock(aip item, amu world, aed player, ub hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return new ue(ud.c, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(aip stack, amu world, aed player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static boolean onProjectileImpact(vg entity, bhc ray) {
        return MinecraftForge.EVENT_BUS.post(new ProjectileImpactEvent(entity, ray));
    }

    public static boolean onProjectileImpact(aeh arrow, bhc ray) {
        return MinecraftForge.EVENT_BUS.post(new ProjectileImpactEvent.Arrow(arrow, ray));
    }

    public static boolean onProjectileImpact(ael fireball, bhc ray) {
        return MinecraftForge.EVENT_BUS.post(new ProjectileImpactEvent.Fireball(fireball, ray));
    }

    public static boolean onProjectileImpact(aev throwable, bhc ray) {
        boolean oldEvent = MinecraftForge.EVENT_BUS.post(new ThrowableImpactEvent(throwable, ray));
        boolean newEvent = MinecraftForge.EVENT_BUS.post(new ProjectileImpactEvent.Throwable(throwable, ray));
        return oldEvent || newEvent;
    }

    public static boolean onReplaceBiomeBlocks(axq gen, int x, int z, ayw primer, amu world) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks(gen, x, z, primer, world);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() != Event.Result.DENY;
    }

    public static void onChunkPopulate(boolean pre, axq gen, amu world, Random rand, int x, int z, boolean hasVillageGenerated) {
        MinecraftForge.EVENT_BUS.post(pre ? new PopulateChunkEvent.Pre(gen, world, rand, x, z, hasVillageGenerated) : new PopulateChunkEvent.Post(gen, world, rand, x, z, hasVillageGenerated));
    }

    public static bfs loadLootTable(nf name, bfs table, bfv lootTableManager) {
        LootTableLoadEvent event = new LootTableLoadEvent(name, table, lootTableManager);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return bfs.a;
        }
        return event.getTable();
    }

    public static boolean canCreateFluidSource(amu world, et pos, awt state, boolean def) {
        BlockEvent.CreateFluidSourceEvent evt = new BlockEvent.CreateFluidSourceEvent(world, pos, state);
        MinecraftForge.EVENT_BUS.post(evt);
        Event.Result result = evt.getResult();
        return result == Event.Result.DEFAULT ? def : result == Event.Result.ALLOW;
    }

    public static boolean onTrySpawnPortal(amu world, et pos, ass.a size) {
        return MinecraftForge.EVENT_BUS.post(new BlockEvent.PortalSpawnEvent(world, pos, world.o(pos), size));
    }

    public static int onEnchantmentLevelSet(amu world, et pos, int enchantRow, int power, aip itemStack, int level) {
        EnchantmentLevelSetEvent e2 = new EnchantmentLevelSetEvent(world, pos, enchantRow, power, itemStack, level);
        MinecraftForge.EVENT_BUS.post(e2);
        return e2.getLevel();
    }

    public static boolean onEntityDestroyBlock(vp entity, et pos, awt state) {
        return !MinecraftForge.EVENT_BUS.post(new LivingDestroyBlockEvent(entity, pos, state));
    }

    public static boolean gatherCollisionBoxes(amu world, vg entity, bhb aabb, List<bhb> outList) {
        MinecraftForge.EVENT_BUS.post(new GetCollisionBoxesEvent(world, entity, aabb, outList));
        return outList.isEmpty();
    }

    public static boolean getMobGriefingEvent(amu world, vg entity) {
        EntityMobGriefingEvent event = new EntityMobGriefingEvent(entity);
        MinecraftForge.EVENT_BUS.post(event);
        Event.Result result = event.getResult();
        return result == Event.Result.DEFAULT ? world.W().b("mobGriefing") : result == Event.Result.ALLOW;
    }

    public static void onGameRuleChange(amr rules, String ruleName, MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post(new GameRuleChangeEvent(rules, ruleName, server));
    }

    public static amh listTradeOffers(amf merchant, aed player, @Nullable amh list) {
        amh dupeList = null;
        if (list != null) {
            dupeList = new amh();
            dupeList.addAll((Collection)list);
        }
        MerchantTradeOffersEvent event = new MerchantTradeOffersEvent(merchant, player, dupeList);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getList();
    }
}

