/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.config;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.IFieldWrapper;
import net.minecraftforge.common.config.ITypeAdapter;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.config.TypeAdapters;
import org.apache.commons.lang3.StringUtils;

public abstract class FieldWrapper
implements IFieldWrapper {
    protected String category;
    protected String name;
    protected Field field;
    protected Object instance;

    public FieldWrapper(String category, Field field, Object instance) {
        this.instance = instance;
        this.field = field;
        this.category = category;
        this.name = field.getName();
        if (field.isAnnotationPresent(Config.Name.class)) {
            this.name = field.getAnnotation(Config.Name.class).value();
        }
        this.field.setAccessible(true);
    }

    public static IFieldWrapper get(Object instance, Field field, String category) {
        if (ConfigManager.ADAPTERS.get(field.getType()) != null) {
            return new PrimitiveWrapper(category, field, instance);
        }
        if (Enum.class.isAssignableFrom(field.getType())) {
            return new EnumWrapper(category, field, instance);
        }
        if (Map.class.isAssignableFrom(field.getType())) {
            return new MapWrapper(category, field, instance);
        }
        if (field.getType().getSuperclass().equals(Object.class)) {
            throw new RuntimeException("Objects should not be handled by field wrappers");
        }
        throw new IllegalArgumentException(String.format("Fields of type '%s' are not supported!", field.getType().getCanonicalName()));
    }

    public static boolean hasWrapperFor(Field field) {
        if (ConfigManager.ADAPTERS.get(field.getType()) != null) {
            return true;
        }
        if (Enum.class.isAssignableFrom(field.getType())) {
            return true;
        }
        return Map.class.isAssignableFrom(field.getType());
    }

    private static <T> T[] asArray(T ... in2) {
        return in2;
    }

    public static class BeanEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public BeanEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("This is a static bean.");
        }
    }

    private static abstract class SingleValueFieldWrapper
    extends FieldWrapper {
        private SingleValueFieldWrapper(String category, Field field, Object instance) {
            super(category, field, instance);
        }

        @Override
        public String[] getKeys() {
            return (String[])FieldWrapper.asArray(new String[]{this.category + "." + this.name});
        }

        @Override
        public boolean hasKey(String key) {
            return (this.category + "." + this.name).equals(key);
        }

        @Override
        public boolean handlesKey(String key) {
            return this.hasKey(key);
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart, boolean hasSlidingControl) {
            Property prop = cfg2.getCategory(this.category).get(this.name);
            prop.setComment(desc);
            prop.setLanguageKey(langKey);
            prop.setRequiresMcRestart(reqMCRestart);
            prop.setRequiresWorldRestart(reqWorldRestart);
            prop.setHasSlidingControl(hasSlidingControl);
        }

        @Override
        public String getCategory() {
            return this.category;
        }
    }

    private static class PrimitiveWrapper
    extends SingleValueFieldWrapper {
        private PrimitiveWrapper(String category, Field field, Object instance) {
            super(category, field, instance);
        }

        @Override
        public ITypeAdapter getTypeAdapter() {
            return ConfigManager.ADAPTERS.get(this.field.getType());
        }

        @Override
        public Object getValue(String key) {
            if (!this.hasKey(key)) {
                throw new IllegalArgumentException("Unknown key!");
            }
            try {
                return this.field.get(this.instance);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void setValue(String key, Object value) {
            if (!this.hasKey(key)) {
                throw new IllegalArgumentException("Unknown key: " + key);
            }
            try {
                this.field.set(this.instance, value);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart) {
            this.setupConfiguration(cfg2, desc, langKey, reqMCRestart, reqWorldRestart, false);
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart, boolean hasSlidingControl) {
            Config.RangeDouble da;
            super.setupConfiguration(cfg2, desc, langKey, reqMCRestart, reqWorldRestart, hasSlidingControl);
            Property prop = cfg2.getCategory(this.category).get(this.name);
            Config.RangeInt ia = this.field.getAnnotation(Config.RangeInt.class);
            if (ia != null) {
                prop.setMinValue(ia.min());
                prop.setMaxValue(ia.max());
                if (desc != null) {
                    prop.setComment(ConfigManager.NEW_LINE.join((Object[])new String[]{desc, "Min: " + ia.min(), "Max: " + ia.max()}));
                } else {
                    prop.setComment(ConfigManager.NEW_LINE.join((Object[])new String[]{"Min: " + ia.min(), "Max: " + ia.max()}));
                }
                prop.setHasSlidingControl(hasSlidingControl);
            }
            if ((da = this.field.getAnnotation(Config.RangeDouble.class)) != null) {
                prop.setMinValue(da.min());
                prop.setMaxValue(da.max());
                if (desc != null) {
                    prop.setComment(ConfigManager.NEW_LINE.join((Object[])new String[]{desc, "Min: " + da.min(), "Max: " + da.max()}));
                } else {
                    prop.setComment(ConfigManager.NEW_LINE.join((Object[])new String[]{"Min: " + da.min(), "Max: " + da.max()}));
                }
                prop.setHasSlidingControl(hasSlidingControl);
            }
        }
    }

    private static class EnumWrapper
    extends SingleValueFieldWrapper {
        private EnumWrapper(String category, Field field, Object instance) {
            super(category, field, instance);
        }

        @Override
        public ITypeAdapter getTypeAdapter() {
            return TypeAdapters.Str;
        }

        @Override
        public Object getValue(String key) {
            if (!this.hasKey(key)) {
                throw new IllegalArgumentException("Unsupported Key!");
            }
            try {
                Enum enu = (Enum)this.field.get(this.instance);
                return enu.name();
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void setValue(String key, Object value) {
            if (!this.hasKey(key)) {
                throw new IllegalArgumentException("Unsupported Key!");
            }
            Object enu = Enum.valueOf(this.field.getType(), (String)value);
            try {
                this.field.set(this.instance, enu);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart) {
            this.setupConfiguration(cfg2, desc, langKey, reqMCRestart, reqWorldRestart, false);
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart, boolean hasSlidingControl) {
            super.setupConfiguration(cfg2, desc, langKey, reqMCRestart, reqWorldRestart, hasSlidingControl);
            Property prop = cfg2.getCategory(this.category).get(this.name);
            ArrayList listValidValues = Lists.newArrayList();
            ArrayList listValidValuesDisplay = Lists.newArrayList();
            for (Enum e2 : (Enum[])this.field.getType().getEnumConstants()) {
                listValidValues.add(e2.name());
                listValidValuesDisplay.add(e2.toString());
            }
            prop.setValidationPattern(Pattern.compile(ConfigManager.PIPE.join((Iterable)listValidValues)));
            prop.setValidValues(listValidValues.toArray(new String[0]));
            prop.setValidValuesDisplay(listValidValuesDisplay.toArray(new String[0]));
            String validValues = ConfigManager.NEW_LINE.join((Iterable)listValidValues);
            if (desc != null) {
                prop.setComment(ConfigManager.NEW_LINE.join((Object[])new String[]{desc, "Valid values:"}) + "\n" + validValues);
            } else {
                prop.setComment("Valid values:\n" + validValues);
            }
        }
    }

    private static class MapWrapper
    extends FieldWrapper {
        private Map<String, Object> theMap = null;
        private Type mType;
        private final String baseName = this.category == null ? "" : this.category + "." + this.name.toLowerCase(Locale.ENGLISH) + ".";
        ITypeAdapter adapter;

        private MapWrapper(String category, Field field, Object instance) {
            super(category, field, instance);
            try {
                this.theMap = (Map)field.get(instance);
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException(String.format("The map '%s' of class '%s' must have the key type String!", field.getName(), field.getDeclaringClass().getCanonicalName()), cce);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            this.mType = type.getActualTypeArguments()[1];
            this.adapter = ConfigManager.ADAPTERS.get(this.mType);
            if (this.adapter == null && this.mType instanceof GenericArrayType) {
                this.adapter = ConfigManager.ADAPTERS.get(ConfigManager.ARRAY_REMAP.get(((GenericArrayType)this.mType).getGenericComponentType()));
            }
            if (this.mType instanceof Class && Enum.class.isAssignableFrom((Class)this.mType)) {
                this.adapter = TypeAdapters.Str;
            }
            if (this.adapter == null) {
                throw new IllegalArgumentException(String.format("The map '%s' of class '%s' has target values which are neither primitive nor an enum!", field.getName(), field.getDeclaringClass().getCanonicalName()));
            }
        }

        @Override
        public ITypeAdapter getTypeAdapter() {
            return this.adapter;
        }

        @Override
        public String[] getKeys() {
            Set<String> keys = this.theMap.keySet();
            String[] keyArray = new String[keys.size()];
            Iterator<String> it = keys.iterator();
            for (int i2 = 0; i2 < keyArray.length; ++i2) {
                keyArray[i2] = this.baseName + it.next();
            }
            return keyArray;
        }

        @Override
        public Object getValue(String key) {
            return this.theMap.get(this.getSuffix(key));
        }

        @Override
        public void setValue(String key, Object value) {
            this.theMap.put(this.getSuffix(key), value);
        }

        @Override
        public boolean hasKey(String key) {
            return this.theMap.containsKey(this.getSuffix(key));
        }

        @Override
        public boolean handlesKey(String key) {
            if (key == null) {
                return false;
            }
            return key.startsWith(this.baseName);
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart) {
            this.setupConfiguration(cfg2, desc, langKey, reqMCRestart, reqWorldRestart, false);
        }

        @Override
        public void setupConfiguration(Configuration cfg2, String desc, String langKey, boolean reqMCRestart, boolean reqWorldRestart, boolean hasSlidingControl) {
            ConfigCategory confCat = cfg2.getCategory(this.getCategory());
            confCat.setComment(desc);
            confCat.setLanguageKey(langKey);
            confCat.setRequiresMcRestart(reqMCRestart);
            confCat.setRequiresWorldRestart(reqWorldRestart);
        }

        @Override
        public String getCategory() {
            return this.category == null ? "" : this.category + "." + this.name.toLowerCase(Locale.ENGLISH);
        }

        private String getSuffix(String key) {
            return StringUtils.replaceOnce((String)key, (String)this.baseName, (String)"");
        }
    }
}

