/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.network.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Scanner;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import red.mohist.Mohist;
import red.mohist.configuration.MohistConfigUtil;
import red.mohist.network.download.UpdateUtils;
import red.mohist.util.i18n.Message;

public class DownloadJava {
    public static File java = new File("CustomJAVA/");
    public static File javabin = new File("CustomJAVA/bin/");
    private static File javadl = new File(java.getAbsolutePath() + "/java.zip");
    public static ArrayList<String> launchArgs = new ArrayList();

    public static void run(String[] args) throws Exception {
        launchArgs.addAll(Arrays.asList(args));
        if (!launchArgs.contains("launchedWithCustomJava8")) {
            if (!javabin.exists()) {
                if (!MohistConfigUtil.bMohist("use_custom_java8")) {
                    System.out.println(Message.getString("unsupported.java.version"));
                    Scanner scan = new Scanner(System.in);
                    System.out.println(Message.getString("customjava.ask"));
                    String input = scan.nextLine();
                    if (input.equalsIgnoreCase("Yes")) {
                        DownloadJava.searchJava();
                    } else {
                        System.out.println(Message.getString("customjava.no"));
                        System.exit(0);
                    }
                } else {
                    DownloadJava.searchJava();
                }
            } else {
                DownloadJava.searchJava();
            }
        }
    }

    public static void searchJava() throws Exception {
        if (System.getProperty("sun.arch.data.model").equals("64")) {
            if (DownloadJava.os().equals("Windows")) {
                DownloadJava.prepareLaunch("https://github.com/Shawiizz/shawiizz.github.io/releases/download/jrezipfiles/javawin64.zip", "java.exe");
            } else if (DownloadJava.os().equals("Unix")) {
                DownloadJava.prepareLaunch("https://github.com/Shawiizz/shawiizz.github.io/releases/download/jrezipfiles/javalinux64.zip", "java");
            } else if (DownloadJava.os().equals("Mac")) {
                DownloadJava.prepareLaunch("https://github.com/Shawiizz/shawiizz.github.io/releases/download/jrezipfiles/javamac64.zip", "java");
            }
        } else if (DownloadJava.os().equals("Windows")) {
            DownloadJava.prepareLaunch("https://github.com/Shawiizz/shawiizz.github.io/releases/download/jrezipfiles/janawin32.zip", "java.exe");
        } else if (DownloadJava.os().equals("Unix")) {
            DownloadJava.prepareLaunch("https://github.com/Shawiizz/shawiizz.github.io/releases/download/jrezipfiles/javalinux32.zip", "java");
        }
    }

    private static void prepareLaunch(String URL2, String javaName) throws Exception {
        if (!javabin.exists()) {
            java.mkdirs();
            java.createNewFile();
            System.out.println(Message.getFormatString("customjava.dl", new Object[]{DownloadJava.os()}));
            UpdateUtils.downloadFile(URL2, javadl);
            DownloadJava.unzip(new FileInputStream(javadl), java.toPath());
            javadl.delete();
            if (DownloadJava.os().equals("Unix")) {
                Runtime.getRuntime().exec("chmod 755 -R ./CustomJAVA");
            }
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(java.getAbsolutePath() + "/bin/" + javaName, "-jar"));
        launchArgs.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        launchArgs.add(new File(Mohist.class.getProtectionDomain().getCodeSource().getLocation().getPath().substring(1)).getName());
        launchArgs.add("launchedWithCustomJava8");
        command.addAll(launchArgs);
        System.out.println(Message.getFormatString("customjava.run", new Object[]{DownloadJava.os(), command}));
        UpdateUtils.restartServer(command);
    }

    public static void unzip(InputStream is, Path targetDir) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(ze.getName());
                if (ze.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
    }

    public static String os() {
        String o2 = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return o2.contains("win") ? "Windows" : (o2.contains("mac") ? "Mac" : (Stream.of("solaris", "sunos", "linux", "unix").anyMatch(o2::contains) ? "Unix" : "Unknown"));
    }
}

