/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class FMLNetworkEvent<T extends hb>
extends Event {
    private final T handler;
    private final gw manager;
    private final Class<T> type;
    private final Class<T> handle;

    FMLNetworkEvent(T thing, Class<T> type, gw manager) {
        this.handler = thing;
        this.type = type;
        this.manager = manager;
        this.handle = this.getType();
    }

    public Class<T> getHandlerType() {
        return this.getType();
    }

    public T getHandler() {
        return this.handler;
    }

    public gw getManager() {
        return this.manager;
    }

    public Class<T> getType() {
        return this.type;
    }

    public static class CustomNetworkEvent
    extends Event {
        private final Object wrappedEvent;

        public CustomNetworkEvent(Object wrappedEvent) {
            this.wrappedEvent = wrappedEvent;
        }

        public Object getWrappedEvent() {
            return this.wrappedEvent;
        }
    }

    public static class ServerCustomPacketEvent
    extends CustomPacketEvent<kx> {
        public ServerCustomPacketEvent(gw manager, FMLProxyPacket packet) {
            super((kx)manager.i(), kx.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.SERVER;
        }
    }

    public static class ClientCustomPacketEvent
    extends CustomPacketEvent<hw> {
        public ClientCustomPacketEvent(gw manager, FMLProxyPacket packet) {
            super((hw)manager.i(), hw.class, manager, packet);
        }

        @Override
        public Side side() {
            return Side.CLIENT;
        }
    }

    public static abstract class CustomPacketEvent<S extends hb>
    extends FMLNetworkEvent<S> {
        private final FMLProxyPacket packet;
        private FMLProxyPacket reply;

        CustomPacketEvent(S thing, Class<S> type, gw manager, FMLProxyPacket packet) {
            super(thing, type, manager);
            this.packet = packet;
        }

        public abstract Side side();

        public FMLProxyPacket getPacket() {
            return this.packet;
        }

        public FMLProxyPacket getReply() {
            return this.reply;
        }

        public void setReply(FMLProxyPacket reply) {
            this.reply = reply;
        }
    }

    public static class CustomPacketRegistrationEvent<S extends hb>
    extends FMLNetworkEvent<S> {
        private final ImmutableSet<String> registrations;
        private final String operation;
        private final Side side;

        public CustomPacketRegistrationEvent(gw manager, Set<String> registrations, String operation, Side side, Class<S> type) {
            super((hb)type.cast(manager.i()), type, manager);
            this.registrations = ImmutableSet.copyOf(registrations);
            this.side = side;
            this.operation = operation;
        }

        public ImmutableSet<String> getRegistrations() {
            return this.registrations;
        }

        public String getOperation() {
            return this.operation;
        }

        public Side getSide() {
            return this.side;
        }
    }

    public static class ClientDisconnectionFromServerEvent
    extends FMLNetworkEvent<hw> {
        public ClientDisconnectionFromServerEvent(gw manager) {
            super((hw)manager.i(), hw.class, manager);
        }
    }

    public static class ServerDisconnectionFromClientEvent
    extends FMLNetworkEvent<kx> {
        public ServerDisconnectionFromClientEvent(gw manager) {
            super((kx)manager.i(), kx.class, manager);
        }
    }

    public static class ServerConnectionFromClientEvent
    extends FMLNetworkEvent<kx> {
        private final boolean isLocal;

        public ServerConnectionFromClientEvent(gw manager) {
            super((kx)manager.i(), kx.class, manager);
            this.isLocal = manager.c();
        }

        public boolean isLocal() {
            return this.isLocal;
        }
    }

    public static class ClientConnectedToServerEvent
    extends FMLNetworkEvent<hw> {
        private final boolean isLocal;
        private final String connectionType;

        public ClientConnectedToServerEvent(gw manager, String connectionType) {
            super((hw)manager.i(), hw.class, manager);
            this.isLocal = manager.c();
            this.connectionType = connectionType;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public String getConnectionType() {
            return this.connectionType;
        }
    }
}

