/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import com.mohistmc.util.i18n.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLibraries {
    public static HashMap<String, String> fail = new HashMap();
    private static String mirror = "";

    public static void run() throws Exception {
        System.out.println(Message.getString("libraries.checking.start"));
        String url = mirror.equals("") ? "https://maven.mohistmc.com/" : mirror;
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        AtomicLong currentSize = new AtomicLong();
        LinkedHashSet<File> defaultLibs = new LinkedHashSet<File>();
        for (File file : DefaultLibraries.getDefaultLibs().keySet()) {
            if (file.exists() && MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(file.getName())) continue;
            if (file.getName().contains("launchwrapper")) {
                File customLaunchwrapper = new File(JarTool.getJarDir() + "/libraries/customize_libraries/launchwrapper-fccb-1.12.jar");
                if (MohistConfigUtil.bMohist("forge_can_call_bukkit")) {
                    if (file.exists()) {
                        file.delete();
                    }
                    if (customLaunchwrapper.exists() && MD5Util.md5CheckSum(customLaunchwrapper, "8f121345f96b77620fcfa69a4330947a")) continue;
                    defaultLibs.add(customLaunchwrapper);
                    continue;
                }
                if (customLaunchwrapper.exists()) {
                    customLaunchwrapper.delete();
                }
            }
            if (file.exists() && MD5Util.md5CheckSum(file, libs.get(file))) {
                currentSize.addAndGet(file.length());
                continue;
            }
            defaultLibs.add(file);
        }
        for (File file : defaultLibs) {
            file.getParentFile().mkdirs();
            String u = url + "libraries/" + file.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
            System.out.println(Message.getString("libraries.global.percentage") + Math.round((double)(currentSize.get() * 100L) / 7.0E7) + "%");
            try {
                UpdateUtils.downloadFile(u, file);
                currentSize.addAndGet(file.length());
                fail.remove(u.replace(url, ""));
            }
            catch (Exception e2) {
                System.out.println(Message.getFormatString("file.download.nook", new Object[]{u}));
                file.delete();
                fail.put(u.replace(url, ""), file.getAbsolutePath());
            }
        }
        if (!fail.isEmpty()) {
            if (!mirror.equals("")) {
                System.out.println("Looks like there is no maven available at the moment, or you don't have any network connection.\nPlease try again later or come into our Discord server (discord.gg/mohist) to get help.");
                System.out.println(Message.getString("libraries.checking.end"));
                for (String string : fail.keySet()) {
                    System.out.println("Link : " + string + "\nPath : " + fail.get(string) + "\n");
                }
                System.exit(0);
            }
            System.out.println(Message.getFormatString("update.retry", new Object[]{1}));
            System.out.println("Something went wrong during download, trying to download with the mirror...");
            mirror = "https://mavenmirror.mohistmc.com/";
            DefaultLibraries.run();
        } else {
            System.out.println(Message.getString("libraries.checking.end"));
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(DefaultLibraries.class.getClassLoader().getResourceAsStream("mohist_libraries.txt")));
        while ((str = b.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(JarTool.getJarDir() + "/" + s[0]), s[1]);
        }
        b.close();
        return temp;
    }

    public static void loadDefaultLibs() throws Exception {
        for (File lib : DefaultLibraries.getDefaultLibs().keySet()) {
            if (!lib.exists() || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(lib.getName())) continue;
            JarLoader.loadjar(lib.getAbsolutePath());
        }
    }
}

