/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import red.mohist.Mohist;
import red.mohist.util.FileUtil;
import red.mohist.util.NumberUtils;

public class MohistConfigUtil {
    public static File mohistyml = new File("mohist-config", "mohist.yml");

    public static String getString(String s, String key, String defaultreturn) {
        if (s.contains(key)) {
            String string = s.substring(s.indexOf(key));
            String s1 = string.substring(string.indexOf(": ") + 2);
            String[] ss = s1.split("\n");
            return ss[0].trim().replace("'", "").replace("\"", "");
        }
        return defaultreturn;
    }

    public static String getString(File f2, String key, String defaultreturn) {
        try {
            return MohistConfigUtil.getString(FileUtil.readContent(f2), key, defaultreturn);
        }
        catch (IOException e2) {
            return defaultreturn;
        }
    }

    public static boolean getBoolean(File f2, String key) {
        return Boolean.parseBoolean(MohistConfigUtil.getString(f2, key, "true"));
    }

    public static boolean getBoolean(File f2, String key, String b2) {
        return Boolean.parseBoolean(MohistConfigUtil.getString(f2, key, b2));
    }

    public static int getInt(File f2, String key, String defaultreturn) {
        String s = MohistConfigUtil.getString(f2, key, defaultreturn);
        if (NumberUtils.isInteger(s)) {
            return Integer.parseInt(s);
        }
        return Integer.parseInt(defaultreturn);
    }

    public static void copyMohistConfig() {
        try {
            if (!mohistyml.exists()) {
                mohistyml.mkdirs();
                Files.copy(Mohist.class.getClassLoader().getResourceAsStream("configurations/mohist.yml"), mohistyml.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e2) {
            System.out.println("File copy exception!");
        }
    }

    public static boolean bMohist(String key) {
        return MohistConfigUtil.getBoolean(mohistyml, key + ":");
    }

    public static boolean bMohist(String key, String defaultReturn) {
        return MohistConfigUtil.getBoolean(mohistyml, key + ":", defaultReturn);
    }
}

