/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.profile;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.properties.Property;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PreLookupProfileEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private final String name;
    private UUID uuid;
    private Set<ProfileProperty> properties = new HashSet<ProfileProperty>();

    public PreLookupProfileEvent(@Nonnull String name) {
        super(!Bukkit.isPrimaryThread());
        this.name = name;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(@Nullable UUID uuid) {
        this.uuid = uuid;
    }

    @Deprecated
    @Nonnull
    public Multimap<String, Property> getProperties() {
        ArrayListMultimap props = ArrayListMultimap.create();
        for (ProfileProperty property : this.properties) {
            props.put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature()));
        }
        return props;
    }

    @Deprecated
    public void setProperties(Multimap<String, Property> properties) {
        this.properties = new HashSet<ProfileProperty>();
        properties.values().forEach(property -> this.properties.add(new ProfileProperty(property.getName(), property.getValue(), property.getSignature())));
    }

    @Deprecated
    public void addProperties(Multimap<String, Property> properties) {
        properties.values().forEach(property -> this.properties.add(new ProfileProperty(property.getName(), property.getValue(), property.getSignature())));
    }

    public Set<ProfileProperty> getProfileProperties() {
        return this.properties;
    }

    public void setProfileProperties(Set<ProfileProperty> properties) {
        this.properties = new HashSet<ProfileProperty>();
        this.properties.addAll(properties);
    }

    public void addProfileProperties(Set<ProfileProperty> properties) {
        this.properties.addAll(properties);
    }

    @Override
    public HandlerList getHandlers() {
        return handlers;
    }
}

