/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mohistmc.api.ServerAPI;
import com.mohistmc.forge.MohistMod;
import com.mohistmc.util.i18n.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.CertificateHelper;
import net.minecraftforge.fml.common.DuplicateModsFoundException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.MCPDummyContainer;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.MinecraftDummyContainer;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.ModDiscoverer;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadEvent;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.registry.ItemStackHolderInjector;
import net.minecraftforge.fml.common.toposort.ModSorter;
import net.minecraftforge.fml.common.toposort.ModSortingException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DependencyParser;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import net.minecraftforge.fml.relauncher.libraries.Repository;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class Loader {
    public static final String MC_VERSION = "1.12.2";
    private static Loader instance;
    private static String major;
    private static String minor;
    private static String rev;
    private static String build;
    private static String mccversion;
    private static String mcpversion;
    private ModClassLoader modClassLoader;
    private List<ModContainer> mods;
    private Map<String, ModContainer> namedMods;
    private ListMultimap<String, String> reverseDependencies;
    private File canonicalConfigDir;
    private File canonicalModsDir;
    private LoadController modController;
    private MinecraftDummyContainer minecraft;
    private MCPDummyContainer mcp;
    private MohistMod mohistMod;
    private static File minecraftDir;
    private static List<String> injectedContainers;
    private ImmutableMap<String, String> fmlBrandingProperties;
    private File forcedModFile;
    private ModDiscoverer discoverer;
    private ProgressManager.ProgressBar progressBar;
    private ListMultimap<String, ArtifactVersion> injectedBefore = ArrayListMultimap.create();
    private ListMultimap<String, ArtifactVersion> injectedAfter = ArrayListMultimap.create();

    public static Loader instance() {
        if (instance == null) {
            instance = new Loader();
        }
        return instance;
    }

    public static void injectData(Object ... data) {
        major = (String)data[0];
        minor = (String)data[1];
        rev = (String)data[2];
        build = (String)data[3];
        mccversion = (String)data[4];
        mcpversion = (String)data[5];
        minecraftDir = (File)data[6];
        injectedContainers = (List)data[7];
    }

    private Loader() {
        this.modClassLoader = new ModClassLoader(this.getClass().getClassLoader());
        if (mccversion != null && !mccversion.equals(MC_VERSION)) {
            FMLLog.log.fatal(Message.getFormatString("forge.loader.1", new Object[]{mccversion, MC_VERSION}));
            throw new LoaderException(Message.getFormatString("forge.loader.2", new Object[]{mccversion, MC_VERSION}));
        }
        this.minecraft = new MinecraftDummyContainer(MC_VERSION);
        InputStream mcpModInputStream = this.getClass().getResourceAsStream("/mcpmod.info");
        InputStream mohistModInputStream = MohistMod.modinfo();
        try {
            this.mcp = new MCPDummyContainer(MetadataCollection.from(mcpModInputStream, "MCP").getMetadataForId("mcp", null));
            this.mohistMod = new MohistMod(MetadataCollection.from(mohistModInputStream, "Mohist").getMetadataForId("mohist", null));
        }
        finally {
            IOUtils.closeQuietly((InputStream)mcpModInputStream);
            IOUtils.closeQuietly((InputStream)mohistModInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortModList() {
        FMLLog.log.trace(Message.getString("forge.loader.3"));
        ArrayList<WrongMinecraftVersionException> wrongMinecraftExceptions = new ArrayList<WrongMinecraftVersionException>();
        ArrayList<MissingModsException> missingModsExceptions = new ArrayList<MissingModsException>();
        try {
            HashBiMap modVersions = HashBiMap.create();
            for (ModContainer modContainer : Iterables.concat(this.getActiveModList(), ModAPIManager.INSTANCE.getAPIList())) {
                modVersions.put((Object)modContainer.getModId(), (Object)modContainer.getProcessedVersion());
            }
            ArrayListMultimap reqList = ArrayListMultimap.create();
            for (ModContainer mod : this.getActiveModList()) {
                if (!mod.acceptableMinecraftVersionRange().containsVersion(this.minecraft.getProcessedVersion())) {
                    FMLLog.log.fatal(Message.getFormatString("forge.loader.4", new Object[]{mod.getModId(), this.getMCVersionString()}));
                    WrongMinecraftVersionException ret = new WrongMinecraftVersionException(mod, this.getMCVersionString());
                    FMLLog.log.fatal(ret.getMessage());
                    wrongMinecraftExceptions.add(ret);
                    continue;
                }
                reqList.putAll((Object)mod.getModId(), Iterables.transform(mod.getRequirements(), ArtifactVersion::getLabel));
                HashSet allDeps = Sets.newHashSet();
                allDeps.addAll(mod.getDependants());
                allDeps.addAll(mod.getDependencies());
                allDeps.addAll(mod.getRequirements());
                MissingModsException missingModsException = new MissingModsException(mod.getModId(), mod.getName());
                for (ArtifactVersion acceptedVersion : allDeps) {
                    ArtifactVersion currentVersion;
                    boolean required = mod.getRequirements().contains(acceptedVersion);
                    if (!required && !modVersions.containsKey((Object)acceptedVersion.getLabel()) || (currentVersion = (ArtifactVersion)modVersions.get((Object)acceptedVersion.getLabel())) != null && acceptedVersion.containsVersion(currentVersion)) continue;
                    missingModsException.addMissingMod(acceptedVersion, currentVersion, required);
                }
                if (missingModsException.getMissingModInfos().isEmpty()) continue;
                FMLLog.log.fatal(missingModsException.toString());
                missingModsExceptions.add(missingModsException);
            }
            if (!wrongMinecraftExceptions.isEmpty() || !missingModsExceptions.isEmpty()) {
                if (missingModsExceptions.size() == 1 && wrongMinecraftExceptions.isEmpty()) {
                    throw (MissingModsException)missingModsExceptions.get(0);
                }
                if (wrongMinecraftExceptions.size() == 1 && missingModsExceptions.isEmpty()) {
                    throw (WrongMinecraftVersionException)wrongMinecraftExceptions.get(0);
                }
                throw new MultipleModsErrored(wrongMinecraftExceptions, missingModsExceptions);
            }
            FMLLog.log.trace(Message.getString("forge.loader.4"));
            this.reverseDependencies = (ListMultimap)Multimaps.invertFrom((Multimap)reqList, (Multimap)ArrayListMultimap.create());
            ModSorter modSorter = new ModSorter(this.getActiveModList(), this.namedMods);
            try {
                FMLLog.log.trace(Message.getString("forge.loader.5"));
                List<ModContainer> sortedMods = modSorter.sort();
                this.modController.getActiveModList().clear();
                this.modController.getActiveModList().addAll(sortedMods);
                this.mods.removeAll(sortedMods);
                sortedMods.addAll(this.mods);
                this.mods = sortedMods;
                FMLLog.log.trace(Message.getString("forge.loader.7"));
            }
            catch (ModSortingException sortException) {
                FMLLog.log.fatal(Message.getString("forge.loader.8"));
                ModSortingException.SortingExceptionData exceptionData = sortException.getExceptionData();
                FMLLog.log.fatal(Message.getFormatString("forge.loader.9", new Object[]{exceptionData.getFirstBadNode()}));
                FMLLog.log.fatal(Message.getString("forge.loader.10"));
                for (ModContainer mc : exceptionData.getVisitedNodes()) {
                    FMLLog.log.fatal(Message.getFormatString("forge.loader.11", new Object[]{mc.toString(), mc.getDependants(), mc.getDependencies()}));
                }
                FMLLog.log.error(Message.getFormatString("forge.loader.12", new Object[]{sortException}));
                throw sortException;
            }
        }
        catch (Throwable throwable) {
            FMLLog.log.debug(Message.getString("forge.loader.13"));
            int unprintedMods = this.mods.size();
            for (ModContainer mod : this.getActiveModList()) {
                if (mod.isImmutable()) continue;
                FMLLog.log.debug("\t" + Message.getFormatString("forge.loader.14", new Object[]{mod.getModId(), mod.getName(), mod.getVersion(), mod.getSource().getName(), mod.getSortingRules()}));
                --unprintedMods;
            }
            if (unprintedMods == this.mods.size()) {
                FMLLog.log.debug(Message.getString("forge.loader.15"));
            }
            throw throwable;
        }
        FMLLog.log.debug(Message.getString("forge.loader.13"));
        int unprintedMods = this.mods.size();
        for (ModContainer modContainer : this.getActiveModList()) {
            if (modContainer.isImmutable()) continue;
            FMLLog.log.debug("\t" + Message.getFormatString("forge.loader.14", new Object[]{modContainer.getModId(), modContainer.getName(), modContainer.getVersion(), modContainer.getSource().getName(), modContainer.getSortingRules()}));
            --unprintedMods;
        }
        if (unprintedMods == this.mods.size()) {
            FMLLog.log.debug(Message.getString("forge.loader.15"));
        }
    }

    private ModDiscoverer identifyMods(List<String> additionalContainers) {
        injectedContainers.addAll(additionalContainers);
        FMLLog.log.debug(Message.getFormatString("forge.loader.16", new Object[]{injectedContainers}));
        this.mods.add(this.minecraft);
        this.mods.add(new InjectedModContainer(this.mcp, new File("minecraft.jar")));
        this.mods.add(new InjectedModContainer(this.mohistMod, new File("mohist.jar")));
        for (String cont : injectedContainers) {
            ModContainer mc;
            try {
                mc = (ModContainer)Class.forName(cont, true, this.modClassLoader).newInstance();
            }
            catch (Exception e) {
                FMLLog.log.error(Message.getFormatString("forge.loader.17", new Object[]{cont, e}));
                throw new LoaderException(e);
            }
            this.mods.add(new InjectedModContainer(mc, mc.getSource()));
        }
        ModDiscoverer discoverer = new ModDiscoverer();
        FMLLog.log.debug(Message.getString("forge.loader.18"));
        discoverer.findClasspathMods(this.modClassLoader);
        FMLLog.log.debug(Message.getString("forge.loader.19"));
        List<Artifact> maven_canidates = LibraryManager.flattenLists(minecraftDir);
        List<File> file_canidates = LibraryManager.gatherLegacyCanidates(minecraftDir);
        for (Artifact artifact : maven_canidates) {
            File target;
            if ((artifact = Repository.resolveAll(artifact)) == null || file_canidates.contains(target = artifact.getFile())) continue;
            file_canidates.add(target);
        }
        for (File mod : file_canidates) {
            if (CoreModManager.getIgnoredMods().contains(mod.getName())) {
                FMLLog.log.trace(Message.getFormatString("forge.loader.20", new Object[]{mod.getName()}));
                continue;
            }
            FMLLog.log.debug(Message.getFormatString("forge.loader.21", new Object[]{mod.getName()}));
            discoverer.addCandidate(new ModCandidate(mod, mod, ContainerType.JAR));
        }
        this.mods.addAll(discoverer.identifyMods());
        this.identifyDuplicates(this.mods);
        this.namedMods = Maps.uniqueIndex(this.mods, ModContainer::getModId);
        FMLLog.log.info(Message.getFormatString("forge.loader.22", new Object[]{this.mods.size(), this.mods.size() != 1 ? "s" : ""}));
        return discoverer;
    }

    private void identifyDuplicates(List<ModContainer> mods) {
        TreeMultimap dupsearch = TreeMultimap.create((Comparator)new ModIdComparator(), (Comparator)Ordering.arbitrary());
        for (ModContainer mc : mods) {
            if (mc.getSource() == null) continue;
            dupsearch.put((Object)mc, (Object)mc.getSource());
        }
        ImmutableMultiset duplist = Multisets.copyHighestCountFirst((Multiset)dupsearch.keys());
        LinkedHashMultimap dupes = LinkedHashMultimap.create();
        for (Multiset.Entry e : duplist.entrySet()) {
            if (e.getCount() <= 1) continue;
            FMLLog.log.fatal(Message.getFormatString("forge.loader.23", new Object[]{((ModContainer)e.getElement()).getModId(), dupsearch.get(e.getElement())}));
            dupes.putAll(e.getElement(), (Iterable)dupsearch.get(e.getElement()));
        }
        if (!dupes.isEmpty()) {
            throw new DuplicateModsFoundException((SetMultimap<ModContainer, File>)dupes);
        }
    }

    private void initializeLoader() {
        boolean dirMade;
        String canonicalConfigPath;
        String canonicalModsPath;
        File modsDir = new File(minecraftDir, "mods");
        File configDir = new File(minecraftDir, "config");
        try {
            canonicalModsPath = modsDir.getCanonicalPath();
            canonicalConfigPath = configDir.getCanonicalPath();
            this.canonicalConfigDir = configDir.getCanonicalFile();
            this.canonicalModsDir = modsDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            FMLLog.log.error(Message.getFormatString("forge.loader.24", new Object[]{this.canonicalModsDir.getAbsolutePath(), configDir.getAbsolutePath(), ioe}));
            throw new LoaderException(ioe);
        }
        if (!this.canonicalModsDir.exists()) {
            FMLLog.log.info(Message.getFormatString("forge.loader.25", new Object[]{canonicalModsPath}));
            dirMade = this.canonicalModsDir.mkdir();
            if (!dirMade) {
                FMLLog.log.fatal(Message.getFormatString("forge.loader.26", new Object[]{canonicalModsPath}));
                throw new LoaderException(Message.getFormatString("forge.loader.27", new Object[]{canonicalModsPath}));
            }
            FMLLog.log.info(Message.getString("forge.loader.28"));
        }
        if (!this.canonicalConfigDir.exists()) {
            FMLLog.log.debug(Message.getFormatString("forge.loader.29", new Object[]{canonicalConfigPath}));
            dirMade = this.canonicalConfigDir.mkdir();
            if (!dirMade) {
                FMLLog.log.fatal(Message.getFormatString("forge.loader.30", new Object[]{canonicalConfigPath}));
                throw new LoaderException();
            }
            FMLLog.log.info(Message.getString("forge.loader.31"));
        }
        if (!this.canonicalModsDir.isDirectory()) {
            FMLLog.log.fatal(Message.getFormatString("forge.loader.32", new Object[]{canonicalModsPath}));
            throw new LoaderException();
        }
        if (!configDir.isDirectory()) {
            FMLLog.log.fatal(Message.getFormatString("forge.loader.33", new Object[]{canonicalConfigPath}));
            throw new LoaderException();
        }
        this.readInjectedDependencies();
    }

    public List<ModContainer> getModList() {
        return Loader.instance().mods != null ? ImmutableList.copyOf(Loader.instance().mods) : ImmutableList.of();
    }

    public void setupTestHarness(ModContainer ... containers) {
        this.modController = new LoadController(this);
        this.mods = Lists.newArrayList((Object[])containers);
        this.namedMods = Maps.uniqueIndex(this.mods, ModContainer::getModId);
        this.modController.transition(LoaderState.LOADING, false);
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        ObjectHolderRegistry.INSTANCE.findObjectHolders(new ASMDataTable());
        this.modController.forceActiveContainer(containers[0]);
    }

    public void loadMods(List<String> injectedModContainers) {
        this.progressBar = ProgressManager.push("Loading", 7);
        this.progressBar.step("Constructing Mods");
        this.initializeLoader();
        this.mods = Lists.newArrayList();
        this.namedMods = Maps.newHashMap();
        this.modController = new LoadController(this);
        this.modController.transition(LoaderState.LOADING, false);
        this.discoverer = this.identifyMods(injectedModContainers);
        ModAPIManager.INSTANCE.manageAPI(this.modClassLoader, this.discoverer);
        this.disableRequestedMods();
        this.modController.distributeStateMessage(FMLLoadEvent.class);
        this.sortModList();
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.modController.getActiveModList());
        ModAPIManager.INSTANCE.cleanupAPIContainers(this.mods);
        this.mods = ImmutableList.copyOf(this.mods);
        for (File nonMod : this.discoverer.getNonModLibs()) {
            if (!nonMod.isFile()) continue;
            try {
                this.modClassLoader.addFile(nonMod);
            }
            catch (MalformedURLException e) {
                FMLLog.log.error(Message.getFormatString("forge.loader.35", new Object[]{nonMod.getName(), e}));
            }
        }
        ConfigManager.loadData(this.discoverer.getASMTable());
        this.modController.transition(LoaderState.CONSTRUCTING, false);
        this.modController.distributeStateMessage(LoaderState.CONSTRUCTING, this.modClassLoader, this.discoverer.getASMTable(), this.reverseDependencies);
        FMLLog.log.debug(Message.getString("forge.loader.36"));
        FMLLog.log.debug(" \t" + Message.getString("forge.loader.37"));
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() == null) continue;
            FMLLog.log.debug("\t\t({}) {}\t({}\t{})\t{}", (Object)CertificateHelper.getFingerprint(mod.getSigningCertificate()), (Object)mod.getModId(), (Object)mod.getName(), (Object)mod.getVersion(), (Object)mod.getSource().getName());
        }
        FMLLog.log.debug(" \t " + Message.getString("forge.loader.38"));
        for (ModContainer mod : this.getActiveModList()) {
            if (mod.getSigningCertificate() != null) continue;
            FMLLog.log.debug("\t\t{}\t({}\t{})\t{}", (Object)mod.getModId(), (Object)mod.getName(), (Object)mod.getVersion(), (Object)mod.getSource().getName());
        }
        if (this.getActiveModList().isEmpty()) {
            FMLLog.log.debug(Message.getString("forge.loader.39"));
        }
        this.progressBar.step("Initializing mods Phase 1");
        this.modController.transition(LoaderState.PREINITIALIZATION, false);
    }

    public void preinitializeMods() {
        if (!this.modController.isInState(LoaderState.PREINITIALIZATION)) {
            FMLLog.log.warn(Message.getString("forge.loader.40"));
            return;
        }
        GameData.fireCreateRegistryEvents();
        ObjectHolderRegistry.INSTANCE.findObjectHolders(this.discoverer.getASMTable());
        ItemStackHolderInjector.INSTANCE.findHolders(this.discoverer.getASMTable());
        CapabilityManager.INSTANCE.injectCapabilities(this.discoverer.getASMTable());
        this.modController.distributeStateMessage(LoaderState.PREINITIALIZATION, this.discoverer.getASMTable(), this.canonicalConfigDir);
        GameData.fireRegistryEvents(rl2 -> !rl2.equals((Object)GameData.RECIPES));
        FMLCommonHandler.instance().fireSidedRegistryEvents();
        ObjectHolderRegistry.INSTANCE.applyObjectHolders();
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.transition(LoaderState.INITIALIZATION, false);
        this.progressBar.step("Initializing Minecraft Engine");
    }

    private void disableRequestedMods() {
        String forcedModList = System.getProperty("fml.modStates", "");
        FMLLog.log.trace(Message.getFormatString("forge.loader.41", new Object[]{forcedModList}));
        Map sysPropertyStateList = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)";:")).omitEmptyStrings().trimResults().withKeyValueSeparator("=").split((CharSequence)forcedModList);
        FMLLog.log.trace(Message.getFormatString("forge.loader.42", new Object[]{sysPropertyStateList.size()}));
        HashMap modStates = Maps.newHashMap();
        this.forcedModFile = new File(this.canonicalConfigDir, "fmlModState.properties");
        Properties forcedModListProperties = new Properties();
        if (this.forcedModFile.exists() && this.forcedModFile.isFile()) {
            FMLLog.log.trace(Message.getFormatString("forge.loader.43", new Object[]{this.forcedModFile.getName()}));
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.forcedModFile), StandardCharsets.UTF_8);
                Object object = null;
                try {
                    forcedModListProperties.load(reader);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (object != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((Reader)reader).close();
                        }
                    }
                }
                FMLLog.log.trace(Message.getFormatString("forge.loader.44", new Object[]{forcedModListProperties.size()}));
            }
            catch (Exception e) {
                FMLLog.log.info(Message.getString("forge.loader.45"), (Throwable)e);
            }
        }
        modStates.putAll(Maps.fromProperties((Properties)forcedModListProperties));
        modStates.putAll(sysPropertyStateList);
        FMLLog.log.debug(Message.getFormatString("forge.loader.46", new Object[]{modStates.size()}));
        Map isEnabled = Maps.transformValues((Map)modStates, Boolean::parseBoolean);
        for (Map.Entry entry : isEnabled.entrySet()) {
            if (!this.namedMods.containsKey(entry.getKey())) continue;
            FMLLog.log.info(Message.getFormatString("forge.loader.47", new Object[]{entry.getKey(), entry.getValue()}));
            this.namedMods.get(entry.getKey()).setEnabledState((Boolean)entry.getValue());
        }
    }

    public static boolean isModLoaded(String modname) {
        return Loader.instance().namedMods.containsKey(modname) && Loader.instance().modController.getModState(Loader.instance.namedMods.get(modname)) != LoaderState.ModState.DISABLED;
    }

    public File getConfigDir() {
        return this.canonicalConfigDir;
    }

    public String getCrashInformation() {
        if (this.modController == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        List<String> branding = FMLCommonHandler.instance().getBrandings(false);
        Joiner.on((char)' ').skipNulls().appendTo(ret, branding);
        if (this.modController != null) {
            this.modController.printModStates(ret);
        }
        return ret.toString();
    }

    public String getFMLVersionString() {
        return "8.0.99.99";
    }

    public ModClassLoader getModClassLoader() {
        return this.modClassLoader;
    }

    @Deprecated
    public void computeDependencies(String dependencyString, Set<ArtifactVersion> requirements, List<ArtifactVersion> dependencies, List<ArtifactVersion> dependants) {
        DependencyParser dependencyParser = new DependencyParser("unknown", FMLCommonHandler.instance().getSide());
        DependencyParser.DependencyInfo info = dependencyParser.parseDependencies(dependencyString);
        requirements.addAll(info.requirements);
        dependencies.addAll(info.dependencies);
        dependants.addAll(info.dependants);
    }

    public Map<String, ModContainer> getIndexedModList() {
        return this.namedMods != null ? ImmutableMap.copyOf(this.namedMods) : ImmutableMap.of();
    }

    public void initializeMods() {
        this.progressBar.step("Initializing mods Phase 2");
        CraftingHelper.loadRecipes(false);
        this.modController.distributeStateMessage(LoaderState.INITIALIZATION, new Object[0]);
        this.progressBar.step("Initializing mods Phase 3");
        this.modController.transition(LoaderState.POSTINITIALIZATION, false);
        this.modController.distributeStateMessage(FMLInterModComms.IMCEvent.class);
        ItemStackHolderInjector.INSTANCE.inject();
        this.modController.distributeStateMessage(LoaderState.POSTINITIALIZATION, new Object[0]);
        this.progressBar.step("Finishing up");
        this.modController.transition(LoaderState.AVAILABLE, false);
        this.modController.distributeStateMessage(LoaderState.AVAILABLE, new Object[0]);
        GameData.freezeData();
        ServerAPI.mods.put("mods", this.mods.size());
        FMLLog.log.info(Message.getFormatString("forge.loader.48", new Object[]{this.mods.size(), this.mods.size() == 1 ? "" : "s"}));
        this.progressBar.step("Completing Minecraft initialization");
    }

    public ICrashCallable getCallableCrashInformation() {
        return new ICrashCallable(){

            public String call() throws Exception {
                return Loader.this.getCrashInformation();
            }

            @Override
            public String getLabel() {
                return "FML";
            }
        };
    }

    public List<ModContainer> getActiveModList() {
        return this.modController != null ? this.modController.getActiveModList() : ImmutableList.of();
    }

    public LoaderState.ModState getModState(ModContainer selectedMod) {
        return this.modController.getModState(selectedMod);
    }

    public String getMCVersionString() {
        return "Minecraft " + mccversion;
    }

    public boolean serverStarting(Object server) {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTING, server);
        this.modController.transition(LoaderState.SERVER_STARTING, false);
        return true;
    }

    public void serverStarted() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STARTED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STARTED, false);
    }

    public void serverStopping() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPING, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPING, false);
    }

    public BiMap<ModContainer, Object> getModObjectList() {
        return this.modController.getModObjectList();
    }

    public BiMap<Object, ModContainer> getReversedModObjectList() {
        return this.getModObjectList().inverse();
    }

    @Nullable
    public ModContainer activeModContainer() {
        return this.modController != null ? this.modController.activeContainer() : null;
    }

    public boolean isInState(LoaderState state) {
        return this.modController.isInState(state);
    }

    public MinecraftDummyContainer getMinecraftModContainer() {
        return this.minecraft;
    }

    public boolean hasReachedState(LoaderState state) {
        return this.modController != null ? this.modController.hasReachedState(state) : false;
    }

    public String getMCPVersionString() {
        return String.format("MCP %s", mcpversion);
    }

    public void serverStopped() {
        this.modController.distributeStateMessage(LoaderState.SERVER_STOPPED, new Object[0]);
        this.modController.transition(LoaderState.SERVER_STOPPED, true);
        this.modController.transition(LoaderState.AVAILABLE, true);
    }

    public boolean serverAboutToStart(Object server) {
        this.modController.distributeStateMessage(LoaderState.SERVER_ABOUT_TO_START, server);
        this.modController.transition(LoaderState.SERVER_ABOUT_TO_START, false);
        return true;
    }

    public Map<String, String> getFMLBrandingProperties() {
        if (this.fmlBrandingProperties == null) {
            Properties loaded = new Properties();
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("fmlbranding.properties");){
                loaded.load(stream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fmlBrandingProperties = Maps.fromProperties((Properties)loaded);
        }
        return this.fmlBrandingProperties;
    }

    public Map<String, String> getCustomModProperties(String modId) {
        return this.getIndexedModList().get(modId).getCustomModProperties();
    }

    boolean checkRemoteModList(Map<String, String> modList, Side side) {
        Set<String> remoteModIds = modList.keySet();
        Set<String> localModIds = this.namedMods.keySet();
        LinkedHashSet difference = Sets.newLinkedHashSet((Iterable)Sets.difference(localModIds, remoteModIds));
        Iterator iterator = difference.iterator();
        while (iterator.hasNext()) {
            String missingRemotely = (String)iterator.next();
            LoaderState.ModState modState = this.modController.getModState(this.namedMods.get(missingRemotely));
            if (modState != LoaderState.ModState.DISABLED) continue;
            iterator.remove();
        }
        if (difference.size() > 0) {
            ServerAPI.modlists.addAll(difference);
            FMLLog.log.info(Message.getFormatString("forge.loader.48", new Object[]{difference, side}));
        }
        return true;
    }

    public void fireRemapEvent(Map<nf, Map<nf, Integer[]>> remaps, boolean isFreezing) {
        if (this.modController != null) {
            this.modController.propogateStateMessage(new FMLModIdMappingEvent(remaps, isFreezing));
        }
    }

    public void runtimeDisableMod(String modId) {
        ModContainer mc = this.namedMods.get(modId);
        ModContainer.Disableable disableable = mc.canBeDisabled();
        if (disableable == ModContainer.Disableable.NEVER) {
            FMLLog.log.info(Message.getFormatString("forge.loader.50", new Object[]{modId}));
            return;
        }
        if (disableable == ModContainer.Disableable.DEPENDENCIES) {
            FMLLog.log.info(Message.getFormatString("forge.loader.51", new Object[]{modId}));
            return;
        }
        if (disableable == ModContainer.Disableable.YES) {
            FMLLog.log.info(Message.getFormatString("forge.loader.52", new Object[]{modId}));
            this.modController.disableMod(mc);
            ArrayList localmods = Lists.newArrayList(this.mods);
            localmods.remove(mc);
            this.mods = ImmutableList.copyOf((Collection)localmods);
        }
        try {
            Properties props = new Properties();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.forcedModFile), StandardCharsets.UTF_8);){
                props.load(reader);
            }
            props.put(modId, "false");
            var6_7 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.forcedModFile), StandardCharsets.UTF_8);){
                props.store(writer, null);
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            FMLLog.log.info(Message.getString("forge.loader.53"), (Throwable)e);
        }
    }

    public void loadingComplete() {
        ProgressManager.pop(this.progressBar);
        this.progressBar = null;
    }

    private void readInjectedDependencies() {
        File injectedDepFile = new File(this.getConfigDir(), "injectedDependencies.json");
        if (!injectedDepFile.exists()) {
            FMLLog.log.debug(Message.getFormatString("forge.loader.54", new Object[]{injectedDepFile.getAbsolutePath()}));
            return;
        }
        JsonParser parser = new JsonParser();
        try {
            JsonElement injectedDeps;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(injectedDepFile), StandardCharsets.UTF_8);){
                injectedDeps = parser.parse((Reader)reader);
            }
            for (JsonElement el : injectedDeps.getAsJsonArray()) {
                JsonObject jo = el.getAsJsonObject();
                String modId = jo.get("modId").getAsString();
                JsonArray deps = jo.get("deps").getAsJsonArray();
                for (JsonElement dep : deps) {
                    JsonObject depObj = dep.getAsJsonObject();
                    String type = depObj.get("type").getAsString();
                    if (type.equals("before")) {
                        this.injectedBefore.put((Object)modId, (Object)VersionParser.parseVersionReference(depObj.get("target").getAsString()));
                        continue;
                    }
                    if (type.equals("after")) {
                        this.injectedAfter.put((Object)modId, (Object)VersionParser.parseVersionReference(depObj.get("target").getAsString()));
                        continue;
                    }
                    FMLLog.log.error(Message.getFormatString("forge.loader.55", new Object[]{type}));
                    throw new RuntimeException("Unable to parse type");
                }
            }
        }
        catch (Exception e) {
            FMLLog.log.error(Message.getFormatString("forge.loader.56", new Object[]{injectedDepFile}));
            FMLLog.log.throwing(Level.ERROR, (Throwable)e);
            return;
        }
        FMLLog.log.debug(Message.getFormatString("forge.loader.57", new Object[]{this.injectedBefore.size(), this.injectedBefore.keySet()}));
    }

    List<ArtifactVersion> getInjectedBefore(String modId) {
        return this.injectedBefore.get((Object)modId);
    }

    List<ArtifactVersion> getInjectedAfter(String modId) {
        return this.injectedAfter.get((Object)modId);
    }

    public final LoaderState getLoaderState() {
        return this.modController != null ? this.modController.getState() : LoaderState.NOINIT;
    }

    public void setActiveModContainer(@Nullable ModContainer container) {
        this.modController.forceActiveContainer(container);
    }

    private class ModIdComparator
    implements Comparator<ModContainer> {
        private ModIdComparator() {
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            return o1.getModId().compareTo(o2.getModId());
        }
    }
}

