/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.command;

import com.mohistmc.api.ServerAPI;
import com.mohistmc.util.i18n.Message;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.FileUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class DumpCommand
extends Command {
    private final List<String> params = Arrays.asList("potions", "enchants", "cbcmds", "modscmds", "entitytypes", "biomes", "pattern", "worldgen", "worldtype", "material");

    public DumpCommand(String name) {
        super(name);
        this.description = "Universal Dump, which will print the information you need locally!";
        this.usageMessage = "/dump [potions|enchants|cbcmds|modscmds|entitytypes|biomes|pattern|worldgen|worldtype|material]";
        this.setPermission("mohist.command.dump");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!sender.isOp() || !this.testPermission(sender)) {
            sender.sendMessage(Message.getString("command.nopermission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "potions": {
                this.dumpPotions(sender);
                break;
            }
            case "enchants": {
                this.dumpEnchant(sender);
                break;
            }
            case "cbcmds": {
                this.dumpCBCommands(sender);
                break;
            }
            case "modscmds": {
                this.dumpModsCommands(sender);
                break;
            }
            case "entitytypes": {
                this.dumpEntityTypes(sender);
                break;
            }
            case "biomes": {
                this.dumpBiomes(sender);
                break;
            }
            case "pattern": {
                this.dumpPattern(sender);
                break;
            }
            case "worldgen": {
                this.dumpWorldGen(sender);
                break;
            }
            case "worldtype": {
                this.dumpWorldType(sender);
                break;
            }
            case "material": {
                this.dumpMaterial(sender);
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return false;
    }

    private void dumpPotions(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (PotionEffectType potionEffectType : PotionEffectType.values()) {
            if (potionEffectType == null) continue;
            sb.append(potionEffectType.toString()).append("\n");
        }
        for (PotionType potionType : PotionType.values()) {
            if (potionType == null) continue;
            sb.append(potionType.toString()).append("\n");
        }
        File file = new File("dump", "potions.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "potions");
    }

    private void dumpEnchant(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Enchantment ench : Enchantment.values()) {
            sb.append(ench.toString()).append("\n");
        }
        File file = new File("dump", "enchants.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "enchants");
    }

    private void dumpEntityTypes(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (EntityType ent : EntityType.values()) {
            sb.append(ent.toString()).append("\n");
        }
        File file = new File("dump", "entitytypes.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "entitytypes");
    }

    private void dumpCBCommands(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Command per : MinecraftServer.getServerInst().server.getCommandMap().getCommands()) {
            if (per.getPermission() == null) continue;
            sb.append(per.getName()).append(": ").append(per.getPermission()).append("\n");
        }
        File file = new File("dump", "cbcommands.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "cbcommands");
    }

    private void dumpModsCommands(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> m : ServerAPI.forgecmdper.entrySet()) {
            sb.append(m.getKey()).append(": ").append(m.getValue()).append("\n");
        }
        File file = new File("dump", "modscommands.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "modscommands");
    }

    private void dumpBiomes(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Biome biome : Biome.values()) {
            sb.append(biome.toString()).append("\n");
        }
        File file = new File("dump", "biomes.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "biomes");
    }

    private void dumpPattern(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (PatternType patternType : PatternType.values()) {
            String key = patternType.getIdentifier();
            sb.append(key).append("_").append((Object)PatternType.getByIdentifier(key)).append("\n");
        }
        File file = new File("dump", "pattern.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "pattern");
    }

    private void dumpWorldGen(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : GameRegistry.worldGenMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append("worldgen-").append(value).append("-").append(key).append("\n");
        }
        File file = new File("dump", "worldgen.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "worldgen");
    }

    private void dumpWorldType(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (WorldType type : WorldType.values()) {
            String key = type.getName();
            sb.append((Object)type).append("-").append(key).append("\n");
        }
        File file = new File("dump", "worldtype.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "worldtype");
    }

    private void dumpMaterial(CommandSender sender) {
        StringBuilder sb = new StringBuilder();
        for (Material material : Material.values()) {
            String key = material.name();
            sb.append((Object)material).append("-").append(key).append("\n");
        }
        File file = new File("dump", "material.red");
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, "material");
    }

    private void dumpmsg(CommandSender sender, File file, String type) {
        sender.sendMessage("Successfully dump " + type + ", output path: " + file.getAbsolutePath());
    }

    protected void writeByteArrayToFile(File file, StringBuilder sb) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

