/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.mohistmc.bukkit.nms.ClassLoaderContext;
import com.mohistmc.bukkit.nms.model.ClassMapping;
import com.mohistmc.bukkit.nms.utils.RemapUtils;
import com.mohistmc.configuration.MohistConfigUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public final class PluginClassLoader
extends URLClassLoader {
    final JavaPlugin plugin;
    private final JavaPluginLoader loader;
    private final Map<String, Class<?>> classes = new HashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private LaunchClassLoader launchClassLoader;

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    PluginClassLoader(JavaPluginLoader loader, ClassLoader parent, PluginDescriptionFile description, File dataFolder, File file) throws IOException, InvalidPluginException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.launchClassLoader = parent instanceof LaunchClassLoader ? (LaunchClassLoader)parent : (LaunchClassLoader)MinecraftServer.getServerInst().getClass().getClassLoader();
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex2) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex2);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex3) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex3);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex4) {
            throw new InvalidPluginException("No public constructor", ex4);
        }
        catch (InstantiationException ex5) {
            throw new InvalidPluginException("Abnormal plugin type", ex5);
        }
        if (MohistConfigUtil.bMohist("forge_can_call_bukkit") && parent != null && parent instanceof LaunchClassLoader) {
            try {
                Method methode = parent.getClass().getDeclaredMethod("addChild", ClassLoader.class);
                methode.invoke((Object)parent, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected Object getClassLoadingLock(String className) {
        return this.launchClassLoader;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        Class<?> result;
        ClassLoaderContext.put(this);
        try {
            if (name.replace("/", ".").startsWith("net.minecraft.server.v1_12_R1")) {
                ClassMapping remappedClassMapping = RemapUtils.jarMapping.byNMSName.get(name);
                if (remappedClassMapping == null) {
                    throw new ClassNotFoundException(name.replace('/', '.'));
                }
                String remappedClass = remappedClassMapping.getMcpName();
                Class clazz = this.launchClassLoader.findClass(remappedClass);
                return clazz;
            }
            if (name.startsWith("org.bukkit.")) {
                throw new ClassNotFoundException(name);
            }
            result = this.classes.get(name);
            String string = name.intern();
            synchronized (string) {
                if (result == null) {
                    if (checkGlobal) {
                        result = this.loader.getClassByName(name);
                    }
                    if (result == null) {
                        result = this.remappedFindClass(name);
                        if (result == null) {
                            result = super.findClass(name);
                        }
                        if (result != null) {
                            this.loader.setClass(name, result);
                        }
                    }
                    this.classes.put(name, result);
                }
            }
        }
        finally {
            ClassLoaderContext.pop();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    Set<String> getClasses() {
        return this.classes.keySet();
    }

    synchronized void initialize(JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null");
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        try {
            String path = name.replace('.', '/').concat(".class");
            JarEntry entry = this.jar.getJarEntry(path);
            if (entry != null) {
                InputStream stream = this.jar.getInputStream(entry);
                if (stream != null) {
                    CodeSigner[] signers;
                    CodeSource source;
                    byte[] classBytes = RemapUtils.jarRemapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                    result = this.defineClass(name, classBytes = RemapUtils.remapFindClass(classBytes), 0, classBytes.length, source = new CodeSource(this.url, signers = entry.getCodeSigners()));
                    if (result != null) {
                        this.resolveClass(result);
                    }
                }
            } else {
                InputStream stream;
                URL url = this.findResource(path);
                if (url != null && (stream = url.openStream()) != null) {
                    JarURLConnection jarURLConnection;
                    URL jarURL;
                    CodeSource codeSource;
                    byte[] bytecode = RemapUtils.jarRemapper.remapClassFile(stream, (ClassRepo)RuntimeRepo.getInstance());
                    result = this.defineClass(name, bytecode = RemapUtils.remapFindClass(bytecode), 0, bytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]));
                    if (result != null) {
                        this.resolveClass(result);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new ClassNotFoundException("Failed to remap class " + name, t);
        }
        return result;
    }

    public PluginDescriptionFile getDescription() {
        return this.description;
    }

    static {
        PluginClassLoader.registerAsParallelCapable();
    }
}

