/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.mohistmc.forge.LibrarianLibFix;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class ASMTransformerWrapper {
    private static final Map<String, String> wrapperModMap = Maps.newHashMap();
    private static final Map<String, String> wrapperParentMap = Maps.newHashMap();
    private static final LoadingCache<String, byte[]> wrapperCache = CacheBuilder.newBuilder().maximumSize(30L).weakValues().build((CacheLoader)new CacheLoader<String, byte[]>(){

        public byte[] load(String file) throws Exception {
            return ASMTransformerWrapper.makeWrapper(file);
        }
    });
    private static final URL asmGenRoot;
    private static boolean injected;

    public static String getTransformerWrapper(LaunchClassLoader launchLoader, String parentClass, String coreMod) {
        if (!injected) {
            injected = true;
            launchLoader.addURL(asmGenRoot);
        }
        String name = ASMTransformerWrapper.getWrapperName(parentClass);
        String fileName = name.replace('.', '/') + ".class";
        wrapperModMap.put(fileName, coreMod);
        wrapperParentMap.put(fileName, parentClass);
        return name;
    }

    private static byte[] makeWrapper(String fileName) {
        if (!(wrapperModMap.containsKey(fileName) && wrapperParentMap.containsKey(fileName) && fileName.endsWith(".class"))) {
            throw new IllegalArgumentException("makeWrapper called with strange argument: " + fileName);
        }
        String name = fileName.substring(0, fileName.length() - ".class".length());
        try {
            Type wrapper = Type.getType(TransformerWrapper.class);
            ClassWriter writer = new ClassWriter(2);
            writer.visit(50, 1, name, null, wrapper.getInternalName(), null);
            Method m = Method.getMethod((String)"void <init> ()");
            GeneratorAdapter mg2 = new GeneratorAdapter(1, m, null, null, (ClassVisitor)writer);
            mg2.loadThis();
            mg2.invokeConstructor(wrapper, m);
            mg2.returnValue();
            mg2.endMethod();
            m = Method.getMethod((String)"java.lang.String getParentClass ()");
            mg2 = new GeneratorAdapter(4, m, null, null, (ClassVisitor)writer);
            mg2.push(wrapperParentMap.get(fileName));
            mg2.returnValue();
            mg2.endMethod();
            m = Method.getMethod((String)"java.lang.String getCoreMod ()");
            mg2 = new GeneratorAdapter(4, m, null, null, (ClassVisitor)writer);
            mg2.push(wrapperModMap.get(fileName));
            mg2.returnValue();
            mg2.endMethod();
            writer.visitEnd();
            return writer.toByteArray();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String getWrapperName(String parentClass) {
        return "$wrapper." + parentClass;
    }

    static {
        injected = false;
        try {
            asmGenRoot = new URL("asmgen", null, -1, "/", new ASMGenHandler());
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException(e2);
        }
    }

    static class TransformerException
    extends RuntimeException {
        private static final long serialVersionUID = -6616232415696157218L;

        public TransformerException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static abstract class TransformerWrapper
    implements IClassTransformer {
        private final IClassTransformer parent;

        public TransformerWrapper() {
            try {
                IClassTransformer originTransformer = (IClassTransformer)this.getClass().getClassLoader().loadClass(this.getParentClass()).newInstance();
                this.parent = originTransformer.getClass().getName().equals("com.teamwizardry.librarianlib.asm.LibLibTransformer") ? (IClassTransformer)LibrarianLibFix.class.getConstructor(IClassTransformer.class).newInstance(originTransformer) : (IClassTransformer)this.getClass().getClassLoader().loadClass(this.getParentClass()).newInstance();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public byte[] transform(String name, String transformedName, byte[] basicClass) {
            try {
                return this.parent.transform(name, transformedName, basicClass);
            }
            catch (Throwable e2) {
                throw new TransformerException("Exception in class transformer " + this.parent + " from coremod " + this.getCoreMod(), e2);
            }
        }

        public String toString() {
            return "TransformerWrapper(" + this.getParentClass() + ", " + this.getCoreMod() + ")";
        }

        protected abstract String getParentClass();

        protected abstract String getCoreMod();
    }

    private static class WrapperVisitor
    extends ClassVisitor {
        private final String name;
        private final String parentClass;

        public WrapperVisitor(ClassVisitor cv, String name, String parentClass) {
            super(327680, cv);
            this.name = name.replace('.', '/');
            this.parentClass = parentClass;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, this.name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.equals("parentClass")) {
                return super.visitField(access, name, desc, signature, (Object)this.parentClass);
            }
            return super.visitField(access, name, desc, signature, value);
        }
    }

    private static class ASMGenConnection
    extends URLConnection {
        private final String file;

        protected ASMGenConnection(URL url, String file) {
            super(url);
            this.file = file;
        }

        @Override
        public void connect() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream((byte[])wrapperCache.getUnchecked((Object)this.file));
        }

        @Override
        @Nullable
        public Permission getPermission() {
            return null;
        }
    }

    private static class ASMGenHandler
    extends URLStreamHandler {
        private ASMGenHandler() {
        }

        @Override
        @Nullable
        protected URLConnection openConnection(URL url) throws IOException {
            String file = url.getFile();
            if (file.equals("/")) {
                return new URLConnection(url){

                    @Override
                    public void connect() throws IOException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            if (!file.startsWith("/")) {
                throw new RuntimeException("Malformed URL: " + url);
            }
            file = file.substring(1);
            if (wrapperModMap.containsKey(file)) {
                return new ASMGenConnection(url, file);
            }
            return null;
        }
    }
}

