/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import red.mohist.util.i18n.Message;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private boolean noForge;
    private List<String> brandings;
    private List<String> brandingsNoMC;
    private List<ICrashCallable> crashCallables = Lists.newArrayList((Object[])new ICrashCallable[]{Loader.instance().getCallableCrashInformation()});
    private Set<bfb> handlerSet = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private WeakReference<bfb> handlerToCheck;
    private EventBus eventBus = MinecraftForge.EVENT_BUS;
    private volatile CountDownLatch exitLatch = null;

    private FMLCommonHandler() {
        this.registerCrashCallable(new ICrashCallable(){

            public String call() throws Exception {
                StringBuilder builder = new StringBuilder();
                Joiner joiner = Joiner.on((String)"\n  ");
                for (String coreMod : CoreModManager.getTransformers().keySet()) {
                    builder.append("\n" + coreMod + "\n  ").append(joiner.join((Iterable)CoreModManager.getTransformers().get(coreMod)));
                }
                return builder.toString();
            }

            @Override
            public String getLabel() {
                return "Loaded coremods (and transformers)";
            }
        });
    }

    @Deprecated
    public EventBus bus() {
        return this.eventBus;
    }

    public List<String> beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        MinecraftForge.initialize();
        return ImmutableList.of();
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        if (mod instanceof String) {
            return Loader.instance().getIndexedModList().get(mod);
        }
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    @Deprecated
    public Logger getFMLLogger() {
        return FMLLog.log;
    }

    public Side getSide() {
        return Side.SERVER;
    }

    public Side getEffectiveSide() {
        return Side.SERVER;
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLLog.log.error("Something raised an exception. The message was '{}'. 'stopGame' is {}", (Object)message, (Object)stopGame, (Object)exception);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)Loader.instance().getMCVersionString());
            brd.add((Object)Loader.instance().getMCPVersionString());
            brd.add((Object)("Powered by Forge " + ForgeVersion.getVersion()));
            if (this.sidedDelegate != null) {
                brd.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                brd.add((Object)Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int tModCount = Loader.instance().getModList().size();
            int aModCount = Loader.instance().getActiveModList().size();
            brd.add((Object)String.format("%d mod%s loaded, %d mod%s active", tModCount, tModCount != 1 ? "s" : "", aModCount, aModCount != 1 ? "s" : ""));
            this.brandings = brd.build();
            this.brandingsNoMC = this.brandings.subList(1, this.brandings.size());
        }
    }

    public List<String> getBrandings(boolean includeMC) {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return includeMC ? ImmutableList.copyOf(this.brandings) : ImmutableList.copyOf(this.brandingsNoMC);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.END));
    }

    public void onPostWorldTick(amu world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, world));
    }

    public void onPreServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.START));
    }

    public void onPreWorldTick(amu world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.START, world));
    }

    public boolean handleServerAboutToStart(MinecraftServer server) {
        return Loader.instance().serverAboutToStart(server);
    }

    public boolean handleServerStarting(MinecraftServer server) {
        return Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
        this.sidedDelegate.allowLogins();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public File getSavesDirectory() {
        return this.sidedDelegate.getSavesDirectory();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public void queryUser(StartupQuery query) throws InterruptedException {
        this.sidedDelegate.queryUser(query);
    }

    public void onServerStart(MinecraftServer dedicatedServer) {
        FMLServerHandler.instance();
        this.sidedDelegate.beginServerLoading(dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.START));
    }

    public void onPostClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.END));
    }

    public void onRenderTickStart(float timer) {
        Animation.setClientPartialTickTime(timer);
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.START, timer));
    }

    public void onRenderTickEnd(float timer) {
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.END, timer));
    }

    public void onPlayerPreTick(aed player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.START, player));
    }

    public void onPlayerPostTick(aed player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.END, player));
    }

    public void registerCrashCallable(ICrashCallable callable) {
        this.crashCallables.add(callable);
    }

    public void enhanceCrashReport(b crashReport, c category) {
        for (ICrashCallable call : this.crashCallables) {
            category.a(call.getLabel(), (d)call);
        }
    }

    public void handleWorldDataSave(bfb handler, bfd worldInfo, fy tagCompound) {
        if (worldInfo.getDimension() != 0) {
            return;
        }
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            fy dataForWriting = wac.getDataForWriting(handler, worldInfo);
            tagCompound.a(mc.getModId(), (gn)dataForWriting);
        }
    }

    public void handleWorldDataLoad(bfb handler, bfd worldInfo, fy tagCompound) {
        if (this.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (this.handlerSet.contains(handler) || DimensionManager.getWorld(0) != null) {
            return;
        }
        this.handlerSet.add(handler);
        this.handlerToCheck = new WeakReference<bfb>(handler);
        HashMap additionalProperties = Maps.newHashMap();
        worldInfo.setAdditionalProperties((Map)additionalProperties);
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            wac.readData(handler, worldInfo, additionalProperties, tagCompound.p(mc.getModId()));
        }
    }

    public void confirmBackupLevelDatUse(bfb handler) {
        if (this.handlerToCheck == null || this.handlerToCheck.get() != handler) {
            this.handlerToCheck = null;
            return;
        }
        String text = "Forge Mod Loader detected that the backup level.dat is being used.\n\nThis may happen due to a bug or corruption, continuing can damage\nyour world beyond repair or lose data / progress.\n\nIt's recommended to create a world backup before continuing.";
        boolean confirmed = StartupQuery.confirm(text);
        if (!confirmed) {
            StartupQuery.abort();
        }
    }

    public boolean isDisplayCloseRequested() {
        return this.sidedDelegate != null && this.sidedDelegate.isDisplayCloseRequested();
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public void expectServerStopped() {
        this.exitLatch = new CountDownLatch(1);
    }

    public void handleExit(int retVal) {
        CountDownLatch latch = this.exitLatch;
        if (latch != null) {
            try {
                FMLLog.log.info("Waiting for the server to terminate/save.");
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    FMLLog.log.warn("The server didn't stop within 10 seconds, exiting anyway.");
                } else {
                    FMLLog.log.info("Server terminated.");
                }
            }
            catch (InterruptedException e) {
                FMLLog.log.warn("Interrupted wait, exiting.");
            }
        }
        System.exit(retVal);
    }

    public void handleServerStopped() {
        CountDownLatch latch;
        this.sidedDelegate.serverStopped();
        MinecraftServer server = this.getMinecraftServerInstance();
        Loader.instance().serverStopped();
        if (server != null) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(false), "field_71316_v");
        }
        if ((latch = this.exitLatch) != null) {
            latch.countDown();
            this.exitLatch = null;
        }
    }

    public String getModName() {
        ArrayList modNames = Lists.newArrayListWithExpectedSize((int)3);
        modNames.add("Mohist");
        return Joiner.on((char)',').join((Iterable)modNames);
    }

    public void addModToResourcePack(ModContainer container) {
        this.sidedDelegate.addModAsResource(container);
    }

    public String getCurrentLanguage() {
        return this.sidedDelegate.getCurrentLanguage();
    }

    public void bootstrap() {
    }

    public gw getClientToServerNetworkManager() {
        return this.sidedDelegate.getClientToServerNetworkManager();
    }

    public void fireMouseInput() {
        this.bus().post(new InputEvent.MouseInputEvent());
    }

    public void fireKeyInput() {
        this.bus().post(new InputEvent.KeyInputEvent());
    }

    public void firePlayerChangedDimensionEvent(aed player, int fromDim, int toDim) {
        this.bus().post(new PlayerEvent.PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public void firePlayerLoggedIn(aed player) {
        this.bus().post(new PlayerEvent.PlayerLoggedInEvent(player));
    }

    public void firePlayerLoggedOut(aed player) {
        this.bus().post(new PlayerEvent.PlayerLoggedOutEvent(player));
    }

    public void firePlayerRespawnEvent(aed player, boolean endConquered) {
        this.bus().post(new PlayerEvent.PlayerRespawnEvent(player, endConquered));
    }

    public void firePlayerItemPickupEvent(aed player, acl item, aip clone) {
        this.bus().post(new PlayerEvent.ItemPickupEvent(player, item, clone));
    }

    public void firePlayerCraftingEvent(aed player, aip crafted, tv craftMatrix) {
        this.bus().post(new PlayerEvent.ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public void firePlayerSmeltedEvent(aed player, aip smelted) {
        this.bus().post(new PlayerEvent.ItemSmeltedEvent(player, smelted));
    }

    public hb getClientPlayHandler() {
        return this.sidedDelegate.getClientPlayHandler();
    }

    public void fireNetRegistrationEvent(gw manager, Set<String> channelSet, String channel, Side side) {
        this.sidedDelegate.fireNetRegistrationEvent(this.bus(), manager, channelSet, channel, side);
    }

    public boolean shouldAllowPlayerLogins() {
        return this.sidedDelegate.shouldAllowPlayerLogins();
    }

    public void fireServerConnectionEvent(gw manager) {
        this.bus().post(new FMLNetworkEvent.ServerConnectionFromClientEvent(manager));
    }

    public boolean handleServerHandshake(md packet, gw manager) {
        if (!this.shouldAllowPlayerLogins()) {
            ho text = new ho(Message.getString("forge.fmlcommonhandler.hsh.1"));
            FMLLog.log.info(Message.getFormatString("forge.fmlcommonhandler.hsh.2", new Object[]{text.c()}));
            manager.a((ht)new mk((hh)text));
            manager.a((hh)text);
            return false;
        }
        if (packet.a() == gx.d && !NetworkRegistry.INSTANCE.isVanillaAccepted(Side.CLIENT) && !packet.hasFMLMarker()) {
            manager.a(gx.d);
            ho text = new ho(Message.getString("forge.fmlcommonhandler.hsh.3"));
            Collection<String> modNames = NetworkRegistry.INSTANCE.getRequiredMods(Side.CLIENT);
            FMLLog.log.info(Message.getFormatString("forge.fmlcommonhandler.hsh.4", new Object[]{modNames}));
            manager.a((ht)new mk((hh)text));
            manager.a((hh)text);
            return false;
        }
        manager.channel().attr(NetworkRegistry.FML_MARKER).set((Object)packet.hasFMLMarker());
        return true;
    }

    public void processWindowMessages() {
        if (this.sidedDelegate == null) {
            return;
        }
        this.sidedDelegate.processWindowMessages();
    }

    public void exitJava(int exitCode, boolean hardExit) {
        FMLLog.log.info("Java has been asked to exit (code {})", (Object)exitCode);
        if (hardExit) {
            FMLLog.log.info("This is an abortive exit and could cause world corruption or other things");
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        FMLLog.log.info("Exit trace:");
        for (int i2 = 2; i2 < stack.length; ++i2) {
            FMLLog.log.info("\t{}", (Object)stack[i2]);
        }
        if (hardExit) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    public tr getWorldThread(hb net) {
        return this.sidedDelegate.getWorldThread(net);
    }

    public static void callFuture(FutureTask<?> task) {
        try {
            task.run();
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            FMLLog.log.fatal("Exception caught executing FutureTask: {}", (Object)e.toString(), (Object)e);
        }
    }

    @Nullable
    public InputStream loadLanguage(Map<String, String> table, InputStream inputstream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)inputstream);
        boolean isEnhanced = false;
        for (String line : IOUtils.readLines((InputStream)new ByteArrayInputStream(data), (Charset)StandardCharsets.UTF_8)) {
            if (line.isEmpty() || line.charAt(0) != '#' || !(line = line.substring(1).trim()).equals("PARSE_ESCAPES")) continue;
            isEnhanced = true;
            break;
        }
        if (!isEnhanced) {
            return new ByteArrayInputStream(data);
        }
        Properties props = new Properties();
        props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            table.put((String)e.getKey(), (String)e.getValue());
        }
        props.clear();
        return null;
    }

    public String stripSpecialChars(String message) {
        return this.sidedDelegate != null ? this.sidedDelegate.stripSpecialChars(message) : message;
    }

    public void reloadRenderers() {
        this.sidedDelegate.reloadRenderers();
    }

    public void fireSidedRegistryEvents() {
        this.sidedDelegate.fireSidedRegistryEvents();
    }

    public CompoundDataFixer getDataFixer() {
        return this.sidedDelegate.getDataFixer();
    }

    public boolean isDisplayVSyncForced() {
        return this.sidedDelegate.isDisplayVSyncForced();
    }

    public void resetClientRecipeBook() {
        this.sidedDelegate.resetClientRecipeBook();
    }

    public void reloadSearchTrees() {
        this.sidedDelegate.reloadSearchTrees();
    }

    public void reloadCreativeSettings() {
        this.sidedDelegate.reloadCreativeSettings();
    }
}

