/*
 * Decompiled with CFR 0.152.
 */
package red.mohist;

import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.spigotmc.TicksPerSecondCommand;
import red.mohist.Mohist;
import red.mohist.common.async.MohistThreadBox;
import red.mohist.configuration.MohistConfig;
import red.mohist.util.i18n.Message;

public class WatchMohist
implements Runnable {
    private static long Time = 0L;
    private static long WarnTime = 0L;

    @Override
    public void run() {
        long curTime = System.currentTimeMillis();
        if (Time > 0L && curTime - Time > 2000L && curTime - WarnTime > 30000L) {
            WarnTime = curTime;
            Mohist.LOGGER.warn(Message.getString("watchmohist.1"));
            double[] tps = Bukkit.getTPS();
            Object[] tpsAvg = new String[tps.length];
            for (int i2 = 0; i2 < tps.length; ++i2) {
                tpsAvg[i2] = TicksPerSecondCommand.format(tps[i2]);
            }
            Mohist.LOGGER.warn(Message.getFormatString("watchmohist.2", new Object[]{String.valueOf(curTime - Time), StringUtils.join((Object[])tpsAvg, (String)", ")}));
            Mohist.LOGGER.warn(Message.getString("watchmohist.3"));
            for (StackTraceElement stack : MinecraftServer.getServerInst().primaryThread.getStackTrace()) {
                Mohist.LOGGER.warn(Message.getString("watchmohist.4") + stack);
            }
            Mohist.LOGGER.warn(Message.getString("watchmohist.1"));
        }
    }

    public static void start() {
        if (WatchMohist.isEnable()) {
            MohistThreadBox.WatchMohist.scheduleAtFixedRate(new WatchMohist(), 30000L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public static void update() {
        Time = System.currentTimeMillis();
    }

    public static void stop() {
        if (WatchMohist.isEnable()) {
            MohistThreadBox.WatchMohist.shutdown();
        }
    }

    public static boolean isEnable() {
        return MohistConfig.instance.getBoolean("mohist.watchdog_mohist");
    }
}

