/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import red.mohist.common.cache.TileEntityCache;

public class TileEntity {
    public static Map<Class<? extends avj>, TileEntityCache> tileEntityCache = new HashMap<Class<? extends avj>, TileEntityCache>();

    public static String sanitizeClassName(Class clazz) {
        String name = clazz.getName().replace(".", "-");
        return name.replaceAll("[^A-Za-z0-9\\-]", "");
    }

    public static String sanitizeClassName(avj tileEntity) {
        return TileEntity.sanitizeClassName(tileEntity.getClass());
    }

    public static boolean canTileEntityTick(avj tileEntity, amu world) {
        if (tileEntity == null) {
            return false;
        }
        if (world.tileentityConfig == null) {
            return true;
        }
        if (MinecraftServer.tileEntityConfig.skipTileEntityTicks.getValue().booleanValue()) {
            TileEntityCache teCache = tileEntityCache.get(tileEntity.getClass());
            if (teCache == null) {
                String teConfigPath = TileEntity.sanitizeClassName(tileEntity);
                teCache = new TileEntityCache(tileEntity.getClass(), world.V().j().toLowerCase(), teConfigPath, world.tileentityConfig.getBoolean(teConfigPath + ".tick-no-players", false), world.tileentityConfig.getInt(teConfigPath + ".tick-interval", 1));
                tileEntityCache.put(tileEntity.getClass(), teCache);
            }
            return teCache.tickInterval > 0 && world.V().e() % (long)teCache.tickInterval == 0L;
        }
        return true;
    }
}

