/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IRegistryDelegate;

public abstract class FluidRegistry {
    static int maxID = 0;
    static BiMap<String, Fluid> fluids = HashBiMap.create();
    static BiMap<Fluid, Integer> fluidIDs = HashBiMap.create();
    static BiMap<Integer, String> fluidNames = HashBiMap.create();
    static BiMap<aow, Fluid> fluidBlocks;
    static BiMap<String, Fluid> masterFluidReference;
    static BiMap<String, String> defaultFluidName;
    static Map<Fluid, FluidDelegate> delegates;
    static boolean universalBucketEnabled;
    static Set<String> bucketFluids;
    static Set<Fluid> currentBucketFluids;
    public static final Fluid WATER;
    public static final Fluid LAVA;

    private FluidRegistry() {
    }

    public static void initFluidIDs(BiMap<Fluid, Integer> newfluidIDs, Set<String> defaultNames) {
        maxID = newfluidIDs.size();
        FluidRegistry.loadFluidDefaults(newfluidIDs, defaultNames);
    }

    private static void loadFluidDefaults(BiMap<Fluid, Integer> localFluidIDs, Set<String> defaultNames) {
        if (defaultNames.isEmpty()) {
            defaultNames.addAll(defaultFluidName.values());
        }
        HashBiMap localFluids = HashBiMap.create(fluids);
        for (String defaultName : defaultNames) {
            Fluid fluid = (Fluid)masterFluidReference.get((Object)defaultName);
            if (fluid == null) {
                String derivedName = defaultName.split(":", 2)[1];
                String localDefault = (String)defaultFluidName.get((Object)derivedName);
                if (localDefault == null) {
                    FMLLog.log.error("The fluid {} (specified as {}) is missing from this instance - it will be removed", (Object)derivedName, (Object)defaultName);
                    continue;
                }
                fluid = (Fluid)masterFluidReference.get((Object)localDefault);
                FMLLog.log.error("The fluid {} specified as default is not present - it will be reverted to default {}", (Object)defaultName, (Object)localDefault);
            }
            FMLLog.log.debug("The fluid {} has been selected as the default fluid for {}", (Object)defaultName, (Object)fluid.getName());
            Fluid oldFluid = (Fluid)localFluids.put((Object)fluid.getName(), (Object)fluid);
            Integer id = (Integer)localFluidIDs.remove((Object)oldFluid);
            localFluidIDs.put((Object)fluid, (Object)id);
        }
        HashBiMap localFluidNames = HashBiMap.create();
        for (Map.Entry e2 : localFluidIDs.entrySet()) {
            localFluidNames.put(e2.getValue(), (Object)((Fluid)e2.getKey()).getName());
        }
        fluidIDs = localFluidIDs;
        fluids = localFluids;
        fluidNames = localFluidNames;
        fluidBlocks = null;
        currentBucketFluids = null;
        for (FluidDelegate fd2 : delegates.values()) {
            fd2.rebind();
        }
    }

    public static boolean registerFluid(Fluid fluid) {
        masterFluidReference.put((Object)FluidRegistry.uniqueName(fluid), (Object)fluid);
        delegates.put(fluid, new FluidDelegate(fluid, fluid.getName()));
        if (fluids.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put((Object)fluid.getName(), (Object)fluid);
        fluidIDs.put((Object)fluid, (Object)(++maxID));
        fluidNames.put((Object)maxID, (Object)fluid.getName());
        defaultFluidName.put((Object)fluid.getName(), (Object)FluidRegistry.uniqueName(fluid));
        MinecraftForge.EVENT_BUS.post(new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    private static String uniqueName(Fluid fluid) {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        String activeModContainerName = activeModContainer == null ? "minecraft" : activeModContainer.getModId();
        return activeModContainerName + ":" + fluid.getName();
    }

    public static boolean isFluidDefault(Fluid fluid) {
        return fluids.containsValue((Object)fluid);
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluid != null && fluids.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluids.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return (Fluid)fluids.get((Object)fluidName);
    }

    public static String getFluidName(Fluid fluid) {
        return (String)fluids.inverse().get((Object)fluid);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.getFluid());
    }

    @Nullable
    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluids.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluid(fluidName), amount);
    }

    public static Map<String, Fluid> getRegisteredFluids() {
        return Maps.unmodifiableBiMap(fluids);
    }

    @Deprecated
    public static Map<Fluid, Integer> getRegisteredFluidIDs() {
        return Maps.unmodifiableBiMap(fluidIDs);
    }

    public static void enableUniversalBucket() {
        if (Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            ModContainer modContainer = Loader.instance().activeModContainer();
            String modContainerName = modContainer == null ? null : modContainer.getName();
            FMLLog.log.error("Trying to activate the universal filled bucket too late. Call it statically in your Mods class. Mod: {}", (Object)modContainerName);
        } else {
            universalBucketEnabled = true;
        }
    }

    public static boolean isUniversalBucketEnabled() {
        return universalBucketEnabled;
    }

    public static boolean addBucketForFluid(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return bucketFluids.add(fluid.getName());
    }

    public static Set<Fluid> getBucketFluids() {
        if (currentBucketFluids == null) {
            HashSet tmp = Sets.newHashSet();
            for (String fluidName : bucketFluids) {
                tmp.add(FluidRegistry.getFluid(fluidName));
            }
            currentBucketFluids = Collections.unmodifiableSet(tmp);
        }
        return currentBucketFluids;
    }

    public static boolean hasBucket(Fluid fluid) {
        return bucketFluids.contains(fluid.getName());
    }

    public static Fluid lookupFluidForBlock(aow block) {
        if (fluidBlocks == null) {
            HashBiMap tmp = HashBiMap.create();
            for (Fluid fluid : fluids.values()) {
                if (!fluid.canBePlacedInWorld() || fluid.getBlock() == null) continue;
                tmp.put((Object)fluid.getBlock(), (Object)fluid);
            }
            fluidBlocks = tmp;
        }
        if (block == aox.i) {
            block = aox.j;
        } else if (block == aox.k) {
            block = aox.l;
        }
        return (Fluid)fluidBlocks.get((Object)block);
    }

    public static int getMaxID() {
        return maxID;
    }

    public static String getDefaultFluidName(Fluid key) {
        String name = (String)masterFluidReference.inverse().get((Object)key);
        if (Strings.isNullOrEmpty((String)name)) {
            FMLLog.log.error("The fluid registry is corrupted. A fluid {} {} is not properly registered. The mod that registered this is broken", (Object)key.getClass().getName(), (Object)key.getName());
            throw new IllegalStateException("The fluid registry is corrupted");
        }
        return name;
    }

    @Nullable
    public static String getModId(@Nullable FluidStack fluidStack) {
        String defaultFluidName;
        if (fluidStack != null && (defaultFluidName = FluidRegistry.getDefaultFluidName(fluidStack.getFluid())) != null) {
            nf fluidResourceName = new nf(defaultFluidName);
            return fluidResourceName.b();
        }
        return null;
    }

    public static void loadFluidDefaults(fy tag) {
        HashSet defaults = Sets.newHashSet();
        if (tag.b("DefaultFluidList", 9)) {
            FMLLog.log.debug("Loading persistent fluid defaults from world");
            ge tl = tag.c("DefaultFluidList", 8);
            for (int i2 = 0; i2 < tl.c(); ++i2) {
                defaults.add(tl.h(i2));
            }
        } else {
            FMLLog.log.debug("World is missing persistent fluid defaults - using local defaults");
        }
        FluidRegistry.loadFluidDefaults((BiMap<Fluid, Integer>)HashBiMap.create(fluidIDs), defaults);
    }

    public static void writeDefaultFluidList(fy forgeData) {
        ge tagList = new ge();
        for (Map.Entry def : fluids.entrySet()) {
            tagList.a((gn)new gm(FluidRegistry.getDefaultFluidName((Fluid)def.getValue())));
        }
        forgeData.a("DefaultFluidList", (gn)tagList);
    }

    public static void validateFluidRegistry() {
        HashSet illegalFluids = Sets.newHashSet();
        for (Fluid f2 : fluids.values()) {
            if (masterFluidReference.containsValue((Object)f2)) continue;
            illegalFluids.add(f2);
        }
        if (!illegalFluids.isEmpty()) {
            FMLLog.log.fatal("The fluid registry is corrupted. Something has inserted a fluid without registering it");
            FMLLog.log.fatal("There is {} unregistered fluids", (Object)illegalFluids.size());
            for (Fluid f2 : illegalFluids) {
                FMLLog.log.fatal("  Fluid name : {}, type: {}", (Object)f2.getName(), (Object)f2.getClass().getName());
            }
            FMLLog.log.fatal("The mods that own these fluids need to register them properly");
            throw new IllegalStateException("The fluid map contains fluids unknown to the master fluid registry");
        }
    }

    static IRegistryDelegate<Fluid> makeDelegate(Fluid fl) {
        return delegates.get(fl);
    }

    static {
        masterFluidReference = HashBiMap.create();
        defaultFluidName = HashBiMap.create();
        delegates = Maps.newHashMap();
        universalBucketEnabled = false;
        bucketFluids = Sets.newHashSet();
        WATER = new Fluid("water", new nf("blocks/water_still"), new nf("blocks/water_flow"), new nf("blocks/water_overlay")){

            @Override
            public String getLocalizedName(FluidStack fs) {
                return ft.a((String)"tile.water.name");
            }
        }.setBlock((aow)aox.j).setUnlocalizedName(aox.j.a());
        LAVA = new Fluid("lava", new nf("blocks/lava_still"), new nf("blocks/lava_flow")){

            @Override
            public String getLocalizedName(FluidStack fs) {
                return ft.a((String)"tile.lava.name");
            }
        }.setBlock((aow)aox.l).setLuminosity(15).setDensity(3000).setViscosity(6000).setTemperature(1300).setUnlocalizedName(aox.l.a());
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    private static class FluidDelegate
    implements IRegistryDelegate<Fluid> {
        private String name;
        private Fluid fluid;

        FluidDelegate(Fluid fluid, String name) {
            this.fluid = fluid;
            this.name = name;
        }

        @Override
        public Fluid get() {
            return this.fluid;
        }

        @Override
        public nf name() {
            return new nf(this.name);
        }

        @Override
        public Class<Fluid> type() {
            return Fluid.class;
        }

        void rebind() {
            this.fluid = (Fluid)fluids.get((Object)this.name);
        }
    }

    public static class FluidRegisterEvent
    extends Event {
        private final String fluidName;
        private final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public int getFluidID() {
            return this.fluidID;
        }
    }
}

