/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLEvent;

public class FMLInterModComms {
    private static final ImmutableList<IMCMessage> emptyIMCList = ImmutableList.of();
    private static ArrayListMultimap<String, IMCMessage> modMessages = ArrayListMultimap.create();

    public static boolean sendMessage(String modId, String key, fy value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, value));
    }

    public static boolean sendMessage(String modId, String key, aip value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, value));
    }

    public static boolean sendMessage(String modId, String key, nf value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, value));
    }

    public static boolean sendMessage(String modId, String key, String value) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, (Object)value));
    }

    public static boolean sendFunctionMessage(String modId, String key, String functionClassName) {
        return FMLInterModComms.enqueueStartupMessage(modId, new IMCMessage(key, functionClassName, true));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, fy value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, value));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, aip value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, value));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, String value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, (Object)value));
    }

    public static void sendRuntimeMessage(Object sourceMod, String modId, String key, nf value) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, value));
    }

    public static void sendRuntimeFunctionMessage(Object sourceMod, String modId, String key, String functionClassName) {
        FMLInterModComms.enqueueMessage(sourceMod, modId, new IMCMessage(key, functionClassName, true));
    }

    private static boolean enqueueStartupMessage(String modTarget, IMCMessage message) {
        if (Loader.instance().activeModContainer() == null) {
            return false;
        }
        FMLInterModComms.enqueueMessage(Loader.instance().activeModContainer(), modTarget, message);
        return Loader.isModLoaded(modTarget) && !Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION);
    }

    private static void enqueueMessage(Object sourceMod, String modTarget, IMCMessage message) {
        ModContainer mc = sourceMod instanceof ModContainer ? (ModContainer)sourceMod : FMLCommonHandler.instance().findContainerFor(sourceMod);
        if (mc != null && Loader.isModLoaded(modTarget)) {
            message.setSender(mc);
            modMessages.put((Object)modTarget, (Object)message);
        }
    }

    public static ImmutableList<IMCMessage> fetchRuntimeMessages(Object forMod) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(forMod);
        if (mc != null) {
            return ImmutableList.copyOf((Collection)modMessages.removeAll((Object)mc.getModId()));
        }
        return emptyIMCList;
    }

    public static final class IMCMessage {
        private final boolean isFunction;
        private String sender;
        @Nonnull
        public final String key;
        @Nonnull
        private final Object value;

        private IMCMessage(@Nonnull String key, @Nonnull Object value) {
            this.key = key;
            this.value = value;
            this.isFunction = false;
        }

        private IMCMessage(@Nonnull String key, @Nonnull String value, boolean isFunction) {
            this.key = key;
            this.value = value;
            this.isFunction = isFunction;
        }

        public String toString() {
            return this.sender;
        }

        public String getSender() {
            return this.sender;
        }

        void setSender(ModContainer activeModContainer) {
            this.sender = activeModContainer.getModId();
        }

        public String getStringValue() {
            return (String)this.value;
        }

        public nf getResourceLocationValue() {
            return (nf)this.value;
        }

        public fy getNBTValue() {
            return (fy)this.value;
        }

        @Nonnull
        public aip getItemStackValue() {
            return (aip)this.value;
        }

        public <T, V> Optional<Function<T, V>> getFunctionValue(Class<T> functionFrom, Class<V> functionTo) {
            if (!this.isFunction) {
                return Optional.empty();
            }
            try {
                Function f2 = Class.forName((String)this.value).asSubclass(Function.class).newInstance();
                return Optional.of(f2);
            }
            catch (Exception e) {
                FMLLog.log.info("An error occurred instantiating the IMC function. key: {} value: {}, caller: {}", (Object)this.key, this.value, (Object)this.sender);
                return Optional.empty();
            }
        }

        public Class<?> getMessageType() {
            return this.value.getClass();
        }

        public boolean isStringMessage() {
            return String.class.isAssignableFrom(this.getMessageType());
        }

        public boolean isItemStackMessage() {
            return aip.class.isAssignableFrom(this.getMessageType());
        }

        public boolean isNBTMessage() {
            return fy.class.isAssignableFrom(this.getMessageType());
        }

        public boolean isResourceLocationMessage() {
            return nf.class.isAssignableFrom(this.getMessageType());
        }

        public boolean isFunctionMessage() {
            return Function.class.isAssignableFrom(this.getMessageType());
        }
    }

    public static class IMCEvent
    extends FMLEvent {
        private ModContainer activeContainer;
        private ImmutableList<IMCMessage> currentList;

        @Override
        public void applyModContainer(ModContainer activeContainer) {
            this.activeContainer = activeContainer;
            this.currentList = null;
            FMLLog.log.trace("Attempting to deliver {} IMC messages to mod {}", (Object)modMessages.get((Object)activeContainer.getModId()).size(), (Object)activeContainer.getModId());
        }

        public ImmutableList<IMCMessage> getMessages() {
            if (this.currentList == null) {
                this.currentList = ImmutableList.copyOf((Collection)modMessages.removeAll((Object)this.activeContainer.getModId()));
            }
            return this.currentList;
        }
    }
}

