/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.MohistMC;
import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.DownloadSource;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.i18n.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Scanner;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DownloadJava {
    public static File java = new File("CustomJAVA/");
    public static File javabin = new File("CustomJAVA/bin/");
    public static ArrayList<String> launchArgs = new ArrayList();
    private static File javadl = new File(java.getAbsolutePath() + "/java.zip");

    public static void run() throws Exception {
        if (!MohistMC.mainArgs.contains("launchedWithCustomJava8")) {
            if (!javabin.exists() && !MohistConfigUtil.bMohist("use_custom_java8")) {
                System.out.println(Message.getString("unsupported.java.version"));
                Scanner scan = new Scanner(System.in);
                System.out.println(Message.getString("customjava.ask"));
                String input = scan.nextLine();
                if (input.equalsIgnoreCase("Yes")) {
                    DownloadJava.searchJava();
                } else {
                    System.out.println(Message.getString("customjava.no"));
                    System.exit(0);
                }
            } else {
                DownloadJava.searchJava();
            }
        }
    }

    public static void searchJava() throws Exception {
        String url = DownloadSource.get().getUrl();
        if (System.getProperty("sun.arch.data.model").equals("64")) {
            if (DownloadJava.os().equals("Windows")) {
                DownloadJava.prepareLaunch(url + "mohist_1_12_2_jre8/javawin64.zip", "java.exe");
            } else if (DownloadJava.os().equals("Unix")) {
                DownloadJava.prepareLaunch(url + "mohist_1_12_2_jre8/javalinux64.zip", "java");
            } else if (DownloadJava.os().equals("Mac")) {
                DownloadJava.prepareLaunch(url + "mohist_1_12_2_jre8/javamac64.zip", "java");
            }
        } else if (DownloadJava.os().equals("Windows")) {
            DownloadJava.prepareLaunch(url + "mohist_1_12_2_jre8/javawin32.zip", "java.exe");
        } else if (DownloadJava.os().equals("Unix")) {
            DownloadJava.prepareLaunch(url + "mohist_1_12_2_jre8/javalinux32.zip", "java");
        }
    }

    private static void prepareLaunch(String URL2, String javaName) throws Exception {
        if (!javabin.exists()) {
            java.mkdirs();
            java.createNewFile();
            System.out.println(Message.getFormatString("customjava.dl", new Object[]{DownloadJava.os()}));
            UpdateUtils.downloadFile(URL2, javadl);
            DownloadJava.unzip(new FileInputStream(javadl), java.toPath());
            javadl.delete();
            if (DownloadJava.os().equals("Unix") || DownloadJava.os().equals("Mac")) {
                Runtime.getRuntime().exec("chmod 755 -R ./CustomJAVA");
            }
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(java.getAbsolutePath() + "/bin/" + javaName, "-jar"));
        launchArgs.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
        launchArgs.add(JarTool.getJarName());
        launchArgs.addAll(MohistMC.mainArgs);
        launchArgs.add("launchedWithCustomJava8");
        command.addAll(launchArgs);
        command.removeIf(s -> s.toLowerCase().contains("-xms"));
        System.out.println(Message.getFormatString("customjava.run", new Object[]{DownloadJava.os(), command}));
        UpdateUtils.restartServer(command);
    }

    public static void unzip(InputStream is, Path targetDir) throws IOException {
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zipIn.getNextEntry()) != null) {
                Path resolvedPath = targetDir.resolve(ze.getName());
                if (ze.isDirectory()) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                Files.copy(zipIn, resolvedPath, new CopyOption[0]);
            }
        }
    }

    public static String os() {
        String o = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return o.contains("win") ? "Windows" : (o.contains("mac") ? "Mac" : (Stream.of("solaris", "sunos", "linux", "unix").anyMatch(o::contains) ? "Unix" : "Unknown"));
    }
}

