/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.i18n.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;

public class DownloadLibraries {
    static boolean needToRecheck = false;
    static int retry = 0;
    static FileChannel fileChannel;
    static HashMap<String, String> fail;

    public static void run() throws Exception {
        String str;
        System.out.println(Message.getString("libraries.checking.start"));
        String url = "https://www.mgazul.cn/";
        if (Message.isCN()) {
            url = "https://mohist-community.gitee.io/mohistdown/";
        }
        BufferedReader b2 = new BufferedReader(new InputStreamReader(DownloadLibraries.class.getClassLoader().getResourceAsStream("lib.red")));
        while ((str = b2.readLine()) != null) {
            File file;
            block9: {
                String[] args = str.split("\\|");
                if (args.length != 2 || (file = new File(args[0])).exists() && DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("MD5").digest(Files.readAllBytes(file.toPath()))).toLowerCase().equals(args[1]) || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(file.getName())) continue;
                file.getParentFile().mkdirs();
                String u = url + args[0];
                System.out.println("Global percentage \u00bb " + String.valueOf((float)UpdateUtils.getSizeOfDirectory(new File("libraries")) / 35.0f * 100.0f).substring(0, 2).replace(".", "") + "%");
                try {
                    UpdateUtils.downloadFile(u, file);
                }
                catch (Exception e) {
                    System.out.println(Message.getFormatString("file.download.nook", new Object[]{u}));
                    needToRecheck = true;
                    if (++retry != 2) break block9;
                    fail.put(u, file.getAbsolutePath());
                }
            }
            JarLoader.loadjar(new JarLoader((URLClassLoader)ClassLoader.getSystemClassLoader()), file.getParent());
        }
        b2.close();
        if (needToRecheck && retry < 3) {
            needToRecheck = false;
            System.out.println(Message.getFormatString("update.retry", new Object[]{retry}));
            DownloadLibraries.run();
        } else {
            if (fileChannel != null) {
                fileChannel.close();
            }
            System.out.println(Message.getString("libraries.checking.end"));
            if (!fail.isEmpty()) {
                System.out.println(Message.getString("libraries.cant.start.server"));
                for (String lib : fail.keySet()) {
                    System.out.println("Link : " + lib + "\nPath : " + fail.get(lib));
                }
            }
        }
    }

    static {
        fail = new HashMap();
    }
}

