/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;

public enum Instrument {
    PIANO(0),
    BASS_DRUM(1),
    SNARE_DRUM(2),
    STICKS(3),
    BASS_GUITAR(4),
    FLUTE(5),
    BELL(6),
    GUITAR(7),
    CHIME(8),
    XYLOPHONE(9);

    private static final Map<Byte, Instrument> BY_DATA;
    private final byte type;

    private Instrument(int type) {
        this.type = (byte)type;
    }

    public static Instrument getByType(byte type) {
        return BY_DATA.get(type);
    }

    public byte getType() {
        return this.type;
    }

    static {
        BY_DATA = Maps.newHashMap();
        for (Instrument instrument : Instrument.values()) {
            BY_DATA.put(instrument.getType(), instrument);
        }
    }
}

