/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.utils.srgutils;

import com.mohistmc.bukkit.nms.utils.srgutils.IMappingFile;
import com.mohistmc.bukkit.nms.utils.srgutils.IRenamer;
import com.mohistmc.bukkit.nms.utils.srgutils.InternalUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class MappingFile
implements IMappingFile {
    private Map<String, Package> packages = new HashMap<String, Package>();
    private Collection<Package> packagesView = Collections.unmodifiableCollection(this.packages.values());
    private Map<String, Cls> classes = new HashMap<String, Cls>();
    private Collection<Cls> classesView = Collections.unmodifiableCollection(this.classes.values());
    private Map<String, String> cache = new HashMap<String, String>();
    private static final Pattern DESC = Pattern.compile("L(?<cls>[^;]+);");

    MappingFile() {
    }

    public Collection<Package> getPackages() {
        return this.packagesView;
    }

    @Override
    @Nullable
    public Package getPackage(String original) {
        return this.packages.get(original);
    }

    Package addPackage(String original, String mapped) {
        return this.packages.put(original, new Package(original, mapped));
    }

    public Collection<Cls> getClasses() {
        return this.classesView;
    }

    @Override
    @Nullable
    public Cls getClass(String original) {
        return this.classes.get(original);
    }

    Cls addClass(String original, String mapped) {
        Cls ret = new Cls(original, mapped);
        this.classes.put(original, ret);
        return ret;
    }

    Cls getOrCreateClass(String original) {
        return this.classes.computeIfAbsent(original, k -> new Cls(original, original));
    }

    @Override
    public String remapPackage(String pkg) {
        Package ipkg = this.packages.get(pkg);
        return ipkg == null ? pkg : ipkg.getMapped();
    }

    @Override
    public String remapClass(String cls) {
        String ret = this.cache.get(cls);
        if (ret == null) {
            int idx;
            Cls _cls = this.classes.get(cls);
            ret = _cls == null ? ((idx = cls.lastIndexOf(36)) != -1 ? this.remapClass(cls.substring(0, idx)) + '$' + cls.substring(idx + 1) : cls) : _cls.getMapped();
            this.cache.put(cls, ret);
        }
        return ret;
    }

    @Override
    public String remapDescriptor(String desc) {
        Matcher matcher = DESC.matcher(desc);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(matcher.group("cls")) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Override
    public void write(Path path, IMappingFile.Format format, boolean reversed) throws IOException {
        ArrayList lines = new ArrayList();
        Comparator sort = reversed ? (a2, b2) -> a2.getMapped().compareTo(b2.getMapped()) : (a2, b2) -> a2.getOriginal().compareTo(b2.getOriginal());
        this.getPackages().stream().sorted(sort).map(e -> e.write(format, reversed)).forEachOrdered(lines::add);
        this.getClasses().stream().sorted(sort).forEachOrdered(cls -> {
            lines.add(cls.write(format, reversed));
            cls.getFields().stream().sorted(sort).map(e -> e.write(format, reversed)).forEachOrdered(lines::add);
            cls.getMethods().stream().sorted(sort).map(e -> e.write(format, reversed)).forEachOrdered(lines::add);
        });
        if (!format.isOrdered()) {
            Comparator linesort = format == IMappingFile.Format.SRG || format == IMappingFile.Format.XSRG ? InternalUtils::compareLines : (o1, o2) -> o1.compareTo((String)o2);
            Collections.sort(lines, linesort);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (String line : lines) {
                writer.write(line);
                writer.write(10);
            }
        }
    }

    @Override
    public MappingFile reverse() {
        MappingFile ret = new MappingFile();
        this.getPackages().stream().forEach(e -> ret.addPackage(e.getMapped(), e.getOriginal()));
        this.getClasses().stream().forEach(cls -> {
            Cls c2 = ret.addClass(cls.getMapped(), cls.getOriginal());
            cls.getFields().stream().forEach(fld -> c2.addField(fld.getMapped(), fld.getOriginal(), fld.getMappedDescriptor()));
            cls.getMethods().stream().forEach(mtd -> c2.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), mtd.getOriginal(), ((Cls.Method)mtd).start, ((Cls.Method)mtd).end));
        });
        return ret;
    }

    @Override
    public MappingFile rename(IRenamer renamer) {
        MappingFile ret = new MappingFile();
        this.getPackages().stream().forEach(e -> ret.addPackage(e.getOriginal(), renamer.rename((IMappingFile.IPackage)e)));
        this.getClasses().stream().forEach(cls -> {
            Cls c2 = ret.addClass(cls.getOriginal(), renamer.rename((IMappingFile.IClass)cls));
            cls.getFields().stream().forEach(fld -> c2.addField(fld.getOriginal(), renamer.rename((IMappingFile.IField)fld), fld.getDescriptor()));
            cls.getMethods().stream().forEach(mtd -> c2.addMethod(mtd.getOriginal(), mtd.getDescriptor(), renamer.rename((IMappingFile.IMethod)mtd), ((Cls.Method)mtd).start, ((Cls.Method)mtd).end));
        });
        return ret;
    }

    @Override
    public MappingFile chain(final IMappingFile link) {
        return this.rename(new IRenamer(){

            @Override
            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IClass value) {
                return link.remapClass(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null ? value.getMapped() : cls.remapField(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null ? value.getMapped() : cls.remapMethod(value.getMapped(), value.getMappedDescriptor());
            }
        });
    }

    class Cls
    extends Node
    implements IMappingFile.IClass {
        private Map<String, Field> fields;
        private Collection<Field> fieldsView;
        private Map<String, Method> methods;
        private Collection<Method> methodsView;

        protected Cls(String original, String mapped) {
            super(original, mapped);
            this.fields = new HashMap<String, Field>();
            this.fieldsView = Collections.unmodifiableCollection(this.fields.values());
            this.methods = new HashMap<String, Method>();
            this.methodsView = Collections.unmodifiableCollection(this.methods.values());
        }

        @Override
        public String write(IMappingFile.Format format, boolean reversed) {
            String oName = !reversed ? this.getOriginal() : this.getMapped();
            String mName = !reversed ? this.getMapped() : this.getOriginal();
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "CL: " + oName + ' ' + mName;
                }
                case CSRG: 
                case TSRG: {
                    return oName + ' ' + mName;
                }
                case PG: {
                    return oName.replace('/', '.') + " -> " + mName.replace('/', '.') + ':';
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public Collection<Field> getFields() {
            return this.fieldsView;
        }

        @Override
        public String remapField(String field) {
            Field fld = this.fields.get(field);
            return fld == null ? field : fld.getMapped();
        }

        void addField(String original, String mapped) {
            this.fields.put(original, new Field(original, mapped));
        }

        void addField(String original, String mapped, String desc) {
            this.fields.put(original, new Field(original, mapped, desc));
        }

        public Collection<Method> getMethods() {
            return this.methodsView;
        }

        void addMethod(String original, String desc, String mapped) {
            this.methods.put(original + desc, new Method(original, desc, mapped));
        }

        void addMethod(String original, String desc, String mapped, int start, int end) {
            this.methods.put(original + desc, new Method(original, desc, mapped, start, end));
        }

        @Override
        public String remapMethod(String name, String desc) {
            Method mtd = this.methods.get(name + desc);
            return mtd == null ? name : mtd.getMapped();
        }

        public String toString() {
            return this.write(IMappingFile.Format.SRG, false);
        }

        class Method
        extends Node
        implements IMappingFile.IMethod {
            private String desc;
            private int start;
            private int end;

            private Method(String original, String desc, String mapped) {
                this(original, desc, mapped, 0, 0);
            }

            private Method(String original, String desc, String mapped, int start, int end) {
                super(original, mapped);
                this.end = 0;
                this.desc = desc;
                this.start = start;
                this.end = end;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            @Override
            public String getMappedDescriptor() {
                return MappingFile.this.remapDescriptor(this.desc);
            }

            @Override
            public String write(IMappingFile.Format format, boolean reversed) {
                String oName = !reversed ? this.getOriginal() : this.getMapped();
                String mName = !reversed ? this.getMapped() : this.getOriginal();
                String oOwner = !reversed ? Cls.this.getOriginal() : Cls.this.getMapped();
                String mOwner = !reversed ? Cls.this.getMapped() : Cls.this.getOriginal();
                String oDesc = !reversed ? this.getDescriptor() : this.getMappedDescriptor();
                String mDesc = !reversed ? this.getMappedDescriptor() : this.getDescriptor();
                switch (format) {
                    case SRG: 
                    case XSRG: {
                        return "MD: " + oOwner + '/' + oName + ' ' + oDesc + ' ' + mOwner + '/' + mName + ' ' + mDesc;
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case TSRG: {
                        return '\t' + oName + ' ' + oDesc + ' ' + mName;
                    }
                    case PG: {
                        return "    " + (this.start == 0 && this.end == 0 ? "" : this.start + ":" + this.end + ":") + InternalUtils.toSource(oName, oDesc) + " -> " + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            public String toString() {
                return this.write(IMappingFile.Format.SRG, false);
            }

            @Override
            public Cls getParent() {
                return Cls.this;
            }
        }

        class Field
        extends Node
        implements IMappingFile.IField {
            private String desc;

            private Field(String original, String mapped) {
                this(original, mapped, (String)null);
            }

            private Field(String original, String mapped, String desc) {
                super(original, mapped);
                this.desc = desc;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            @Override
            public String getMappedDescriptor() {
                return this.desc == null ? null : MappingFile.this.remapDescriptor(this.desc);
            }

            @Override
            public String write(IMappingFile.Format format, boolean reversed) {
                if ((format == IMappingFile.Format.PG || format == IMappingFile.Format.XSRG) && this.desc == null) {
                    throw new IllegalStateException("Can not write ProGuard format, field is missing descriptor");
                }
                String oOwner = !reversed ? Cls.this.getOriginal() : Cls.this.getMapped();
                String mOwner = !reversed ? Cls.this.getMapped() : Cls.this.getOriginal();
                String oName = !reversed ? this.getOriginal() : this.getMapped();
                String mName = !reversed ? this.getMapped() : this.getOriginal();
                String oDesc = !reversed ? this.getDescriptor() : this.getMappedDescriptor();
                String mDesc = !reversed ? this.getMappedDescriptor() : this.getDescriptor();
                switch (format) {
                    case SRG: {
                        return "FD: " + oOwner + '/' + oName + ' ' + mOwner + '/' + mName + (oDesc == null ? "" : " # " + oDesc + " " + mDesc);
                    }
                    case XSRG: {
                        return "FD: " + oOwner + '/' + oName + (oDesc == null ? "" : ' ' + oDesc) + ' ' + mOwner + '/' + mName + (mDesc == null ? "" : ' ' + mDesc);
                    }
                    case CSRG: {
                        return oOwner + ' ' + oName + ' ' + mName;
                    }
                    case TSRG: {
                        return '\t' + oName + ' ' + mName;
                    }
                    case PG: {
                        return "    " + InternalUtils.toSource(oDesc) + ' ' + oName + " -> " + mName;
                    }
                }
                throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
            }

            public String toString() {
                return this.write(IMappingFile.Format.SRG, false);
            }

            @Override
            public Cls getParent() {
                return Cls.this;
            }
        }
    }

    class Package
    extends Node
    implements IMappingFile.IPackage {
        protected Package(String original, String mapped) {
            super(original, mapped);
        }

        @Override
        public String write(IMappingFile.Format format, boolean reversed) {
            String smap;
            String sorig = this.getOriginal().isEmpty() ? "." : this.getOriginal();
            String string = smap = this.getMapped().isEmpty() ? "." : this.getMapped();
            if (reversed) {
                String tmp = sorig;
                sorig = smap;
                smap = tmp;
            }
            switch (format) {
                case SRG: 
                case XSRG: {
                    return "PK: " + sorig + ' ' + smap;
                }
                case CSRG: 
                case TSRG: {
                    return this.getOriginal() + "/ " + this.getMapped() + '/';
                }
                case PG: {
                    throw new UnsupportedOperationException("ProGuard format does not support packages.");
                }
            }
            throw new UnsupportedOperationException("Unknown format: " + (Object)((Object)format));
        }

        public String toString() {
            return this.write(IMappingFile.Format.SRG, false);
        }
    }

    abstract class Node
    implements IMappingFile.INode {
        protected String original;
        protected String mapped;

        protected Node(String original, String mapped) {
            this.original = original;
            this.mapped = mapped;
        }

        @Override
        public String getOriginal() {
            return this.original;
        }

        @Override
        public String getMapped() {
            return this.mapped;
        }
    }
}

