/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.bukkit.nms.utils.srgutils;

import com.mohistmc.bukkit.nms.utils.srgutils.IRenamer;
import com.mohistmc.bukkit.nms.utils.srgutils.InternalUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nullable;

public interface IMappingFile {
    public static IMappingFile load(File path) throws IOException {
        try (FileInputStream in2 = new FileInputStream(path);){
            IMappingFile iMappingFile = IMappingFile.load(in2);
            return iMappingFile;
        }
    }

    public static IMappingFile load(InputStream in2) throws IOException {
        return InternalUtils.load(in2);
    }

    public Collection<? extends IPackage> getPackages();

    public IPackage getPackage(String var1);

    public Collection<? extends IClass> getClasses();

    public IClass getClass(String var1);

    public String remapPackage(String var1);

    public String remapClass(String var1);

    public String remapDescriptor(String var1);

    public void write(Path var1, Format var2, boolean var3) throws IOException;

    public IMappingFile reverse();

    public IMappingFile rename(IRenamer var1);

    public IMappingFile chain(IMappingFile var1);

    public static interface IMethod
    extends IOwnedNode<IClass> {
        public String getDescriptor();

        public String getMappedDescriptor();
    }

    public static interface IField
    extends IOwnedNode<IClass> {
        @Nullable
        public String getDescriptor();

        @Nullable
        public String getMappedDescriptor();
    }

    public static interface IOwnedNode<T>
    extends INode {
        public T getParent();
    }

    public static interface IClass
    extends INode {
        public Collection<? extends IField> getFields();

        public Collection<? extends IMethod> getMethods();

        public String remapField(String var1);

        public String remapMethod(String var1, String var2);
    }

    public static interface IPackage
    extends INode {
    }

    public static interface INode {
        public String getOriginal();

        public String getMapped();

        public String write(Format var1, boolean var2);
    }

    public static enum Format {
        SRG(false),
        XSRG(false),
        CSRG(false),
        TSRG(true),
        PG(true);

        private boolean ordered = true;

        private Format(boolean ordered) {
            this.ordered = ordered;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public static Format get(String name) {
            name = name.toUpperCase(Locale.ENGLISH);
            for (Format value : Format.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return null;
        }
    }
}

