/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util.pluginmanager;

import com.mohistmc.util.i18n.Message;
import com.mohistmc.util.pluginmanager.Control;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginManagers {
    public static boolean hasPermission(CommandSender sender) {
        if (sender != Bukkit.getServer().getConsoleSender()) {
            if (sender.isOp()) {
                return true;
            }
            sender.sendMessage(Message.getString("command.nopermission"));
            return false;
        }
        return true;
    }

    public static boolean loadPluginCommand(CommandSender sender, String label, String[] split) {
        PluginDescriptionFile desc;
        if (!PluginManagers.hasPermission(sender)) {
            return true;
        }
        if (split.length < 2) {
            Object[] f = new Object[]{label};
            sender.sendMessage(Message.getFormatString("pluginscommand.load", f));
            return true;
        }
        Object[] objects = new Object[]{split[1]};
        String jarName = split[1] + (split[1].endsWith(".jar") ? "" : ".jar");
        File toLoad = new File("plugins" + File.separator + jarName);
        if (!toLoad.exists()) {
            jarName = split[1] + (split[1].endsWith(".jar") ? ".unloaded" : ".jar.unloaded");
            toLoad = new File("plugins" + File.separator + jarName);
            if (!toLoad.exists()) {
                sender.sendMessage(Message.getFormatString("pluginscommand.nofile", objects));
                return true;
            }
            String fileName = jarName.substring(0, jarName.length() - ".unloaded".length());
            toLoad = new File("plugins" + File.separator + fileName);
            File unloaded = new File("plugins" + File.separator + jarName);
            unloaded.renameTo(toLoad);
        }
        if ((desc = Control.getDescription(toLoad)) == null) {
            sender.sendMessage(Message.getFormatString("pluginscommand.noyml", objects));
            return true;
        }
        Plugin[] pl2 = Bukkit.getPluginManager().getPlugins();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(Arrays.asList(pl2));
        for (Plugin p2 : plugins) {
            if (!desc.getName().equals(p2.getName())) continue;
            sender.sendMessage(Message.getFormatString("pluginscommand.alreadyloaded", new Object[]{desc.getName()}));
            return true;
        }
        Plugin p3 = Control.loadPlugin(toLoad);
        if (p3 != null) {
            Bukkit.getServer().getPluginManager().enablePlugin(p3);
            sender.sendMessage(Message.getFormatString("pluginscommand.loaded", new Object[]{p3.getDescription().getName(), p3.getDescription().getVersion()}));
        } else {
            sender.sendMessage(Message.getFormatString("pluginscommand.notload", objects));
        }
        return true;
    }

    public static boolean unloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (!PluginManagers.hasPermission(sender)) {
            return true;
        }
        if (split.length < 2) {
            sender.sendMessage(Message.getFormatString("pluginscommand.unload", new Object[]{label}));
            return true;
        }
        Plugin p2 = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        Object[] objects = new Object[]{split[1]};
        if (p2 == null) {
            sender.sendMessage(Message.getFormatString("pluginscommand.noplugin", objects));
        } else if (Control.unloadPlugin(p2)) {
            sender.sendMessage(Message.getFormatString("pluginscommand.unloaded", new Object[]{p2.getDescription().getName(), p2.getDescription().getVersion()}));
        } else {
            sender.sendMessage(Message.getFormatString("pluginscommand.notunload", objects));
        }
        return true;
    }

    public static boolean reloadPluginCommand(CommandSender sender, String label, String[] split) {
        if (!PluginManagers.hasPermission(sender)) {
            return true;
        }
        if (split.length < 2) {
            sender.sendMessage(Message.getFormatString("pluginscommand.reload", new Object[]{label}));
            return true;
        }
        Plugin p2 = Bukkit.getServer().getPluginManager().getPlugin(split[1]);
        Object[] objects = new Object[]{split[1]};
        if (p2 == null) {
            sender.sendMessage(Message.getFormatString("pluginscommand.noplugin", objects));
        } else {
            File file = Control.getFile((JavaPlugin)p2);
            if (file == null) {
                sender.sendMessage(Message.getFormatString("pluginscommand.nojar", new Object[]{p2.getName()}));
                return true;
            }
            File name = new File("plugins" + File.separator + file.getName());
            JavaPlugin loaded = null;
            if (!Control.unloadPlugin(p2)) {
                sender.sendMessage(Message.getFormatString("pluginscommand.unloaderror", objects));
            } else {
                loaded = (JavaPlugin)Control.loadPlugin(name);
                if (loaded == null) {
                    sender.sendMessage(Message.getFormatString("pluginscommand.nojar", objects));
                }
            }
            Bukkit.getPluginManager().enablePlugin(loaded);
            sender.sendMessage(Message.getFormatString("pluginscommand.reloaded", new Object[]{split[1], loaded.getDescription().getVersion()}));
        }
        return true;
    }
}

