/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class PaperMCConfig {
    private static File CONFIG_FILE;
    private static final String HEADER = "This is the main configuration file for Paper.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n\nIf you need help with the configuration or have any questions related to Paper,\njoin us in our IRC channel.\n\nIRC: #paper @ irc.spi.gt ( http://irc.spi.gt/iris/?channels=paper )\nWiki: https://paper.readthedocs.org/ \nPaper Forums: https://aquifermc.org/ \n";
    public static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    private static boolean verbose;
    private static boolean metricsStarted;
    private static final Pattern SPACE;
    private static final Pattern NOT_NUMERIC;
    public static int minChunkLoadThreads;
    public static boolean enableFileIOThreadSleep;
    public static boolean loadPermsBeforePlugins;
    public static int regionFileCacheSize;
    public static boolean enablePlayerCollisions;
    public static boolean saveEmptyScoreboardTeams;
    public static boolean bungeeOnlineMode;
    public static int packetInSpamThreshold;
    public static String flyingKickPlayerMessage;
    public static String flyingKickVehicleMessage;
    public static int playerAutoSaveRate;
    public static int maxPlayerAutoSavePerTick;
    public static boolean removeInvalidStatistics;
    public static boolean suggestPlayersWhenNullTabCompletions;
    public static String authenticationServersDownKickMessage;
    public static boolean savePlayerData;
    public static boolean useAlternativeLuckFormula;
    public static int tabSpamIncrement;
    public static int tabSpamLimit;
    public static int maxBookPageSize;
    public static double maxBookTotalSizeMultiplier;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load paper.yml, please correct your syntax errors", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        verbose = PaperMCConfig.getBoolean("verbose", false);
        commands = new HashMap<String, Command>();
        version = PaperMCConfig.getInt("config-version", 13);
        PaperMCConfig.set("config-version", 13);
        PaperMCConfig.readConfig(PaperMCConfig.class, null);
    }

    protected static void logError(String s) {
        Bukkit.getLogger().severe(s);
    }

    protected static void log(String s) {
        if (verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    public static int getSeconds(String str) {
        double num;
        str = SPACE.matcher(str).replaceAll("");
        char unit = str.charAt(str.length() - 1);
        str = NOT_NUMERIC.matcher(str).replaceAll("");
        try {
            num = Double.parseDouble(str);
        }
        catch (Exception e) {
            num = 0.0;
        }
        switch (unit) {
            case 'd': {
                num *= 86400.0;
                break;
            }
            case 'h': {
                num *= 3600.0;
                break;
            }
            case 'm': {
                num *= 60.0;
                break;
            }
        }
        return (int)num;
    }

    protected static String timeSummary(int seconds) {
        String time = "";
        if (seconds > 86400) {
            time = time + TimeUnit.SECONDS.toDays(seconds) + "d";
            seconds %= 86400;
        }
        if (seconds > 3600) {
            time = time + TimeUnit.SECONDS.toHours(seconds) + "h";
            seconds %= 3600;
        }
        if (seconds > 0) {
            time = time + TimeUnit.SECONDS.toMinutes(seconds) + "m";
        }
        return time;
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, def);
        return config.getDouble(path, config.getDouble(path));
    }

    private static float getFloat(String path, float def) {
        return (float)PaperMCConfig.getDouble(path, def);
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static void timings() {
        boolean timings = PaperMCConfig.getBoolean("timings.enabled", true);
        boolean verboseTimings = PaperMCConfig.getBoolean("timings.verbose", true);
        TimingsManager.privacy = PaperMCConfig.getBoolean("timings.server-name-privacy", false);
        TimingsManager.hiddenConfigs = PaperMCConfig.getList("timings.hidden-config-entries", Lists.newArrayList((Object[])new String[]{"database", "settings.bungeecord-addresses"}));
        int timingHistoryInterval = PaperMCConfig.getInt("timings.history-interval", 300);
        int timingHistoryLength = PaperMCConfig.getInt("timings.history-length", 3600);
        Timings.setVerboseTimingsEnabled(verboseTimings);
        Timings.setTimingsEnabled(timings);
        Timings.setHistoryInterval(timingHistoryInterval * 20);
        Timings.setHistoryLength(timingHistoryLength * 20);
        PaperMCConfig.log("Timings: " + timings + " - Verbose: " + verboseTimings + " - Interval: " + PaperMCConfig.timeSummary(Timings.getHistoryInterval() / 20) + " - Length: " + PaperMCConfig.timeSummary(Timings.getHistoryLength() / 20));
    }

    private static void chunkLoadThreads() {
        minChunkLoadThreads = Math.min(6, PaperMCConfig.getInt("settings.min-chunk-load-threads", 2));
    }

    private static void enableFileIOThreadSleep() {
        enableFileIOThreadSleep = PaperMCConfig.getBoolean("settings.sleep-between-chunk-saves", false);
        if (enableFileIOThreadSleep) {
            Bukkit.getLogger().info("Enabled sleeping between chunk saves, beware of memory issues");
        }
    }

    private static void loadPermsBeforePlugins() {
        loadPermsBeforePlugins = PaperMCConfig.getBoolean("settings.load-permissions-yml-before-plugins", true);
    }

    private static void regionFileCacheSize() {
        regionFileCacheSize = PaperMCConfig.getInt("settings.region-file-cache-size", 256);
    }

    private static void enablePlayerCollisions() {
        enablePlayerCollisions = PaperMCConfig.getBoolean("settings.enable-player-collisions", true);
    }

    private static void saveEmptyScoreboardTeams() {
        saveEmptyScoreboardTeams = PaperMCConfig.getBoolean("settings.save-empty-scoreboard-teams", false);
    }

    private static void bungeeOnlineMode() {
        bungeeOnlineMode = PaperMCConfig.getBoolean("settings.bungee-online-mode", true);
    }

    private static void packetInSpamThreshold() {
        if (version < 11) {
            int oldValue = PaperMCConfig.getInt("settings.play-in-use-item-spam-threshold", 300);
            PaperMCConfig.set("settings.incoming-packet-spam-threshold", oldValue);
        }
        packetInSpamThreshold = PaperMCConfig.getInt("settings.incoming-packet-spam-threshold", 300);
    }

    private static void flyingKickMessages() {
        flyingKickPlayerMessage = PaperMCConfig.getString("messages.kick.flying-player", flyingKickPlayerMessage);
        flyingKickVehicleMessage = PaperMCConfig.getString("messages.kick.flying-vehicle", flyingKickVehicleMessage);
    }

    private static void playerAutoSaveRate() {
        playerAutoSaveRate = PaperMCConfig.getInt("settings.player-auto-save-rate", -1);
        maxPlayerAutoSavePerTick = PaperMCConfig.getInt("settings.max-player-auto-save-per-tick", -1);
        if (maxPlayerAutoSavePerTick == -1) {
            maxPlayerAutoSavePerTick = playerAutoSaveRate == -1 || playerAutoSaveRate > 100 ? 10 : 20;
        }
    }

    private static void removeInvalidStatistics() {
        if (version < 12) {
            boolean oldValue = PaperMCConfig.getBoolean("remove-invalid-statistics", false);
            PaperMCConfig.set("settings.remove-invalid-statistics", oldValue);
        }
        removeInvalidStatistics = PaperMCConfig.getBoolean("settings.remove-invalid-statistics", false);
    }

    private static void suggestPlayersWhenNull() {
        suggestPlayersWhenNullTabCompletions = PaperMCConfig.getBoolean("settings.suggest-player-names-when-null-tab-completions", suggestPlayersWhenNullTabCompletions);
    }

    private static void authenticationServersDownKickMessage() {
        authenticationServersDownKickMessage = Strings.emptyToNull((String)PaperMCConfig.getString("messages.kick.authentication-servers-down", authenticationServersDownKickMessage));
    }

    private static void savePlayerData() {
        if (!(savePlayerData = PaperMCConfig.getBoolean("settings.save-player-data", savePlayerData))) {
            Bukkit.getLogger().log(Level.WARNING, "Player Data Saving is currently disabled. Any changes to your players data, such as inventories, experience points, advancements and the like will not be saved when they log out.");
        }
    }

    private static void useAlternativeLuckFormula() {
        useAlternativeLuckFormula = PaperMCConfig.getBoolean("settings.use-alternative-luck-formula", false);
        if (useAlternativeLuckFormula) {
            Bukkit.getLogger().log(Level.INFO, "Using Aikar's Alternative Luck Formula to apply Luck attribute to all loot pool calculations. See https://luckformula.emc.gs");
        }
    }

    private static void tabSpamLimiters() {
        tabSpamIncrement = PaperMCConfig.getInt("settings.spam-limiter.tab-spam-increment", tabSpamIncrement);
        tabSpamLimit = PaperMCConfig.getInt("settings.spam-limiter.tab-spam-limit", tabSpamLimit);
    }

    private static void maxBookSize() {
        maxBookPageSize = PaperMCConfig.getInt("settings.book-size.page-max", maxBookPageSize);
        maxBookTotalSizeMultiplier = PaperMCConfig.getDouble("settings.book-size.total-multiplier", maxBookTotalSizeMultiplier);
        if (maxBookPageSize == 1024 && maxBookTotalSizeMultiplier == 0.9) {
            config.set("settings.book-size.page-max", 2560);
            config.set("settings.book-size.total-multiplier", 0.98);
            maxBookPageSize = 2560;
            maxBookTotalSizeMultiplier = 0.98;
        }
    }

    static {
        SPACE = Pattern.compile(" ");
        NOT_NUMERIC = Pattern.compile("[^-\\d.]");
        minChunkLoadThreads = 2;
        loadPermsBeforePlugins = true;
        regionFileCacheSize = 256;
        enablePlayerCollisions = true;
        saveEmptyScoreboardTeams = false;
        bungeeOnlineMode = true;
        packetInSpamThreshold = 300;
        flyingKickPlayerMessage = "Flying is not enabled on this server";
        flyingKickVehicleMessage = "Flying is not enabled on this server";
        playerAutoSaveRate = -1;
        maxPlayerAutoSavePerTick = 10;
        removeInvalidStatistics = false;
        suggestPlayersWhenNullTabCompletions = true;
        authenticationServersDownKickMessage = "";
        savePlayerData = true;
        useAlternativeLuckFormula = false;
        tabSpamIncrement = 10;
        tabSpamLimit = 500;
        maxBookPageSize = 2560;
        maxBookTotalSizeMultiplier = 0.98;
    }
}

