/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.mohistmc.configuration.MohistConfig;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.InvalidVersionSpecificationException;
import net.minecraftforge.fml.common.versioning.VersionRange;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkModHolder {
    private static int assignedIds = 1;
    private int localId;
    private int networkId;
    private ModContainer container;
    private Method checkHandler;
    private VersionRange acceptableRange;
    private NetworkChecker checker;
    private boolean acceptsVanillaClient;
    private boolean acceptsVanillaServer;

    public NetworkModHolder(ModContainer container) {
        this.container = container;
        this.networkId = this.localId = assignedIds++;
    }

    public NetworkModHolder(ModContainer container, NetworkChecker checker) {
        this(container);
        this.checker = (NetworkChecker)Preconditions.checkNotNull((Object)checker);
        FMLLog.log.debug("The mod {} is using a custom checker {}", (Object)container.getModId(), (Object)checker.getClass().getName());
    }

    public NetworkModHolder(ModContainer container, Class<?> modClass, @Nullable String acceptableVersionRange, ASMDataTable table) {
        block16: {
            this(container);
            SetMultimap<String, ASMDataTable.ASMData> annotationTable = table.getAnnotationsFor(container);
            Set versionCheckHandlers = annotationTable != null ? annotationTable.get((Object)NetworkCheckHandler.class.getName()) : ImmutableSet.of();
            String networkCheckHandlerMethod = null;
            Method[] methodArray = versionCheckHandlers.iterator();
            while (methodArray.hasNext()) {
                ASMDataTable.ASMData vch = (ASMDataTable.ASMData)methodArray.next();
                if (!vch.getClassName().equals(modClass.getName())) continue;
                networkCheckHandlerMethod = vch.getObjectName();
                networkCheckHandlerMethod = networkCheckHandlerMethod.substring(0, networkCheckHandlerMethod.indexOf(40));
                break;
            }
            if (versionCheckHandlers.isEmpty()) {
                for (Method m : modClass.getMethods()) {
                    if (!m.isAnnotationPresent(NetworkCheckHandler.class)) continue;
                    if (m.getParameterTypes().length == 2 && m.getParameterTypes()[0].equals(Map.class) && m.getParameterTypes()[1].equals(Side.class)) {
                        this.checkHandler = m;
                        break;
                    }
                    FMLLog.log.fatal("Found unexpected method signature for annotation NetworkCheckHandler");
                }
            }
            if (networkCheckHandlerMethod != null) {
                try {
                    Method checkHandlerMethod = modClass.getDeclaredMethod(networkCheckHandlerMethod, Map.class, Side.class);
                    if (checkHandlerMethod.isAnnotationPresent(NetworkCheckHandler.class)) {
                        this.checkHandler = checkHandlerMethod;
                    }
                }
                catch (Exception e) {
                    if ("checkModLists".equals(networkCheckHandlerMethod)) break block16;
                    FMLLog.log.warn("The declared version check handler method {} on network mod id {} is not accessible", (Object)networkCheckHandlerMethod, (Object)container.getModId(), (Object)e);
                }
            }
        }
        if (this.checkHandler != null) {
            this.checker = new MethodNetworkChecker();
        } else if (!Strings.isNullOrEmpty((String)acceptableVersionRange) && acceptableVersionRange.equals("*")) {
            this.checker = new IgnoredChecker();
        } else {
            try {
                this.acceptableRange = VersionRange.createFromVersionSpec(acceptableVersionRange);
            }
            catch (InvalidVersionSpecificationException e) {
                FMLLog.log.warn("Invalid bounded range {} specified for network mod id {}", (Object)acceptableVersionRange, (Object)container.getModId(), (Object)e);
            }
            this.checker = new DefaultNetworkChecker();
        }
        FMLLog.log.trace("Mod {} is using network checker : {}", (Object)container.getModId(), (Object)this.checker);
        FMLLog.log.trace("Testing mod {} to verify it accepts its own version in a remote connection", (Object)container.getModId());
        boolean acceptsSelf = this.acceptVersion(container.getVersion());
        if (!acceptsSelf) {
            FMLLog.log.fatal("The mod {} appears to reject its own version number ({}) in its version handling. This is likely a severe bug in the mod!", (Object)container.getModId(), (Object)container.getVersion());
        } else {
            FMLLog.log.trace("The mod {} accepts its own version ({})", (Object)container.getModId(), (Object)container.getVersion());
        }
    }

    public boolean acceptVersion(String version) {
        if (this.acceptableRange != null) {
            return this.acceptableRange.containsVersion(new DefaultArtifactVersion(version));
        }
        return this.container.getVersion().equals(version);
    }

    public boolean check(Map<String, String> data, Side side) {
        return this.checker.checkCompatible(data, side) == null;
    }

    @Nullable
    public String checkCompatible(Map<String, String> data, Side side) {
        return this.checker.checkCompatible(data, side);
    }

    public int getLocalId() {
        return this.localId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public ModContainer getContainer() {
        return this.container;
    }

    public void setNetworkId(int value) {
        this.networkId = value;
    }

    public void testVanillaAcceptance() {
        this.acceptsVanillaClient = this.check((Map<String, String>)ImmutableMap.of(), Side.CLIENT);
        this.acceptsVanillaServer = this.check((Map<String, String>)ImmutableMap.of(), Side.SERVER);
    }

    public boolean acceptsVanilla(Side from) {
        return from == Side.CLIENT ? this.acceptsVanillaClient : this.acceptsVanillaServer;
    }

    private class MethodNetworkChecker
    extends NetworkChecker {
        private MethodNetworkChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return this.checkCompatible(remoteVersions, side) == null;
        }

        @Override
        @Nullable
        public String checkCompatible(Map<String, String> remoteVersions, Side side) {
            try {
                Boolean result = (Boolean)NetworkModHolder.this.checkHandler.invoke(NetworkModHolder.this.container.getMod(), new Object[]{remoteVersions, side});
                if (result != null && result.booleanValue()) {
                    return null;
                }
                return String.format("Failed mod's custom NetworkCheckHandler %s", NetworkModHolder.this.container);
            }
            catch (Exception e) {
                FMLLog.log.error("Error occurred invoking NetworkCheckHandler {} at {}", (Object)NetworkModHolder.this.checkHandler.getName(), (Object)NetworkModHolder.this.container, (Object)e);
                return String.format("Error occurred invoking NetworkCheckHandler %s at %s", NetworkModHolder.this.checkHandler.getName(), NetworkModHolder.this.container);
            }
        }

        public String toString() {
            return String.format("Invoking method %s", NetworkModHolder.this.checkHandler.getName());
        }
    }

    private class DefaultNetworkChecker
    extends NetworkChecker {
        private DefaultNetworkChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return this.checkCompatible(remoteVersions, side) == null;
        }

        @Override
        @Nullable
        public String checkCompatible(Map<String, String> remoteVersions, Side side) {
            String version = remoteVersions.get(NetworkModHolder.this.container.getModId());
            if (version != null && NetworkModHolder.this.acceptVersion(version)) {
                return null;
            }
            if (side == Side.SERVER) {
                return null;
            }
            String versionString = NetworkModHolder.this.acceptableRange != null ? (NetworkModHolder.this.acceptableRange.hasRestrictions() ? String.format(MohistConfig.instance.requirementsModVersion.getValue(), NetworkModHolder.this.acceptableRange.toStringFriendly()) : String.format(MohistConfig.instance.requirementsModVersionRange.getValue(), NetworkModHolder.this.acceptableRange.toStringFriendly())) : String.format(MohistConfig.instance.requirementsModVersion.getValue(), NetworkModHolder.this.container.getVersion());
            if (version != null) {
                return String.format(MohistConfig.instance.requirementsModInvalidVersion.getValue(), versionString, version);
            }
            return String.format(MohistConfig.instance.requirementsModNotFound.getValue(), versionString);
        }

        public String toString() {
            return NetworkModHolder.this.acceptableRange != null ? String.format("Accepting range %s", NetworkModHolder.this.acceptableRange.toStringFriendly()) : String.format("Accepting version %s", NetworkModHolder.this.container.getVersion());
        }
    }

    private class IgnoredChecker
    extends NetworkChecker {
        private IgnoredChecker() {
        }

        @Override
        public boolean check(Map<String, String> remoteVersions, Side side) {
            return true;
        }

        @Override
        @Nullable
        public String checkCompatible(Map<String, String> remoteVersions, Side side) {
            return null;
        }

        public String toString() {
            return "No network checking performed";
        }
    }

    public abstract class NetworkChecker {
        @Deprecated
        public abstract boolean check(Map<String, String> var1, Side var2);

        @Nullable
        public String checkCompatible(Map<String, String> remoteVersions, Side side) {
            return this.check(remoteVersions, side) ? this.toString() : null;
        }
    }
}

