/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeMessage;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.EntitySpawnHandler;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.network.internal.FMLRuntimeCodec;
import net.minecraftforge.fml.common.network.internal.HandshakeCompletionHandler;
import net.minecraftforge.fml.common.network.internal.NetworkModHolder;
import net.minecraftforge.fml.common.network.internal.OpenGuiHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_12_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_12_R1.inventory.CraftInventoryView;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import red.mohist.configuration.MohistConfig;

public class FMLNetworkHandler {
    public static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("fml.readTimeout", "30"));
    public static final int LOGIN_TIMEOUT = Integer.parseInt(System.getProperty("fml.loginTimeout", "600"));
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void fmlServerHandshake(pl scm, gw manager, oq player) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(manager, scm);
        dispatcher.serverToClientHandshake(player);
    }

    public static void fmlClientHandshake(gw networkManager) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(networkManager);
        dispatcher.clientToServerHandshake();
    }

    public static void openGui(aed entityPlayer, Object mod, int modGuiId, amu world, int x, int y, int z) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (entityPlayer instanceof oq && !(entityPlayer instanceof FakePlayer)) {
            oq entityPlayerMP = (oq)entityPlayer;
            afr remoteGuiContainer = NetworkRegistry.INSTANCE.getRemoteGuiContainer(mc, entityPlayerMP, modGuiId, world, x, y, z);
            if (remoteGuiContainer != null) {
                if (remoteGuiContainer.getBukkitView() == null) {
                    avj tileEntity = entityPlayer.l.r(new et(x, y, z));
                    if (tileEntity instanceof tv) {
                        CraftInventory inventory = new CraftInventory((tv)tileEntity);
                        remoteGuiContainer.setBukkitView((InventoryView)new CraftInventoryView(entityPlayer.getBukkitEntity(), inventory, remoteGuiContainer));
                    } else {
                        remoteGuiContainer.setBukkitView((InventoryView)new CraftInventoryView(entityPlayer.getBukkitEntity(), Bukkit.createInventory((InventoryHolder)entityPlayer.getBukkitEntity(), InventoryType.CHEST), remoteGuiContainer));
                    }
                }
                if ((remoteGuiContainer = CraftEventFactory.callInventoryOpenEvent((oq)entityPlayer, remoteGuiContainer, false)) == null) {
                    return;
                }
                entityPlayerMP.dx();
                entityPlayerMP.r();
                int windowId = entityPlayerMP.cw;
                FMLMessage.OpenGui openGui = new FMLMessage.OpenGui(windowId, mc.getModId(), modGuiId, x, y, z);
                EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayerMP);
                embeddedChannel.writeOutbound(new Object[]{openGui});
                entityPlayerMP.by = remoteGuiContainer;
                entityPlayerMP.by.d = windowId;
                entityPlayerMP.by.a((afx)entityPlayerMP);
                MinecraftForge.EVENT_BUS.post(new PlayerContainerEvent.Open(entityPlayer, entityPlayer.by));
            }
        } else if (!(entityPlayer instanceof FakePlayer)) {
            if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
                Object guiContainer = NetworkRegistry.INSTANCE.getLocalGuiContainer(mc, entityPlayer, modGuiId, world, x, y, z);
                FMLCommonHandler.instance().showGuiScreen(guiContainer);
            } else {
                FMLLog.log.debug("Invalid attempt to open a local GUI on a dedicated server. This is likely a bug. GUI ID: {},{}", (Object)mc.getModId(), (Object)modGuiId);
            }
        }
    }

    @Nullable
    public static ht<?> getEntitySpawningPacket(vg entity) {
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er == null) {
            return null;
        }
        if (er.usesVanillaSpawning()) {
            return null;
        }
        return channelPair.get((Object)Side.SERVER).generatePacketFrom(new FMLMessage.EntitySpawnMessage(er, entity, er.getContainer()));
    }

    @Nullable
    public static String checkModList(FMLHandshakeMessage.ModList modListPacket, Side side) {
        Map<String, String> modList = modListPacket.modList();
        return FMLNetworkHandler.checkModList(modList, side);
    }

    @Nullable
    public static String checkModList(Map<String, String> listData, Side side) {
        List rejects = NetworkRegistry.INSTANCE.registry().entrySet().stream().map(entry -> Pair.of(entry.getKey(), (Object)((NetworkModHolder)entry.getValue()).checkCompatible(listData, side))).filter(pair -> pair.getValue() != null).sorted(Comparator.comparing(o -> ((ModContainer)o.getKey()).getName())).collect(Collectors.toList());
        ArrayList hackpacks = Lists.newArrayList();
        ArrayList<String> rejectStrings = new ArrayList<String>();
        for (Pair reject : rejects) {
            ModContainer modContainer = (ModContainer)reject.getKey();
            rejectStrings.add(modContainer.getName() + ": " + (String)reject.getValue());
            String name = ((ModContainer)reject.getKey()).getName().toLowerCase() + ((ModContainer)reject.getKey()).getModId().toLowerCase();
            if (!rejects.isEmpty() || !name.contains("cjb") && !name.contains("kradxns") && !name.contains("chestfinder") && !name.contains("cheating") && !name.contains("xray") && !name.contains("radarbro") && !name.contains("zyin")) continue;
            hackpacks.add(reject.getKey());
        }
        if (rejects.isEmpty()) {
            if (!hackpacks.isEmpty()) {
                FMLLog.info("[Mohist] Rejecting hacker %s: %s", new Object[]{side, hackpacks});
                return String.format(MohistConfig.instance.rejectionsHackMessage.getValue(), hackpacks);
            }
            return null;
        }
        String rejectString = String.join((CharSequence)"\n", rejectStrings);
        FMLLog.log.info("Rejecting connection {}: {}", (Object)side, (Object)rejectString);
        return String.format(MohistConfig.instance.rejectionsServerModsMessage.getValue(), rejectString);
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        ChannelPipeline pipeline = channelPair.get((Object)Side.CLIENT).pipeline();
        String targetName = channelPair.get((Object)Side.CLIENT).findChannelHandlerNameForType(FMLRuntimeCodec.class);
        pipeline.addAfter(targetName, "GuiHandler", (ChannelHandler)new OpenGuiHandler());
        pipeline.addAfter(targetName, "EntitySpawnHandler", (ChannelHandler)new EntitySpawnHandler());
    }

    public static void registerChannel(FMLContainer container, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(container, "FML", new ChannelHandler[]{new FMLRuntimeCodec(), new HandshakeCompletionHandler()});
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        if (side == Side.CLIENT) {
            FMLNetworkHandler.addClientHandlers();
        }
    }

    public static List<FMLProxyPacket> forwardHandshake(FMLMessage.CompleteHandshake push, NetworkDispatcher target, Side side) {
        channelPair.get((Object)side).attr(NetworkDispatcher.FML_DISPATCHER).set((Object)target);
        channelPair.get((Object)side).writeOutbound(new Object[]{push});
        ArrayList<FMLProxyPacket> list = new ArrayList<FMLProxyPacket>();
        for (Object o : channelPair.get((Object)side).outboundMessages()) {
            list.add((FMLProxyPacket)o);
        }
        channelPair.get((Object)side).outboundMessages().clear();
        return list;
    }

    public static void enhanceStatusQuery(JsonObject jsonobject) {
        JsonObject fmlData = new JsonObject();
        fmlData.addProperty("type", MohistConfig.instance.server_type.getValue());
        JsonArray modList = new JsonArray();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            JsonObject modData = new JsonObject();
            modData.addProperty("modid", mc.getModId());
            modData.addProperty("version", mc.getVersion());
            modList.add((JsonElement)modData);
        }
        fmlData.add("modList", (JsonElement)modList);
        jsonobject.add("modinfo", (JsonElement)fmlData);
    }
}

