/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_12_R1.util;

import com.mojang.util.QueueLogAppender;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_12_R1.command.ColouredConsoleSender;

public class TerminalConsoleWriterThread
implements Runnable {
    private static final byte[] RESET_LINE = String.valueOf('\r').getBytes();
    private static final Map<String, BlockingQueue<String>> QUEUES;
    private static final ReadWriteLock QUEUE_LOCK;
    private final ConsoleReader reader;
    private final OutputStream output;
    private BlockingQueue<String> queue = null;

    public TerminalConsoleWriterThread(OutputStream output, ConsoleReader reader) {
        this.output = output;
        this.reader = reader;
    }

    @Override
    public void run() {
        while (this.queue == null) {
            QUEUE_LOCK.readLock().lock();
            this.queue = QUEUES.get("TerminalConsole");
            QUEUE_LOCK.readLock().unlock();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        while (true) {
            try {
                while (true) {
                    String message = (String)this.queue.poll();
                    if (Main.useJline) {
                        this.output.write(RESET_LINE);
                        this.output.write(ColouredConsoleSender.toAnsiStr(message).getBytes());
                        this.output.flush();
                        try {
                            this.reader.drawLine();
                        }
                        catch (Throwable ex2) {
                            this.reader.getCursorBuffer().clear();
                        }
                        this.reader.flush();
                        continue;
                    }
                    this.output.write(message.getBytes());
                    this.output.flush();
                }
            }
            catch (IOException ex3) {
                Logger.getLogger(TerminalConsoleWriterThread.class.getName()).log(Level.SEVERE, null, ex3);
                continue;
            }
            break;
        }
    }

    static {
        Field f2 = null;
        try {
            f2 = QueueLogAppender.class.getDeclaredField("QUEUES");
            f2.setAccessible(true);
            QUEUES = (Map)f2.get(null);
            f2 = QueueLogAppender.class.getDeclaredField("QUEUE_LOCK");
            f2.setAccessible(true);
            QUEUE_LOCK = (ReadWriteLock)f2.get(null);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

