/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IEntitySelectorFactory;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;
    private static List<IEntitySelectorFactory> entitySelectorFactories;
    private static Map<String, Boolean> configWorldGenCache;
    public static Map<String, String> worldGenMap;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        String modId = Loader.instance().activeModContainer().getModId();
        modId = modId.replaceAll("[^A-Za-z0-9]", "");
        modId = modId.replace(" ", "_");
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
        worldGenMap.put(generator.getClass().getName(), modId);
    }

    public static void registerEntitySelector(IEntitySelectorFactory factory, String ... arguments) {
        entitySelectorFactories.add(factory);
        for (String s : arguments) {
            bq.c((String)s);
        }
    }

    public static List<Predicate<vg>> createEntitySelectors(Map<String, String> arguments, String mainSelector, bn sender, bhe position) {
        ArrayList selectors = Lists.newArrayList();
        for (IEntitySelectorFactory factory : entitySelectorFactories) {
            try {
                selectors.addAll(factory.createPredicates(arguments, mainSelector, sender, position));
            }
            catch (Exception e2) {
                FMLLog.log.error("Exception caught during entity selector creation with {} for argument map {} of {} for {} at {}", (Object)factory, arguments, (Object)mainSelector, (Object)sender, (Object)position, (Object)e2);
            }
        }
        return selectors;
    }

    public static void generateWorld(int chunkX, int chunkZ, amu world, axq chunkGenerator, axr chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.Q();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        for (IWorldGenerator generator : worldGenerators) {
            if (!configWorldGenCache.containsKey(generator.getClass().getName())) {
                String modId = worldGenMap.get(generator.getClass().getName());
                String generatorName = "";
                generatorName = modId + "-" + generator.getClass().getSimpleName();
                boolean generatorEnabled = world.mohistConfig.getBoolean("worldgen-" + generatorName, true);
                configWorldGenCache.put(generator.getClass().getName(), generatorEnabled);
            }
            if (!configWorldGenCache.get(generator.getClass().getName()).booleanValue()) continue;
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        list.sort(Comparator.comparingInt(o -> worldGeneratorIndex.get(o)));
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    private static <K extends IForgeRegistryEntry<K>> K register(K object) {
        return GameData.register_impl(object);
    }

    public static <K extends IForgeRegistryEntry<K>> IForgeRegistry<K> findRegistry(Class<K> registryType) {
        return RegistryManager.ACTIVE.getRegistry(registryType);
    }

    public static void addShapedRecipe(nf name, nf group, @Nonnull aip output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped(params);
        GameRegistry.register(new akw(group == null ? "" : group.toString(), primer.width, primer.height, primer.input, output).setRegistryName(name));
    }

    public static void addShapelessRecipe(nf name, nf group, @Nonnull aip output, akq ... params) {
        fi lst = fi.a();
        for (akq i2 : params) {
            lst.add((Object)i2);
        }
        GameRegistry.register(new akx(group == null ? "" : group.toString(), output, lst).setRegistryName(name));
    }

    public static void addSmelting(aow input, @Nonnull aip output, float xp) {
        akp.a().a(input, output, xp);
    }

    public static void addSmelting(ain input, @Nonnull aip output, float xp) {
        akp.a().a(input, output, xp);
    }

    public static void addSmelting(@Nonnull aip input, @Nonnull aip output, float xp) {
        akp.a().a(input, output, xp);
    }

    @Deprecated
    public static void registerTileEntity(Class<? extends avj> tileEntityClass, String key) {
        GameData.checkPrefix(new nf(key).toString(), true);
        avj.a((String)key, tileEntityClass);
    }

    public static void registerTileEntity(Class<? extends avj> tileEntityClass, nf key) {
        GameRegistry.registerTileEntity(tileEntityClass, key.toString());
    }

    @Deprecated
    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    @Deprecated
    public static int getFuelValue(@Nonnull aip itemStack) {
        return ForgeEventFactory.getItemBurnTime(itemStack);
    }

    @Deprecated
    public static int getFuelValueLegacy(@Nonnull aip itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    @Nonnull
    public static aip makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        ain item = ForgeRegistries.ITEMS.getValue(new nf(itemName));
        if (item == null) {
            FMLLog.log.trace("Unable to find item with name {}", (Object)itemName);
            return aip.a;
        }
        aip is = new aip(item, stackSize, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            try {
                is.b(gp.a((String)nbtString));
            }
            catch (go e2) {
                throw new RuntimeException("Encountered an exception parsing ItemStack NBT string " + nbtString, e2);
            }
        }
        return is;
    }

    static {
        entitySelectorFactories = Lists.newArrayList();
        configWorldGenCache = Maps.newHashMap();
        worldGenMap = Maps.newHashMap();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ItemStackHolder {
        public String value();

        public int meta() default 0;

        public String nbt() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ObjectHolder {
        public String value();
    }
}

