/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.libraries.CustomLibraries;
import com.mohistmc.libraries.DefaultLibraries;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.AutoDeleteMods;
import com.mohistmc.util.AutoDeletePlugins;
import com.mohistmc.util.CustomFlagsHandler;
import com.mohistmc.util.EulaUtil;
import com.mohistmc.util.InstallUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.LoggingPrintStream;
import com.mohistmc.util.PluginsModsDelete;
import com.mohistmc.util.i18n.i18n;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Scanner;
import net.minecraftforge.server.ServerMain;
import org.apache.logging.log4j.Level;

public class MohistMCStart {
    public static String getVersion() {
        return MohistMCStart.class.getPackage().getImplementationVersion() != null ? MohistMCStart.class.getPackage().getImplementationVersion() : "unknown";
    }

    public static void main() throws Exception {
        MohistConfigUtil.copyMohistConfig();
        CustomFlagsHandler.handleCustomArgs();
        if (MohistConfigUtil.bMohist("show_logo", "true").booleanValue()) {
            System.out.println("\n\n __    __   ______   __  __   __   ______   ______  \n/\\ \"-./  \\ /\\  __ \\ /\\ \\_\\ \\ /\\ \\ /\\  ___\\ /\\__  _\\ \n\\ \\ \\-./\\ \\\\ \\ \\/\\ \\\\ \\  __ \\\\ \\ \\\\ \\___  \\\\/_/\\ \\/ \n \\ \\_\\ \\ \\_\\\\ \\_____\\\\ \\_\\ \\_\\\\ \\_\\\\/\\_____\\  \\ \\_\\ \n  \\/_/  \\/_/ \\/_____/ \\/_/\\/_/ \\/_/ \\/_____/   \\/_/ \n                                                    \n\n                                      " + i18n.get("mohist.launch.welcomemessage") + " - " + MohistMCStart.getVersion() + ", Java " + ServerMain.javaVersion);
        }
        if ((double)ServerMain.javaVersion <= 52.0) {
            System.out.println(i18n.get("oldjava.use"));
        }
        if (MohistConfigUtil.bMohist("check_libraries", "true").booleanValue()) {
            DefaultLibraries.run();
            InstallUtils.startInstallation();
        }
        CustomLibraries.loadCustomLibs();
        new JarLoader().loadJar(InstallUtils.extra);
        new JarLoader().loadJar(InstallUtils.universalJar);
        if ((double)ServerMain.javaVersion >= 60.0) {
            Class.forName("com.mohistmc.util.MohistModuleManager", false, URLClassLoader.newInstance(new URL[]{InstallUtils.universalJar.toURI().toURL()})).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        Class.forName("com.google.gson.internal.bind.TypeAdapters$EnumTypeAdapter").getClassLoader();
        Class.forName("net.minecraftforge.eventbus.EventBus").getClassLoader();
        System.setOut(new LoggingPrintStream("STDOUT", System.out, Level.INFO));
        System.setErr(new LoggingPrintStream("STDERR", System.err, Level.ERROR));
        UpdateUtils.versionCheck();
        if (ServerMain.mainArgs.contains("-noserver")) {
            System.exit(0);
        }
        if (!EulaUtil.hasAcceptedEULA()) {
            System.out.println(i18n.get("eula"));
            while (!"true".equals(new Scanner(System.in).next())) {
            }
            EulaUtil.writeInfos();
        }
        if (!MohistConfigUtil.bMohist("disable_plugins_blacklist", "false").booleanValue()) {
            PluginsModsDelete.checkPlugins(AutoDeletePlugins.LIST, PluginsModsDelete.PLUGIN);
        }
        if (!MohistConfigUtil.bMohist("disable_mods_blacklist", "false").booleanValue()) {
            PluginsModsDelete.checkPlugins(AutoDeleteMods.LIST, PluginsModsDelete.MOD);
        }
    }
}

