/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.util.i18n.i18n;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    CHINA("http://s1.devicloud.cn:25119/"),
    GITHUB("https://mavenmirror.mohistmc.com/");

    String url;
    public static DownloadSource defaultSource;

    private DownloadSource(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public static DownloadSource get() throws IOException {
        String ds = MohistConfigUtil.sMohist("libraries_downloadsource", defaultSource.name());
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            if (DownloadSource.isDown(me.url) != 200) {
                return GITHUB;
            }
            return me;
        }
        return defaultSource;
    }

    public static int isDown(String s) throws IOException {
        URL url = new URL(s);
        URLConnection rulConnection = url.openConnection();
        HttpURLConnection httpUrlConnection = (HttpURLConnection)rulConnection;
        httpUrlConnection.connect();
        return httpUrlConnection.getResponseCode();
    }

    static {
        defaultSource = i18n.isCN() ? CHINA : MOHIST;
    }
}

