/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.action;

import com.mohistmc.MohistMCStart;
import com.mohistmc.tools.FileUtils;
import com.mohistmc.tools.MD5Util;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.JarLoader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public abstract class Action {
    private static final PrintStream origin = System.out;
    public String mohistVer = DataParser.versionMap.get("mohist");
    public String forgeVer = DataParser.versionMap.get("forge");
    public String mcpVer = DataParser.versionMap.get("mcp");
    public String mcVer = DataParser.versionMap.get("minecraft");
    public String libPath = new File(MohistMCStart.jarTool.getJarDir(), "libraries").getAbsolutePath() + "/";
    public String forgeStart = this.libPath + "net/minecraftforge/forge/" + this.mcVer + "-" + this.forgeVer + "/forge-" + this.mcVer + "-" + this.forgeVer;
    public File universalJar = new File(this.forgeStart + "-universal.jar");
    public File serverJar = new File(this.forgeStart + "-server.jar");
    public File lzma = new File(this.libPath + "com/mohistmc/installation/data/server.lzma");
    public File installInfo = new File(this.libPath + "com/mohistmc/installation/installInfo");
    public String otherStart = this.libPath + "net/minecraft/server/" + this.mcVer + "-" + this.mcpVer + "/server-" + this.mcVer + "-" + this.mcpVer;
    public File extra = new File(this.otherStart + "-extra.jar");
    public File slim = new File(this.otherStart + "-slim.jar");
    public File srg = new File(this.otherStart + "-srg.jar");
    public String mcpStart = this.libPath + "de/oceanlabs/mcp/mcp_config/" + this.mcVer + "-" + this.mcpVer + "/mcp_config-" + this.mcVer + "-" + this.mcpVer;
    public File mcpZip = new File(this.mcpStart + ".zip");
    public File mcpTxt = new File(this.mcpStart + "-mappings.txt");
    public File minecraft_server = new File(this.libPath + "net/minecraft/server/" + this.mcVer + "/server-" + this.mcVer + ".jar");

    protected Action() {
    }

    protected void run(String mainClass, String[] args, List<URL> classPath) throws Exception {
        try {
            Class.forName(mainClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e.getMessage());
            return;
        }
        URLClassLoader loader = URLClassLoader.newInstance(classPath.toArray(new URL[0]));
        Class.forName(mainClass, true, loader).getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
        loader.clearAssertionStatus();
        loader.close();
    }

    protected List<URL> stringToUrl(List<String> strs) throws Exception {
        ArrayList<URL> temp = new ArrayList<URL>();
        for (String t : strs) {
            File file = new File(t);
            JarLoader.loadJar(file.toPath());
            temp.add(file.toURI().toURL());
        }
        return temp;
    }

    protected void mute() throws Exception {
        File out = new File(this.libPath + "com/mohistmc/installation", "installationLogs.txt");
        if (!out.exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(out))));
    }

    protected void unmute() {
        System.setOut(origin);
    }

    protected void copyFileFromJar(File file, String pathInJar) {
        InputStream is = MohistMCStart.class.getClassLoader().getResourceAsStream(pathInJar);
        if (!file.exists() || !MD5Util.get(file).equals(MD5Util.get(is)) || file.length() <= 1L) {
            File parentfile = file.getParentFile();
            if (file.getAbsolutePath().contains("minecraftforge")) {
                int lastSlashIndex = parentfile.getAbsolutePath().replaceAll("\\\\", "/").lastIndexOf("/");
                String result = parentfile.getAbsolutePath().substring(0, lastSlashIndex + 1);
                File old = new File(result);
                if (old.exists()) {
                    FileUtils.deleteFolders(old);
                }
            }
            file.getParentFile().mkdirs();
            if (is != null) {
                try {
                    file.createNewFile();
                    Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {}
            } else {
                System.out.println("[Mohist] The file " + file.getName() + " doesn't exists in the Mohist jar !");
                System.exit(0);
            }
        }
    }

    protected boolean isCorrupted(File f) {
        try {
            JarFile j = new JarFile(f);
            j.close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public boolean checkDependencies() throws IOException {
        if (this.installInfo.exists()) {
            String jarmd = MD5Util.get(MohistMCStart.jarTool.getFile());
            List<String> lines = Files.readAllLines(this.installInfo.toPath());
            return lines.size() < 2 || !jarmd.equals(lines.get(1));
        }
        return true;
    }

    protected static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    Action.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }
}

