/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util.i18n;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.util.i18n.UTF8Control;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class i18n {
    public static List<String> b = Arrays.asList("fr_FR", "ru_RU", "zh_CN", "zh_TW");
    public static Map<String, String> CACHE = new ConcurrentHashMap<String, String>();
    private static ResourceBundle rb;
    private static List<String> a;

    public static String get(String key) {
        rb = ResourceBundle.getBundle("lang.message", new Locale(i18n.getLanguage(), i18n.getCountry()), new UTF8Control());
        String string = rb.getString(key);
        if (CACHE.containsKey(key)) {
            return CACHE.get(key);
        }
        CACHE.put(key, string);
        return string;
    }

    public static String get(String key, Object ... f) {
        return new MessageFormat(i18n.get(key)).format(f);
    }

    public static String getLocale(int key) {
        String locale = MohistConfigUtil.sMohist("lang", "xx_XX");
        if (locale.length() == 5) {
            if (key == 1) {
                return locale.substring(0, 2);
            }
            if (key == 2) {
                return locale.substring(3, 5);
            }
        }
        return "xx";
    }

    public static String getVanillaLanguage() {
        String locale = MohistConfigUtil.sMohist("lang", "en_us");
        if (locale.length() == 5 && a.contains(locale.toLowerCase())) {
            return locale.toLowerCase();
        }
        return "en_us";
    }

    public static String getLanguage() {
        return i18n.getLocale(1);
    }

    public static String getCountry() {
        return i18n.getLocale(2);
    }

    public static String getLocale() {
        return i18n.getLanguage() + "_" + i18n.getCountry();
    }

    public static boolean isCN() {
        TimeZone timeZone = TimeZone.getDefault();
        return timeZone.getID().equals("Asia/Shanghai") || rb.getLocale().getCountry().equals("CN");
    }

    static {
        a = Arrays.asList("en_us", "es_es", "fr_fr", "ru_ru", "zh_cn", "zh_tw");
    }
}

