/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.MohistMCStart;
import com.mohistmc.network.download.NetworkUtil;
import com.mohistmc.util.MD5Util;
import java.io.File;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.Timer;
import java.util.TimerTask;

public class UpdateUtils {
    private static int percentage = 0;

    public static void downloadFile(String URL2, File f) throws Exception {
        UpdateUtils.downloadFile(URL2, f, null);
    }

    public static void downloadFile(String URL2, final File f, String md5) throws Exception {
        URLConnection conn = NetworkUtil.getConn(URL2);
        System.out.println(MohistMCStart.i18n.get("download.file", f.getName(), UpdateUtils.getSize(conn.getContentLength())));
        final ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        final int fS = conn.getContentLength();
        final Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (rbc.isOpen()) {
                    if (percentage != Math.round((float)f.length() / (float)fS * 100.0f) && percentage < 100) {
                        System.out.println(MohistMCStart.i18n.get("file.download.percentage", f.getName(), percentage));
                    }
                    percentage = Math.round((float)f.length() / (float)fS * 100.0f);
                } else {
                    t.cancel();
                }
            }
        }, 3000L, 1000L);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        percentage = 0;
        String MD5 = MD5Util.getMd5(f);
        if (f.getName().endsWith(".jar") && md5 != null && MD5 != null && !MD5.equals(md5.toLowerCase())) {
            f.delete();
            System.out.println(MohistMCStart.i18n.get("file.download.nook.md5", URL2, MD5, md5.toLowerCase()));
            throw new Exception("md5");
        }
        System.out.println(MohistMCStart.i18n.get("download.file.ok", f.getName()));
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }
}

