/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.yaml;

import com.google.common.base.Preconditions;
import com.mohistmc.yaml.Configuration;
import com.mohistmc.yaml.ConfigurationSection;
import com.mohistmc.yaml.MemoryConfigurationOptions;
import com.mohistmc.yaml.MemorySection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryConfiguration
extends MemorySection
implements Configuration {
    protected Configuration defaults;
    protected MemoryConfigurationOptions options;

    public MemoryConfiguration() {
    }

    public MemoryConfiguration(@Nullable Configuration defaults) {
        this.defaults = defaults;
    }

    @Override
    public void addDefault(@NotNull String path, @Nullable Object value) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Path may not be null");
        if (this.defaults == null) {
            this.defaults = new MemoryConfiguration();
        }
        this.defaults.set(path, value);
    }

    @Override
    public void addDefaults(@NotNull Map<String, Object> defaults) {
        Preconditions.checkArgument((defaults != null ? 1 : 0) != 0, (Object)"Defaults may not be null");
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            this.addDefault(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void addDefaults(@NotNull Configuration defaults) {
        Preconditions.checkArgument((defaults != null ? 1 : 0) != 0, (Object)"Defaults may not be null");
        for (String key : defaults.getKeys(true)) {
            if (defaults.isConfigurationSection(key)) continue;
            this.addDefault(key, defaults.get(key));
        }
    }

    @Override
    @Nullable
    public Configuration getDefaults() {
        return this.defaults;
    }

    @Override
    public void setDefaults(@NotNull Configuration defaults) {
        Preconditions.checkArgument((defaults != null ? 1 : 0) != 0, (Object)"Defaults may not be null");
        this.defaults = defaults;
    }

    @Override
    @Nullable
    public ConfigurationSection getParent() {
        return null;
    }

    @Override
    @NotNull
    public MemoryConfigurationOptions options() {
        if (this.options == null) {
            this.options = new MemoryConfigurationOptions(this);
        }
        return this.options;
    }
}

