/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.i18n;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class i18n {
    public static Map<String, String> CURRENT_CACHE = new ConcurrentHashMap<String, String>();
    private static PropertyResourceBundle rb;
    private static final String properties = "message";
    private static Locale locale;
    private static InputStream inputStream;

    public i18n(ClassLoader classLoader, Locale locale) {
        i18n.locale = locale;
        String lang = "_" + locale.getLanguage() + "_" + locale.getCountry();
        InputStream deFinputStream = classLoader.getResourceAsStream("lang/message.properties");
        inputStream = classLoader.getResourceAsStream("lang/message" + lang + ".properties");
        if (inputStream == null) {
            inputStream = deFinputStream;
        } else if (inputStream == null) {
            System.out.println("invalid language file");
            System.exit(0);
        }
        rb = new PropertyResourceBundle(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public i18n(Class<?> classz, Locale locale) {
        i18n.locale = locale;
        String lang = "_" + locale.getLanguage() + "_" + locale.getCountry();
        InputStream deFinputStream = classz.getResourceAsStream("/lang/message.properties");
        inputStream = classz.getResourceAsStream("/lang/message" + lang + ".properties");
        if (inputStream == null) {
            inputStream = deFinputStream;
        } else if (inputStream == null) {
            System.out.println("invalid language file");
            System.exit(0);
        }
        rb = new PropertyResourceBundle(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    public String get(String key) {
        String string = rb.getString(key);
        if (CURRENT_CACHE.containsKey(key)) {
            return CURRENT_CACHE.get(key);
        }
        CURRENT_CACHE.put(key, string);
        return string;
    }

    public String get(String key, Object ... f) {
        return new MessageFormat(this.get(key)).format(f);
    }

    public boolean isCN() {
        TimeZone timeZone = TimeZone.getDefault();
        return "Asia/Shanghai".equals(timeZone.getID()) || "CN".equals(locale.getCountry());
    }

    public static Locale getLocale() {
        return locale;
    }
}

