/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.MohistMCStart;
import com.mohistmc.action.v_1_20;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.network.download.DownloadSource;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLibraries {
    public static final HashMap<String, String> fail = new HashMap();
    public static final AtomicLong allSize = new AtomicLong();
    public static final String MAVENURL = DownloadSource.get().getUrl();

    public static String libUrl(File lib) {
        return MAVENURL + "libraries/" + lib.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
    }

    public static void run() throws Exception {
        System.out.println(MohistMCStart.i18n.get("libraries.checking.start"));
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        AtomicLong currentSize = new AtomicLong();
        LinkedHashSet<File> defaultLibs = new LinkedHashSet<File>();
        for (File lib : libs.keySet()) {
            v_1_20.loadedLibsPaths.add(lib.getAbsolutePath());
            if (lib.exists() && MohistConfigUtil.yml.getStringList("libraries_black_list").contains(lib.getName())) continue;
            if (lib.exists() && MD5Util.getMd5(lib).equals(libs.get(lib))) {
                currentSize.addAndGet(lib.length());
                continue;
            }
            defaultLibs.add(lib);
        }
        for (File lib : defaultLibs) {
            lib.getParentFile().mkdirs();
            String u = DefaultLibraries.libUrl(lib);
            System.out.println(MohistMCStart.i18n.get("libraries.global.percentage", Math.round((float)(currentSize.get() * 100L) / (float)allSize.get()) + "%"));
            try {
                UpdateUtils.downloadFile(u, lib, libs.get(lib));
                JarLoader.loadJar(lib.toPath());
                currentSize.addAndGet(lib.length());
                fail.remove(u.replace(MAVENURL, ""));
            }
            catch (Exception e) {
                if (e.getMessage() != null && !"md5".equals(e.getMessage())) {
                    System.out.println(MohistMCStart.i18n.get("file.download.nook", u));
                    lib.delete();
                }
                fail.put(u.replace(MAVENURL, ""), lib.getAbsolutePath());
            }
        }
        if (!fail.isEmpty()) {
            DefaultLibraries.run();
        } else {
            System.out.println(MohistMCStart.i18n.get("libraries.check.end"));
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(Objects.requireNonNull(DefaultLibraries.class.getClassLoader().getResourceAsStream("libraries.txt"))));
        while ((str = b.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(JarTool.getJarDir() + "/" + s[0]), s[1]);
            allSize.addAndGet(Long.parseLong(s[2]));
        }
        b.close();
        return temp;
    }
}

