/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.action.v_1_20;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.feature.AutoDeleteMods;
import com.mohistmc.i18n.i18n;
import com.mohistmc.libraries.CustomLibraries;
import com.mohistmc.libraries.DefaultLibraries;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.EulaUtil;
import com.mohistmc.util.MohistModuleManager;
import cpw.mods.bootstraplauncher.BootstrapLauncher;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;

public class MohistMCStart {
    public static final List<String> mainArgs = new ArrayList<String>();
    public static i18n i18n;

    public static String getVersion() {
        return MohistMCStart.class.getPackage().getImplementationVersion() != null ? MohistMCStart.class.getPackage().getImplementationVersion() : "unknown";
    }

    public static void main(String[] args) throws Exception {
        mainArgs.addAll(List.of(args));
        DataParser.parseVersions();
        DataParser.parseLaunchArgs();
        MohistConfigUtil.copyMohistConfig();
        MohistConfigUtil.i18n();
        if (!MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.aBoolean("mohist.show_logo", true)) {
            String test = "\n __    __   ______   __  __   __   ______   ______\n/\\ \"-./  \\ /\\  __ \\ /\\ \\_\\ \\ /\\ \\ /\\  ___\\ /\\__  _\\\n\\ \\ \\-./\\ \\\\ \\ \\/\\ \\\\ \\  __ \\\\ \\ \\\\ \\___  \\\\/_/\\ \\/\n \\ \\_\\ \\ \\_\\\\ \\_____\\\\ \\_\\ \\_\\\\ \\_\\\\/\\_____\\  \\ \\_\\\n  \\/_/  \\/_/ \\/_____/ \\/_/\\/_/ \\/_/ \\/_____/   \\/_/\n\n\n%s - %s, Java(%s) %s\n";
            System.out.println(test.formatted(i18n.get("mohist.launch.welcomemessage"), MohistMCStart.getVersion(), System.getProperty("java.version"), System.getProperty("java.class.version")));
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", "log4j2_mohist.xml");
        }
        if (!MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.CHECK_UPDATE()) {
            UpdateUtils.versionCheck();
        }
        if (!MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.CHECK_LIBRARIES()) {
            DefaultLibraries.run();
        }
        if (!MohistConfigUtil.INSTALLATIONFINISHED()) {
            v_1_20.run();
        }
        AutoDeleteMods.jar();
        CustomLibraries.loadCustomLibs();
        ArrayList<String> forgeArgs = new ArrayList<String>();
        for (String arg : DataParser.launchArgs.stream().filter(s -> s.startsWith("--launchTarget") || s.startsWith("--fml.forgeVersion") || s.startsWith("--fml.mcVersion") || s.startsWith("--fml.forgeGroup") || s.startsWith("--fml.mcpVersion")).toList()) {
            forgeArgs.add(arg.split(" ")[0]);
            forgeArgs.add(arg.split(" ")[1]);
        }
        new MohistModuleManager(DataParser.launchArgs);
        if (!EulaUtil.hasAcceptedEULA()) {
            System.out.println(i18n.get("eula"));
            while (!"true".equals(new Scanner(System.in).next())) {
            }
            EulaUtil.writeInfos();
        }
        String[] args_ = (String[])Stream.concat(forgeArgs.stream(), mainArgs.stream()).toArray(String[]::new);
        BootstrapLauncher.main((String[])args_);
    }
}

